/*
 * Machine check handler and model dependent initialization.
 * 470V/6
 */

#include "../h/param.h"
#include "../h/systm.h"

#define IOEL    (*(int *)172)   /* I/O extended logout area addr */
#define MCFLA   0x100           /* fixed logout area */
#define CR14    0xA4000000      /* check stop, ioel, and ext damage */

struct {        /* CPU identification */
        char    version;
        int     serial;
        int     model;
} machine;

/*
 * VM extended identification information
 */
struct extid {
	char    sysname[8];   /* 'VM/370  ' */
	char    versnum, level, plc;
	char    verscode;
	short   maxmcel;
	short   cpuaddr;
	char    vmuser[8];    /* VM user ID */
	char    ppmap[8];     /* program product bit map */
} extid;


/*
 * 470V/6 version of machine check handler.
 * No MCEL, IOEL fits in fixed logout area.
 */
mckinit()
{
        long cpuid, a_stidp();
	extern char atetab[];

        cpuid = a_stidp();
        machine.version = cpuid >> 56;
        machine.serial = (cpuid >> 32) & 0xFFFFFF;
        machine.model = (cpuid >> 16) & 0xFFFF;
        if(machine.version == 0xFF) {
                vm = ISVM;
		d_extid(&extid, sizeof extid);
		if(!(extid.ppmap[0] == atetab['V'] && extid.ppmap[1] == atetab['M'])) {
			if(extid.ppmap[0] & 0x80) vm |= SEPP;
			if(extid.ppmap[0] & 0x40) vm |= BSEPP;
		}
        } else
                vm = 0;
        IOEL = MCFLA;
        a_lctl(14, 14, CR14);
}

mck()
{
        printf("Machine check!\n");
}
