/
/  p/n:
/  Program name:       Kernel Dumper
/  Author:             Ken Bowler
/  Backup:
/
/  Description:
/     This file contains assembler code used by the dump routine.
/     Mainly for doing standalone I/O/
/
CSW     = 64           / csw address
IOADDR  = 185          / address of I/O interrupt address
IOOPSW  = 56           / address of I/O old psw
IONPSW  = 120          / address of I/O new psw
CAW     = 72           / caw address

DIRSIZ  = 16           / size of a directory entry
                       / al2(inumber),cl(DIRSIZ-2)'name'


CE      = 8            / channel end
DE      = 4            / device end

UC      = 2            / unit check
CHANERR = 63           / channel error status



/ _a_stckc - store the clock comparator
/ ckc = _a_stckc()
/

        entry   _a_stckc
_a_stckc:
        using   .,r15

	s       sp,=f'4'               / drop the stack
	st      r8,0(sp)               / save for .data use
	l       r8,=a(.data)           / get .data
	using   .data,r8               / and use it
        stckc   _dbl                   / do it
        lm      r0,r1,_dbl             / return the clock comparator
	l       r8,0(sp)               / restore r8
	la      sp,4(sp)               / restore stack pointer
        br      r14                    / and that's it
        drop    r8
        drop    r15



/ _a_stctl - store all the control registers (for dump)
/ _a_stctl(address)
/ int   *address


        entry   _a_stctl
_a_stctl:
        using   .,r15
        l       r1,0(sp)               / where to store the registers
        stctl   0,15,0(r1)             / do it
        br      r14                    / that was an easy one
        drop    r15



/ dmpioini - set up for dump i/o by making sure disk is alright
/ dmpioini(devaddr) - returns 0 - ok, 1 - something wrong.

        entry   dmpioini
dmpioini:
        using   .,r15
        s       sp,=f'64'               / get some space to use
        stm     r0,r15,0(sp)            / save registers
        lr      r10,r15
        drop    r15
        using   dmpioini,r10
        spka    0                       / set psw key to avoid problems
        l       r1,64(sp)               / load disk address
        sr      r2,r2                   / check path with null CAW
        l       r15,=a(checkio)
        balr    r14,r15                 / see if we can talk to disk
        ltr     r0,r0
        lm      r1,r15,4(sp)            / restore registers
        la      sp,64(sp)               / restore stack pointer
        br      r14                     / and return
        drop    r10


/ dmpio - do the I/O for the dump, channel program already built
/ dmpio(devaddr,cpaddr) - returns 0 - ok, 1 - somthing went wrong
/ int  devaddr,cpaddr

        entry   dmpio
dmpio:
        using   .,r15
        s       sp,=f'64'               / get some space to use
        stm     r0,r15,0(sp)            / save registers
        lr      r10,r15
        drop    r15
        using   dmpio,r10
        l       r1,64(sp)               / pick up device address
        l       r2,68(sp)               / pick up CAW
        st      r2,CAW
dmpiolp:
        sio     0(r1)                   / start it up
        bc      8,dmpcheck              / started ok, wait it out
        bc      4,dmpclr
        bc      2,dmpiolp
        bc      1,dmpioerr

dmpclr: tio     0(r1)                   / clear status
        bc      8,dmpiolp
        bc      4,dmpclr
        bc      2,dmpclr
        bc      1,dmpioerr

dmpcheck:
        l       r15,=a(checkio);
        balr    r14,r15
dmprtrn:
        lm      r1,r15,4(sp)            / restore registers
        la      sp,64(sp)               / restore stack pointer
        br      r14                     / return

dmpioerr:
        la      r0,1                    / set return value 1 (error)
        b       dmprtrn                 / and return
        drop    r10



/
/ local subroutine to check out status of an i/o operation, and to
/ retry it if necessary
/
/ on entry, r1  - device address
/           r2  - CAW to use for retries, or zero if just checking device
/ returns   r0  - 0, ok
/           r0  - 1, unrecoverable error
/

checkio:
        using   .,r15
        s       sp,=f'12'            / back up stack
        st      r14,0(sp)            / save return address
	st      r8,8(sp)             / use for .data base reg
	l       r8,=a(.data)         / get the base reg
	using   .data,r8
        ltr     r2,r2                / checking an i/o operation?
        bz      chksense             / no, just do a sense
        la      r9,16                / retry count
chktloop:
        tio     0(r1)                / do the test i/o thing
        bc      8,chkok              / seems ok
        bc      4,chkcheck           / a csw stored , check it out
        bc      2,chktloop           / busy, loop until something happens
        bc      1,chkerr             / device is not operational, we quit

chkok:  sr      r0,r0                / set return value 0 (ok)
chkrtrn:
        l       r14,0(sp)            / pick up return address
	l       r8,8(sp)             / restore base register
        la      sp,12(sp)             / restore stack pointer
        br      r14                  / and return

chkerr: la      r0,1                 / set return value 1 (error)
        b       chkrtrn              / and return

chkcheck:               / check on a stored csw
        tm      CSW+5,CHANERR        / and channel problems?
        bnz     chkerr               / that's fatal for now
        tm      CSW+4,UC             / a unit check?
        bo      chksense             / yup, we must do a sense
        tm      CSW+4,DE             / device done?
        bo      chkok                / yup, ok
chksense:               / it is necessary to sense the device to find
/                         out what the matter is.
        la      r0,snsccw            / a ccw to do the sense
        st      r0,CAW
chksloop:
        sio     0(r1)                / start the sense
        bc      8,chkwait            / ok, wait for it to complete
        bc      4,chksnchk           / this shouldn't really happen here.. but?
        bc      2,chksloop           / should be bust at this time either
        bc      1,chkerr             / give up if device died

chkwait:                  / we do  a test i/o to wait
        tio     0(r1)
        bc      8,chksnchk           / csw should be stored first
        bc      4,chksnchk
        bc      2,chkwait
        bc      1,chkerr

chksnchk:                 / check out csw stored for sense
        tm      CSW+5,CHANERR        / any channel problems?
        bnz     chkerr               / yes, that's still fatal
        tm      CSW+4,UC             / we also choke on UC from sense
        bo      chkerr
        tm      CSW+4,CE+DE          / channel end and device end present?
        bno     chkerr               / well, why not??
        ltr     r2,r2                / should we retry some operation?
        bz      chkok                / nope, then done for now
/
/ see what good or bad news is revealed by the sense data
/
        tm      snsdata,x'80'        / command reject?
        bo      chkerr               / yes, something is seriously wrong
        tm      snsdata,x'40'        / is device not ready?
        bo      chknrdy
        tm      snsdata,x'3c'        / other kinds of errors
        bnz     chkretry             / yes, go retry
        tm      snsdata+1,x'fe'      / some kind of fatal condition?
        bnz     chkerr               / yes, give up
        tm      snsdata+2,x'10'      / was this environmental data?
        bo      chkok                / yes, groan. just ignore it
chkretry:
        tm      snsdata+1,x'fe'      / is a retry worth it?
        bnz     chkerr               / nope
        bct     r9,chkredo           / count down the number of retries
        b       chkerr               / looks serious

chkredo:
        st      r2,CAW               / set retry CAW (we retry the whole op)
        sio     0(r1)
        bc      8,chktloop           / back to beginning
        bc      4,chkcheck           / ???
        bc      2,chkredo            / shouldn't be busy, but?
        bc      1,chkerr

chknrdy: tio    0(r1)                / wait for device to get ready
        bc      8,chknrdy
        bc      4,chksense
        bc      2,chknrdy
        bc      1,chkerr
        drop    r8
        drop    r15

	ds      0d
snsccw: ccw    x'04',snsdata,x'20',24  / a ccw to sense a disk

	.data
_dbl:    ds     d                   / a handy double word
snsdata: ds     xl24                / where to putr disk sense data
	.text
        end
