typedef unsigned bit;

/*
 * Channel status word (64 bits)
 */
union csw {
	struct {
		bit     cs_key : 4;     /* protect key */
		bit     : 1;            /* unused */
		bit     cs_lop : 1;     /* logout pending */
		bit     cs_cc : 2;      /* condition code */
		bit     cs_addr : 24;   /* CCW address */
		/* unit status */
		bit     cs_attn : 1;    /* attention */
		bit     cs_sm : 1;      /* status modifier */
		bit     cs_cue : 1;     /* control unit end */
		bit     cs_busy : 1;    /* busy */
		bit     cs_ce : 1;      /* channel end */
		bit     cs_de : 1;      /* device end */
		bit     cs_uc : 1;      /* unit check */
		bit     cs_ue : 1;      /* unit exception */
		/* channel status */
		bit     cs_pci : 1;     /* program controlled interruption */
		bit     cs_il : 1;      /* incorrect length */
		bit     cs_progc : 1;   /* program check */
		bit     cs_protc : 1;   /* protection check */
		bit     cs_cdc : 1;     /* channel data check */
		bit     cs_ccc : 1;     /* channel control check */
		bit     cs_ifcc : 1;    /* interface control check */
		bit     cs_chc : 1;     /* channel chaining check */
		bit     cs_count : 16;  /* residual byte count */
	};
	struct {
		int     cs_word1;
		int     cs_word2;
	};
	long    cs_dblw;                /* for alignment and resetting */
};
 
/*
 * Channel Command Word (64 bits)
 */
union ccw {
	struct {
		bit     cc_cmd : 8;     /* command */
		bit     cc_addr : 24;   /* data address */
		bit     cc_cd : 1;      /* data chaining */
		bit     cc_cc : 1;      /* command chaining */
		bit     cc_sli : 1;     /* suppress length indicator */
		bit     cc_skip : 1;    /* skip data transfer */
		bit     cc_pci : 1;     /* program controlled interruption */
		bit     cc_ida : 1;     /* indirect data addressing */
		bit     : 10;           /* unused */
		bit     cc_count : 16;  /* byte count */
	};
	long    cc_dblw;                /* for alignment */
};

typedef union csw csw_t;
typedef union ccw ccw_t;
 
/*
 * Absolute addresses
 */
#define CSW     (*(union csw *)64)      /* channel status word */
#define CAW     (*(int *)72)            /* channel address word */
#define CHANID  (*(int *)168)           /* channel ID */
#define IOEL    (*(int *)172)           /* I/O extended logout addr */
#define LCL     (*(int *)176)           /* limited channel logout */
#define IOADDR  (*(short *)186)         /* device causing interrupt */

/*
 * Old style refernences to CSW and CCW
 */
#define LOP     0x04000000       /* logout pending */
#define DCC     0x03000000       /* deferred condition code */
#define DCC1    0x01000000       /* cond code = 1 */
#define DCC3    0x03000000       /* cond code = 3 */
#define ATTN    0x80000000       /* attention */
#define SM      0x40000000       /* status modifier */
#define CUE     0x20000000       /* control unit end */
#define XBUSY   0x10000000       /* busy */
#define CE      0x08000000       /* channel end */
#define DE      0x04000000       /* device end */
#define UC      0x02000000       /* unit check */
#define UE      0x01000000       /* unit exception */
#define PCI     0x00800000       /* program controlled interruption */
#define IL      0x00400000       /* incorrect length */
#define PROGCHK 0x00200000       /* program check */
#define PROTCHK 0x00100000       /* protection check */
#define UNITSTAT 0xff000000      /* unit status */
#define CHANCHEK 0x00370000      /* channel checks */
#define COUNT   0x0000ffff       /* residual count */
 
#define CD      0x80000000       /* data chaining */
#define CC      0x40000000       /* command chaining */
#define SLI     0x20000000       /* suppress incorrect length */
#define SKIP    0x10000000       /* skip data transfer */
#define PCIF    0x08000000       /* PCI request */
#define IDA     0x04000000       /* indirect data addressing */
