/
/ Function:
/   STRLEN returns length of string, not counting the ending null.
/
/ Calling Sequence:
/   len = strlen(string)  { char *string }
/
	entry   strlen
	using   strlen,15
strlen:
	lr      r0,sp
	s       sp,=f'64'
	stm     r0,r15,0(sp)
	st      0,52(,sp)
	lr      r12,sp

	l       r0,64(,sp)          / Get string address
        n       r0,=x'00ffffff'     / Clean up high order byte
	lr      r3,r0
	l       r4,=v(_strtabl)     / Get trt table address
	sr      r1,r1               / clear high byte for trt
0:
	trt     0(256,r3),0(r4)     / Scan for null
	bc      8,1f                / CC=0?  No null found
	sr      r1,r0               / Else calc length
	lr      r0,r1
	lm      r1,r15,4(r12)       / and return
	br      r14
1:
	la      r3,256(r3)          / Increment address
	b       0b                  / Continue scan
