#include <stdio.h>
#include <stdioerr.h>

rewind(iop)
	register struct _iobuf *iop;
{
	if (iop == NULL)
		return(_stdioerr(EFPNULL, "rewind"));
	if ((iop->_flag&_IOMEM) != 0) {
		_mrew(iop);
		return;
	}
	fflush(iop);
	seek(fileno(iop), 0, 0);
	iop->_cnt = 0;
	iop->_ptr = iop->_base;
	iop->_flag &= ~(_IOERR|_IOEOF);
	if (iop->_flag & _IORW)
		iop->_flag &= ~(_IOREAD|_IOWRT);
}
