#include "/usr/src/lib/c/c1/c13.c"
#define STRASG  121
#define SRCSTR  29
#define NSAVE   224
#define LINKDEF 225

FILE *fp;
static char buff[BUFSIZ];

/*
 * chalf - interprets the intermediate code from the C compiler
 */

main(argc, argv)
int argc;
char *argv[];{

	int op;

	setbuf(stdout, NULL);
	while (--argc){
		fp = fopen(*++argv, "r");
		for (;;){
			op = getw(fp);
			if ((op&017400) != 017000){
				printf("*** Unknown op: %o\n", op);
				if (op == -1) exit(1);
				continue;
				}
			if ((op&0377) == 0) return;
			display(op);
			}
		fclose(fp);
		}
	}

display(op)
int op;{

	register t;
	char s[64];

	switch(op =& 0377){
		case SINIT:
			printf("SINIT %d\n", getw(fp));
			break;
		case BDATA:
			if (getw(fp) == 1){
				printf("BDATA ");
				for (;;){
					printf("%o ", getw(fp));
					if (getw(fp) != 1) break;
					}
				putchar('\n');
				}
			break;
		case PROG:
			printf(".text\n");
			break;
		case DATA:
			printf(".data\n");
			break;
		case BSS:
			printf(".bss\n");
			break;
		case SRCSTR:
			outname(s);
			printf("SRCSTR %s\n", s);
			break;
		case SYMDEF:
			outname(s);
			printf(".globl %s\n", s);
			break;
		case LINKDEF:
			outname(s);
			printf("dentry %s\n", s);
			break;
		case RETRN:
			printf("RETRN\n");
			break;
		case CSPACE:
			t = outname(s);
			printf(".comm %s,%d\n", t, getw(fp));
			break;
		case SSPACE:
			printf("SSPACE %d\n", getw(fp));
			break;
		case EVEN:
			printf("EVEN\n");
			break;
		case SAVE:
			printf("SAVE\n");
			break;
		case NSAVE:
			printf("NSAVE\n");
			break;
		case SETSTK:
			printf("SETSTK %d\n", getw(fp));
			break;
		case PROFIL:
			t = outname(s);
			printf("PROFIL %s\n", t);
			break;
		case SNAME:
			t = outname(s);
			printf("SNAME %s,%d\n", t, getw(fp));
			break;
		case ANAME:
			t = outname(s);
			printf("ANAME %s,%d\n", t, getw(fp));
			break;
		case RNAME:
			t = outname(s);
			printf("RNAME %s,%d\n", t, getw(fp));
			break;
		case SWIT:
			t = getw(fp);
			line = getw(fp);
			printf("SWIT %d,%d:  ", t, line);
			while (t = getw(fp)) printf("(%d,%d) ", t, getw(fp));
			break;
		case CBRANCH:
			t = getw(fp);
			line = getw(fp);
			printf("CBRANCH(%d) %d,%d\n", getw(fp), t, line);
			break;
		case EXPR:
			line = getw(fp);
			printf("EXPR(%d)\n", line);
			break;
		case NAME:
			t = getw(fp);
			if (t == EXTERN){
		          /* non-norway compiler
			   */
				line = getw(fp);
				printf("NAME %s,%d\n", outname(s), line);

		        /* adjustment for the Norway C compiler

				line = getw(fp);
				t = outname(s);
				op = getw(fp);
				printf("NAME %s,%d,%o\n", t, op, line);
			*/
			}
			else {
				line = getw(fp);
				printf("NAME %d,%d(13),%d\n", t, getw(fp), line);
				}
			break;
		case FSEL:
			printf("FSEL  %d, %d, %d\n", getw(fp), getw(fp), getw(fp));
			break;
		case CON:
			t = getw(fp);
			printf("CON %d,%d\n", t, getw(fp));
			break;
		case LCON:
			getw(fp);
			t = getw(fp);
			op = getw(fp);
			printf("LCON %d,%d\n", t, op);
			break;
		case FCON:
			op = getw(fp);
			t = outname(s);
			printf("FCON %d %s\n", op, t);
			break;
		case STRASG:
			t = getw(fp);   /* type */
			op = getw(fp);  /* mask */
			printf("STRASG %d,%d\n", t, op);
			break;
		case FILENME:
			printf("FILENME  %s\n", outname(s));
			break;
		case TEXTBSE:
			printf("TEXTBSE  %d\n", getw(fp));
			break;
		case DATABSE:
			printf("DATABSE  %d\n", getw(fp));
			break;
		case NULLOP:
			printf("NULLOP\n");
			break;
		case LABEL:
			printf("LABEL %d  %d\n", getw(fp), getw(fp));
			break;
		case NLABEL:
			t = outname(s);
			printf("NLABEL %s\n", t);
			break;
		case RELOCAT:
	                op = getw(fp);
			t = outname(s);
			printf("RELOCAT %d, %s\n", op, t);
			break;
		case RLABEL:
			t = outname(s);
			printf("RLABEL %s\n", t);
			break;
		case BRANCH:
			printf("BRANCH %d\n", getw(fp));
			break;
		case SETREG:
			printf("SETREG %d\n", getw(fp));
			break;
		default:
			printf("%s %d\n", opntab[op], getw(fp));
			break;
		}
	}

outname(s)
char *s;{

	register char *p, c;
	register n;

	p = s;
	n = 0;
	while (c = getc(fp)){
		*p++ = c;
		n++;
		}
	do {
		*p++ = 0;
	} while (n++ < 8);
	return(s);
	}
