#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/dir.h>
/*
 * This is the UTS spooler.
 * Catch signals from opr, vmpunch, tape, start their daemons
 */

#define SPOOLSIG  4
#define ECHILD 10
#define EINTR   4

extern int errno;

struct depend {
	struct  depend  *de_next;
	char *de_key;
	char *de_invoke;
	char *de_device;
	int  de_pid;
} *sphdr = NULL;

struct  depend  lastdp = { NULL, "", "", "", 0 };

extern  char    *cmdname;
char    deathr[] = "Spooling daemon error: ";
char    home[]   = "/usr/spool/out";
char    spoollist[] = "/etc/spooler/spoollist";
char    *malloc(), *strcpy();

struct direct fordir[101];

int poked;

main()
{
	int fddir;
	int i;
	int wakeme();
	int sigdie();

	for (i = 1; i <= NSIG; i++)
		signal(i, sigdie);
	signal(SPOOLSIG, wakeme);
	signal(SIGHUP, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGINTR, SIG_IGN);
	splist();
	/*
	 * open directory, loop forever sorting, starting, and waiting
	 */
	fddir = open(home, 0);
	if (fddir < 0)
		die("Cannot open directory file");
	for (;;) {
		if (dirsort(fddir))
			startall();
		atease();
	}
}

wakeme()
{
	poked = 1;
	return;
}

/*
 * Sort the directory file.
 * Return number of non '.' entrys.
 */
dirsort(fddir)
int fddir;
{
	int order();
	int i;

	seek(fddir, 0, 0);
	i = 0;
	while (i < 100) {
		if (read(fddir, (char *)&fordir[i], 16) != 16)
			break;
		if ((fordir[i].d_ino != 0) && (fordir[i].d_name[0] != '.'))
			i++;
	}
	fordir[i].d_name[0] = '\0';
	if (i > 1)
		qsort(fordir, i, 16, order);
	return(i);
}

/*
 * compare two file names for order.
 * compare letter, then number.
 */
order(one, two)
char *one, *two;
{
	int back;

	back =  *(one+2) - *(two+2);
	if (!back)
		back = atoi(one+3) - atoi(two+3);
	return(back);
}

/*
 * Give up the ghost, Kick the bucket, Buy the farm,
 * Become an ex-process.
 * (Not to be confused with simply pining for the fjords)
 */
die(why)
char *why;
{
	char a[120];

	strcpy(a, deathr);
	strcat(a, why);
	notify("root", a, 0);
	fprintf(stderr, "Spooler died: %s\n", why);
	exit(1);
}

/*
 *  sigdie - die from a signal.
 *  notify root.
 */
sigdie(sig)
int     sig;
{
	extern  char    *sys_siglist[];

	die(sys_siglist[sig]);
}

/*
 * Match every device with a spool file,
 * start up the deamon.
 */
startall()
{
	char files;
	char daems;
	struct  depend *dp;
	struct  direct  *dir;

	dp = sphdr;
	dir = fordir;
	daems = *dp->de_key;
	files = dir->d_name[0];
	while (files && daems) {
		while ((daems == files) && files && daems) {
			if (dp->de_pid == 0) {
				startone(dp, dir);
				dp = dp->de_next;
				dir++;
                                daems = *dp->de_key;
                                files = dir->d_name[0];
			} else {
				dp = dp->de_next;
                                daems = *dp->de_key;
			}
		}
                while ((daems > files) && files && daems) {
                        dir++;
                        files = dir->d_name[0];
		}
		while ((daems < files) && files && daems) {
                        dp = dp->de_next;
                        daems = *dp->de_key;
		}
	}
}

/*
 * Open spool file as stdin.
 * Disavow any knowledge of the spool file.
 * Open output device as stdout.
 * Start daemon.
 */
startone(dp, dir)
struct  depend  *dp;
struct  direct  *dir;
{
	int pid;
	int sss;
	FILE *fd;
	char full[80];

	strcpy(full, home);
	strcat(full, "/");
	strcat(full, dir->d_name);
	fd = freopen(full, "r", stdin);
	if (fd == NULL)
		die("reopen stdin for daemon");
	sss = unlink(full);
	if (sss == -1)
		die("Unlink spool file");
	pid = fork();
	if (pid == -1)
		die("fork failed");
	if (pid == 0) {
		execl(dp->de_invoke, dp->de_invoke, dp->de_device, 0);
		die("didn't exec the daemon");
	}
	dp->de_pid = pid;
	return;
}

/*
 * Wait for a child to die, freeing a device, or
 * for a signal from above, indicating a new spool
 * file to try to start.
 */
atease()
{
	int pid;
	int i;
	struct  depend  *dp;

	pid = wait(&i);
	if (pid == -1) {
		if (errno == EINTR)
			return;
		if (errno == ECHILD) {
			while (!poked)
			        pause();
	                poked = 0;
		}
		else {
			fprintf(stderr, "Spooler death : errno = %d\n", errno);
			die("Errno botch\n");
		}
		/*
		 * Signal caught.
		 */
		return;
	}
	/*
	 * Find the device that finished, reset it to start over.
	 */
	dp = sphdr;
	while (dp->de_invoke != 0) {
		if (dp->de_pid == pid) {
			dp->de_pid = 0;
			poked = 1;
			return;
		}
		dp = dp->de_next;
	}
	die("wait returned pid not in busy table");
}
splist()
{
	FILE    *spfp;
	struct  depend  *dp;
	struct  depend  **dpp = &sphdr;
	char    key[10];
	char    daem[30];
	char    dev[30];

	if ((spfp = fopen(spoollist, "r")) == NULL) {
		fprintf(stderr, "%s: unable to open %s\n", cmdname, spoollist);
		exit(1);
	}
	while (fscanf(spfp, "%s %s %s", key, daem, dev) == 3) {
		dp = (struct depend *) malloc(sizeof(struct depend));
		dp->de_next = NULL;
		dp->de_key = malloc(strlen(key) + 1);
		dp->de_invoke = malloc(strlen(daem) + 1);
		dp->de_device = malloc(strlen(dev) + 1);
		dp->de_pid = 0;
		strcpy(dp->de_key, key);
		strcpy(dp->de_invoke, daem);
		strcpy(dp->de_device, dev);
		*dpp = dp;
		dpp = &dp->de_next;
	}
	*dpp = &lastdp;
}
