#include        <stdio.h>
#include        "defs.h"
/*
 *  Free the nodes of the parse tree.
 */
freetree(t)
register union   node    *t;
{

	if (t == NULL)
		return;
	switch(t->comnod.type & COMMSK) {
	case TCOM:
		iofree(t->comnod.comio);
		argfree(t->comnod.comarg);
		argfree(t->comnod.comset);
		break;
	case TPAR:
		freetree(t->parnod.partre);
		break;
	case TFIL:
	case TLST:
	case TAND:
	case TORF:
		freetree(t->lstnod.lstrit);
		freetree(t->lstnod.lstlef);
		break;
	case TIF:
		freetree(t->ifnod.iftre);
		freetree(t->ifnod.thtre);
		freetree(t->ifnod.eltre);
		break;
	case TWH:
	case TUN:
		freetree(t->whnod.whtre);
		freetree(t->whnod.dotre);
		break;
	case TSW:
		free(t->swnod.swarg);
		regfree(t->swnod.swlst);
		break;
	case TFORK:
		iofree(t->forknod.forkio);
		freetree(t->forknod.forktre);
		break;
	case TFOR:
		freetree(t->fornod.fortre);
		free(t->fornod.fornam);
		freetree(t->fornod.forlst);
		break;
	default:
		break;
	}
	free((char *) t);
	iotemp = NULL;
}
/*
 *  Free an argument node.
 */
argfree(arg)
register struct  argnod  *arg;
{
        if (arg != NULL) {
		argfree(arg->argnxt);
                if (arg->argval != NULL) {
                        free(arg->argval);
                }
                free((char *) arg);
        }
}
/*
 *  Free an io node.
 *  Recursively free the io nodes off the ionxt and iolst pointers.
 *  Free the name, and if the file was a here document, remove
 *  the temporary file.
 */
iofree(io)
register struct  ionod   *io;
{
	if (io != NULL) {
		iofree(io->ionxt);
		iofree(io->iolst);
		if (io->ioname != NULL) {
                        if (io->iofile & (IODOC | IOTMP))
                                unlink(io->ioname);
			free(io->ioname);
		}
		free((char *) io);
        }
}
/*
 *  Free a regular expression nodes.
 */
regfree(rg)
register struct  regnod  *rg;
{
	if (rg != NULL) {
		argfree(rg->regptr);
                freetree(rg->regcom);
                regfree(rg->regnxt);
                free((char *) rg);
	}
}
