#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/dir.h>

#define EOS             '\0'
#define SLASH           '/'
#define EFLG            "-e"

char    lintp1[] =      "/usr/lib/lint/lint1";
char    scnf[] =        "/lib/scnf";
char    eflg = 0;

short   err = 0;        /* number of unopen'able files */

/* scan - scan C source files for function definitions and calls
*  For each source file, the standard output of the first pass
*  of lint is piped into scan's filter, scnf.
*
*  When a directory name is passed to scan he scans the "*.c"
*  files within it.
*
*  Any filenames beginning with "s." are assumed to be SCCS
*  files and are silently ignored.
*/
main(argc, argv)
	int     argc;
	char    **argv;
{
	struct  stat    sbuf;   /* stat buffer */

	if (argc > 1) {
                argv++;
                if (strcmp(*argv, EFLG) == 0) {
                        eflg++;
                        argc--;
                        argv++;
                }
	}

	if (--argc <= 0) {             /* read from stdin */
                parse("");
		exit(0);
	}

	while (argc--) {
		if (stat(*argv, &sbuf) == -1) {
			fprintf(stderr, "%s: Unable to Open\n", *argv);
			argv++;
			err++;
			continue;
		}

		if ((sbuf.st_mode & S_IFMT) == S_IFDIR)
			dir(*argv++);
		else
			parse(*argv++);
	}
	exit(err);
}

/* parse - parse a file
*  If the file begin with "s.", assume it is an SCCS file and
*  silently ignore it.
*  Returns:  nothing.
*/
parse(fn)
	char    *fn;            /* filename to parse */
{
	char    *c;             /* pointer to simple name */
	char    *sname();       /* get simple name */
	char    cmdbuff[100];

        c = sname(fn);
        if (c[0] == 's' && c[1] == '.')
		return;

	sprintf(cmdbuff, "/lib/cpp %s | %s 2> /dev/null | %s", fn, lintp1, scnf);
	system(cmdbuff);
}


/* sname - simple name
*  Given a filename, returns a pointer to the simple name
*  component.
*/
char *
sname(fn)
	char    *fn;
{
	char    *c;             /* pointer within fn */
	char    *simple;        /* pointer to the simple name */

	simple = fn;
	for (c = fn; *c; c++)
		if (*c == SLASH)
			simple = c + 1;
	return(simple);
}

/* dir - handle a directory
*  Read the directory, and parse the "*.c" files within the it.
*  Returns: the sum of the returned values from parse();
*/
dir(fn)
	char    *fn;
{
	struct  direct  dbuf;   /* directory entry buffer */
	FILE    *dfd;           /* directory file descriptor */
	int     len;            /* length of directory entry */
	char    pname[100];     /* path name */

	if ((dfd = fopen(fn, "r")) == NULL) {
                fprintf(stderr, "%s: Unable to Open\n", fn);
		err++;
	}

	while(fread((char *) &dbuf, sizeof(dbuf), 1, dfd) != 0) {
		if (dbuf.d_ino == 0)
			continue;

		if ((len = strlen(dbuf.d_name)) < 2)
			continue;

		if (dbuf.d_name[len - 2] != '.' ||
		    dbuf.d_name[len - 1] != 'c')
			continue;

	        strcpy(pname, fn);
		strcat(pname, "/");
		strncat(pname, dbuf.d_name, sizeof(dbuf.d_name));
                parse(pname);
        }
	fclose(dfd);
}
