#include <stdio.h>
#include <ctype.h>

#define EOS     '\0'
#define MAXLINE 512

extern  char    *cmdname;
char    usrlibhelp[] = "/usr/lib/help";
char    cmds[] = "cmds";

main(argc, argv)
int     argc;
char    **argv;
{
	int     helped;
	int     len;
	int     n;
	char    file[MAXLINE];

	chdir(usrlibhelp);
	if (argc == 1) {
		help(cmds, "help");
		exit(0);
	}
	argv++;
	argc--;
	while (argc--) {
                helped = 0;
		len = strlen(*argv);
		if ((n = sindex(*argv, ".")) != -1) {
                        if (n > 1 && n < len - 1) {
                                strncpy(file, *argv, n);
                                file[n] = EOS;
                                helped = help(file, &(*argv)[n + 1]);
                        }
		}
		if (helped == 0)
                        helped = help(cmds, *argv);
		if (helped != 1)
			fprintf(stderr, "%s: no help for %s\n", cmdname, *argv);
		argv++;
	}
}
/*
 *  help - look in a file for a help entry
 *  If the file does not exist return 0,
 *  if the entry is not found return -1,
 *  otherwise, print the entry and return 1.
 *  Open the file and look for a line beginning with a dash
 *  followed by the argument passed.  Then print the lines
 *  until another line beginning with a dash.
 */
help(file, string)
char    *file;
char    *string;
{
	FILE    *fp;
	char    line[MAXLINE];
	int     len;

	if ((fp = fopen(file, "r")) == NULL)
		return(0);
	len = strlen(string);
	while (fgets(line, sizeof(line), fp) != NULL) {
		if (line[0] != '-' || line[len+1] != '\n')
			continue;
		if (strncmp(&line[1], string, len) != 0)
			continue;
		printf("%s:\n", string);
		while (fgets(line, sizeof(line), fp) != NULL) {
			if (line[0] != '-')
				printf("%s", line);
			else
			        break;
                }
		fclose(fp);
		return(1);
	}
	fclose(fp);
	return(-1);
}
