/*
 * part number:
 * program name:         com - output files to microfiche
 * system:               Au , Tau
 * responsible engineer: diane m warner
 * backup engineer:      dennis graham
 * project definition:   810683-600 b
 * executable module:
 * system release:
 * rework summary:       none, first release
 * description: the purpose of this program is to direct Au files
 *              to microfiche output classes.  it does this by
 *              associating various parameters and values with
 *              variable names found in the modeljcl it eventually uses.
 *              to permit titles other than those suppplied by CCS, it
 *              generates the necessary title information, including a
 *              title specified by the user if applicable. it then
 *              calls send, specifying the parameter file and modeljcl
 *              file.  send does the necessary substitutions and
 *              submits the jcl to MVS (we need the sysout classes
 *              available under MVS at the present time).
 *              for a description of what is done by the jcl, see
 *              the comment preceeding the jcl file.
 */

#include <stdio.h>
#include <ctype.h>
#include <pwd.h>

#define  ON  1                      /* set flags on or off              */
#define  OFF 0
#define  HLEN1 30                   /* max len for first title string   */
#define  HLEN2 48                   /* max len for second title string  */
#define  LLEN1 48                   /* max len for first title string   */
#define  LLEN2 72                   /* max len for second title string  */
#define  MLEN1 42                   /* max len for first title string   */
#define  MLEN2 64                   /* max len for second title string  */
#define  TLEN 100                   /* max len for each title line      */

char *firstarg;                     /* used to call title from process  */
char *nextarg;                      /* next argument in argv array      */
char string1[TLEN] = "";            /* holds first string of title info */
char string2[TLEN] = "";            /* holds second string of title info*/
char tempfil[]  = "/tmp/comXXXXX";  /* temp file for title info         */
char tempfil2[] = "/tmp/jclXXXXX";  /* temp file for params for modeljcl*/

FILE *fp, *tempfp, *tempfp2;        /* file pointers for temp files     */
FILE *fopen();

int dflag,
    fflag,                          /* flags to indicate which options*/
    hflag,                          /* are specified by the user        */
    lflag,
    mflag,
    tflag,
    t2flag,
    yflag,
    errflag;                        /* flag to track number of errors   */

struct passwd *pw;                  /* structure to obtain acct info    */
struct passwd *getpwuid();

main(argc,argv)
int argc;
char **argv;
{
	char *ap;                   /* points to second char of option  */
	int argnum,                 /* num of arguments used by function*/
            fnum;                   /* num of input files specified     */

	/*
	 * initialize flags
	 */
	errflag = 0;
	dflag = fflag = hflag = lflag = mflag = tflag = yflag = OFF;

setbuf(stdout,NULL);
	/*
	 * create temp file for jcl parameters
	 */
	mktemp(tempfil2);
	tempfp2 = fopen(tempfil2,"w");
	if (tempfp2 == NULL){
		fprintf(stderr,"com:");
		fprintf(stderr,"can't open temp file for jcl params\n");
		errflag++;
		exit(1);
	}

	/*
	 * read flags specified and set flags accordingly
	 */
	argv++;
	while(--argc > 0 && *argv[0]=='-'){
		ap = *argv + 1;
		nextarg = *(argv + 1);

        /*
         * the switch will set flags according to options specified when
         * the command was invoked.
         */
                switch(*ap){
		/*
		 * the argument following the -c flag indicates the
		 * desired output class
		 * check that it's a valid fiche class and
		 * set flags accordingly
		 */
		case 'c':
			switch(*nextarg) {
			case 'h':
				hflag = ON;
				break;
			case 'l':
				lflag = ON;
				break;
			case 'm':
				mflag = ON;
				break;
			case 'y':
				yflag = ON;
				break;
			default:
				fprintf(stderr,"com:Invalid class specified %s.\n",nextarg);
				fprintf(stderr,"com:Valid classes are h, l, and m.\n");
				errflag++;
				exit(1);
				break;
			}
			argv++;
			argc--;
			break;

		/*
		 * sets flag indicating this is debug run
		 */
		case 'd':
			dflag = ON;
			break;

		/*
		 * the argument following -f should be a file
		 * containing title info in COMp 80 format
		 * set the title file param, TFILE, appropriately.
		 */
		case 'f':
			if (tflag) {
				fprintf(stderr,"com error: -t and -f cannot both be specified.\n");
				errflag++;
				exit(1);
				break;
			}
			/*
			 * see if next arg is a flag or string
			 */
			if (nextarg[2] == '\0' && nextarg[0] == '-'){
				fprintf(stderr,"com error: %s assumed to be flag, file name expected.\n",nextarg);
				errflag++;
				exit(1);
				break;
			}
			/*
			 * see if title file is a valid file
			 * by trying to open it
			 */
			fp = fopen(nextarg,"r");
			if (fp == NULL) {
				fprintf(stderr,"com: cannot open title file %s.\n",nextarg);
				errflag++;
				exit(1);
			}
			else{
				fclose(fp);
				fprintf(tempfp2,"~&TFILE=%s\n",nextarg);
				argv++;
				argc--;
				fflag = ON;
			}
			break;

		/*
		 * -t should be followed by one or two strings of title info
		 * title will put this in the title file
		 */
                case 't':
			if (fflag) {
				fprintf(stderr,"com error: -f and -t cannot both be specified.\n");
				errflag++;
				exit(1);
				break;
			}
		        /*
		         * see if arg following -t is a title string or flag
		         */
		        if (nextarg[2] == '\0' && nextarg[0] == '-') {
		                fprintf(stderr,"com:");
		                fprintf(stderr,"%s assumed to be flag,",nextarg);
		                fprintf(stderr,"title info expected. \n");
		                errflag++;
				exit(1);
				break;
		        }
			/*
			 * see if it's the first or second title line
			 */
			switch (*(*argv +2)){
			case '1':
				sprintf(string1,"%s",nextarg);
				argv++;
				argc--;
				tflag = ON;
				break;
			case '2':
				sprintf(string2,"%s",nextarg);
				argv++;
				argc--;
				t2flag = ON;
				break;
			default:
				fprintf(stderr,"com:invalid flag: %s.\n",*argv);
				errflag++;
				exit(1);
				break;
			}
                        break;

                default:
			fprintf(stderr,"com:");
                        fprintf(stderr,"invalid flag: %s\n",*argv);
                        errflag++;
                        exit(1);
			break;
                }
		argv++;
	}

	/*
	 * if user has not specified class, set default to h
	 */
	if (!lflag && !mflag)
		hflag = ON;

	/*
	 * if user has specified title info, set up the title file
	 */
	if (tflag)
		firstarg = string1;
	if (t2flag)
		nextarg = string2;
	if (tflag || t2flag)
	        title(firstarg);

	/*
	 * determine input files -- define them according to params in
         * modeljcl; ingore any files beyond nine
	 */
	fnum = 1;
	if (argc > 0) {
		while (argc && fnum < 10) {
			fprintf(tempfp2,"~&F%d=%s\n",fnum,*argv);
			fnum++;
			++argv;
			argc--;
		}
	        if (fnum >= 10) {
		        fprintf(stderr,"com:");
		        fprintf(stderr,"Only the first 9 input files specified are used\n");
			errflag++;
		}
	}
	/*
	 * if fewer than 9 files are specified, set their
	 * jcl params to null, so send doesn't get confused.
	 */
	while (fnum < 10) {
		fprintf(tempfp2,"~&F%d=\n",fnum);
		fnum++;
	}
	process();
        cleanup();
}

/*
 * this function sets up the remaining jcl variables and then
 * does a fork and exec to send, which submits the jcl to MVS
 */
process()
{
	char class,                 /* output class desired             */
             *s;
        char *vmid();               /* used to determine au or tau      */
        char *t;                    /* used to get ctime and strip \n   */
        char *acct,
             *dept,
             *inits;                /* used for new account numbers     */

        int len,                    /* length associated with class     */
            uid;                    /* unix id of user                  */
	int pid, rpid, status;      /* vars for fork and exec           */
	int ignore, respond;        /* used to see if user wants to send*/
        int tsolen;                 /* used for length of tso id        */

	/*
	 * set up class and length params
	 */
	if (hflag) {
		class = 'h';
                len = 80;
        }
	else
                if (lflag) {
		        class = 'l';
			len = 133;
		}
	        else
                        if (mflag) {
		                class = 'm';
				len = 133;
			}
			else
				if (yflag) {
					class = 'y';
					len = 80;
				}
			        else {
                                        class = 'h';
				        len = 80;
			        }

	/*
	 * if debug flag is set, reset class to y
	 */
	if (dflag)
		class = 'y';
        /*
	 * get pwent structure to obtain info needed in jcl
	 */
        uid = getuid();

	if ((pw = getpwuid(uid)) == 0){
		fprintf(stderr,"com:");
	        fprintf(stderr,"bad user id\n");
	        errflag++;
	        exit(1);
	}

	/*
	 * get unixid name
	 */
	s = pw->pw_name;
	while (*s) {
	        *s = islower(*s) ? toupper(*s) : *s;
	        ++s;
	}
	fprintf(tempfp2,"~&UID=%s\n",pw->pw_name);

	/*
	 * get account number
	 */
	s = pw->pw_tsoid;
	while (*s) {
	        *s = islower(*s) ? toupper(*s) : *s;
	        ++s;
	}
        acct = pw->pw_tsoid;
        fprintf(tempfp2,"~&TSOID=%s\n",acct);
        dept = pw->pw_dept;
        tsolen = strlen(acct);
        if (tsolen == 7) {
		substr(acct,inits,4,3);
		fprintf(tempfp2,"~&ACCOUNT=%s%s000000\n",dept,inits);
	}
        else {
		if (tsolen == 5) {
			substr(acct,inits,0,3);
		        fprintf(tempfp2,"~&ACCOUNT=%s%s000000\n",dept,inits);
		}
		else {
			fprintf(stderr,"Invalid TSO ID.\n");
			errflag++;
			exit(1);
		}
	}

	/*
	 * get binno, length, class
	 */
	fprintf(tempfp2,"~&BIN=%s\n",pw->pw_binno);
	fprintf(tempfp2,"~&LEN=%d\n",len);
	fprintf(tempfp2,"~&CLASS=%c\n",class);

	/*
	 * if there's a user supplied title file, do nothing.
	 * if the user supplied the title strings, just set variable.
	 * if user supplied nothing, set up default title.
	 */
	if (!fflag){
		if (!tflag && !t2flag){
			sprintf(string1,"Microfiche for %s",getlogin());
			t = ctime(time());
			t[strlen(t) - 1] = '\0';
			sprintf(string2,"Sent from %s %s",vmid(),t);
			firstarg = string1;
			nextarg = string2;
			tflag = ON;
			t2flag = ON;
			title(firstarg);
		}
	        fprintf(tempfp2,"~&TFILE=%s\n",tempfil);
	}

	/*
	 * let the user know how many errors there were and
	 * leave it up to the user whether to submit the job
	 */
	if (errflag) {
		fprintf(stderr,"%d error%s detected - type 'y' to submit anyway:",
		errflag, errflag==1? "":"s");
		respond = ignore = getchar();
		while (ignore != '\n' && ignore != EOF)
			ignore = getchar();
		fprintf(stderr,"\n");
		if (respond != 'y') return;
	}

	/*
	 * close the files before forking
	 */

	fclose(tempfp);
	fclose(tempfp2);

	/*
	 * call send to expand model jcl and submit the job to MVS
	 */
        if ((pid = fork()) < 0) {
		fprintf(stderr,"com:");
		fprintf(stderr,"cannot fork\n");
		errflag++;
	}
	if (pid == 0) {
		if (dflag)
		        execlp("send","send","-t","-d",tempfil2,"/usr/lib/com/modeljcl",0);
		execlp("send","send",tempfil2,"/usr/lib/com/modeljcl",0);
		fprintf(stderr,"com:");
		fprintf(stderr,"cannot execl send\n");
		errflag++;
	}
	while ((rpid = wait(&status)) != pid && rpid >=0);
	if (rpid < 0) {
		fprintf(stderr,"com:");
		fprintf(stderr,"no child to wait for \n");
		errflag++;
        }
}

title(info)
char *info;
{
	char title1 [TLEN],             /* arrays for title strings */
             title1a[TLEN],
	     title2 [TLEN];
	char *start1,                   /* pointers to line control info*/
	     *start1a,
	     *start2;
	int len;
	int maxlen1, maxlen2;           /* max lengths per line       */

	/*
	 * create temp file needed to store title info
	 */
	mktemp(tempfil);
	tempfp = fopen(tempfil,"w");
	if (tempfp == NULL) {
		fprintf(stderr,"com:");
		fprintf(stderr,"can't open tmp file for title info\n");
		errflag++;
		exit(1);
	}

	/*
	 * set lengths and control strings according to class
	 */
	if (hflag) {
		maxlen1 = HLEN1;
		maxlen2 = HLEN2;
		start1 = ",T1C6L2H1,1V1,1";
		start1a = ",C C6H6,2V1,1";
		start2 = ",C C8H1,1V1,2";
	}
	else if (lflag) {
		maxlen1 = LLEN1;
		maxlen2 = LLEN2;
		start1 = ",T1C6L2H1,1V1,1";
		start1a = ",C C6H9,2V1,1";
		start2 = ",C C8H1,1V1,2";
	}
	else if (mflag) {
		maxlen1 = MLEN1;
		maxlen2 = MLEN2;
		start1 = ",T1C3L2H1,1V1,1";
		start1a = ",C C3H16,1V1,1";
		start2 = ",C C4H1,1V1,2";
	}
	/*
	 * if first title line was not given, set it to null
	 */
	if (!tflag){
		sprintf(title1,"%s/  $M$",start1);
		fprintf(stderr,"warning: first title line was not specified.\n");
	}

	/*
	 * check length of title info supplied by user
	 */
	else {
                if ((len = strlen(info)) > maxlen1) {
                        fprintf(stderr,"First title string is %d chars --",len);
                        fprintf(stderr,"Maximum length is %d.\n",maxlen1);
                        fprintf(stderr,"Line will be truncated. \n");
                        errflag++;
                        info[maxlen1] = '\0';
                }
                /*
                 * there should be a title string. get it.
                 */
                sprintf(title1,"%s/%s  $M$",start1,info);
	}

	/*
	 * if a second title string isn't specified, set title2 to null
	 */
	if (!t2flag) {
		sprintf(title2,"%s/  $T",start2);
		fprintf(stderr,"warning: second title line was not specified.\n");
	}
	/*
	 * second title was specified,
	 * move info pointer to next argument
	 */
	else {                     /* t2flag was set */
                info = nextarg;
                /*
                 * there should be a title string. get it.
                 * check length of title info supplied by user
                 */
                if ((len = strlen(info)) > maxlen2) {
                        fprintf(stderr,"Second title string is %d chars --",len);
                        fprintf(stderr,"Maximum length is %d.\n",maxlen2);
                        fprintf(stderr,"Line will be truncated. \n");
                        errflag++;
                        info[maxlen2] = '\0';
                }
                sprintf(title2,"%s/%s  $T",start2,info);
	}
	/*
	 * write the title info to tempfil
	 */
	sprintf(title1a,"%s/$3001  $M$",start1a);
	fprintf(tempfp,"%s\n%s\n%s\n",title1,title1a,title2);
}
cleanup()
{
        if (!dflag && !yflag){
	        if (!fflag)
		        unlink (tempfil);
	        unlink (tempfil2);
        }
}
