# include "prh.c"
/* ibm preprocessor */
/* modified 2/26/76 u370 */

extern int cin, cout;
int	ppeekc;
int	inlno;
int	lno1;
int	lno2;
int	instring;
int	exfail;
int	infil;
int	f1;
int	f2	-1;
int depth;
char	*lp;
char	*ppline;
int	lineno;
struct symtab  *symtab;
extern struct symtab stab[];
struct	symtab *defloc;
struct	symtab *incloc;
struct symtab *eifloc;
struct symtab *ifdloc;
struct symtab *ifnloc;
struct symtab *locsys;
int	trulvl;
int	flslvl;
char	*stringbuf;
char ln [512];
extern char sbf[];

main(argc, argv)
char **argv;
{

	if( argc==0 ){
		/* we are in bfor situation */
		cout = copen( "**2", 'w' );
		expand( "*S*" );
		}
	else if( argc >= 3 ){
		cout = copen( argv[2], 'w' );
		expand( argv[1] );
		}
	else if(argc == 1){
		expand(0);
		}
	else {
		perror( "Arg count" );
		}

	if( exfail ) cexit(1);
	cexit();
}

expand(file)
char *file;
{
	register int c;
	register char *rlp;

	if(file){ if ((infil = f1 = copen(file, 'r')) < 0) {
		perror("Can't find %s", file);
		return;
	}
	}
	else infil = f1 = 0;
	symtab = stab;
	for (c=0; c<symsiz; c++) {
		stab[c].name[0] = '\0';
		stab[c].value = 0;
	}
	insym(&defloc, "define");
	insym(&incloc, "include");
	insym(&eifloc, "endif");
	insym(&ifdloc, "ifdef");
	insym(&ifnloc, "ifndef");
# ifdef gcos
	insym(&locsys, "gcos");
# endif
# ifdef unix
	insym(&locsys, "ibm");
# endif
	stringbuf = sbf;
	trulvl = 0;
	flslvl = 0;
	ppline  = ln;
	lineno = 0;
	lno1 = 0;
	if( (ppeekc=getch())>='0' && ppeekc<='9' ) ++lno1;
	ungetc(ppeekc,infil);
	inlno = lno1;
	while(getline()) {
		if ( infil==f2 )
			cputc(001, cout);	/*SOH: insert */
		if (ln[0] != '#' && flslvl ==0)
			for (rlp = ppline; c = *rlp++;)
				cputc(c, cout);
		cputc('\n', cout);
	}
	cclose(f1);
}

getline()
{
	register int c, sc, state;
	struct symtab *np;
	char *namep, *filname;

	if (infil==f1)
		lineno++;
	depth=0;
	lp = ppline;
	*lp = '\0';
	state = 0;
	c = getch();
	if( inlno ){ /* delete line number */
		while( c>='0' && c<='9' ) c = getch();
		if( c == '#' ) c = getch();
		}
	if (c == '#')
		state = 1;
	while (c!='\n' && c!='\0') {
		if (alpha(c) || c == '_') {
			namep = lp;
			sch(c);
			while (alpha(c=getch())
				  ||'0'<=c && c<='9' 
				  ||c=='_')
				sch(c);
			sch('\0');
			lp--;
			if (state>3) {
				if (flslvl==0 &&(state+!plookup(namep,0)->name[0])==5)
					trulvl++;
				else
					flslvl++;
		out:
				while (c!='\n' && c!= '\0')
					c = getch();
				return(c);
			}
			if (state!=2 || flslvl==0)
				{
				ungetc(c,infil);  /* hide possible '(' after name */
				np = plookup(namep, state);
				c = getch();
				}
			if (state==1) {
				if (np==defloc)
					state = 2;
				else if (np==incloc)
					state = 3;
				else if (np==ifnloc)
					state = 4;
				else if (np==ifdloc)
					state = 5;
				else if (np==eifloc) {
					if (flslvl)
						--flslvl;
					else if (trulvl)
						--trulvl;
					else perror("If-less endif");
					goto out;
				}
				else {
					perror("Undefined control");
					while (c!='\n' && c!='\0')
						c = getch();
					return(c);
				}
			} else if (state==2) {
				if (flslvl)
					goto out;
				np->value = stringbuf;
				ungetc(c,infil);
				while ((c=getch())!='\n' && c!='\0') {
					if(c == '#')
						prochex();
					else
						savch(c);
				}
				savch('\0');
				trimsav();
				return(1);
			}
			continue;
		} else if ((sc=c)=='\'' || sc=='"') {
			sch(sc);
			filname = lp;
			instring++;
			while ((c=getch())!=sc && c!='\n' && c!='\0') {
				sch(c);
				if (c=='\\')
					sch(getch());
			}
			instring = 0;
			if (flslvl)
				goto out;
			if (state==3) {
				*lp = '\0';
				while ((c=getch())!='\n' && c!='\0');
				if (infil==f2)
					perror("Nested 'include'");
				if ((f2 = copen(filname, 'r'))<0)
					perror("Missing file %s", filname);
				else {
					infil = f2;
					lno2 = 0;
					if( (ppeekc = getch() ) >= '0' && ppeekc<='9' ) ++lno2;
					ungetc(ppeekc,infil);
					inlno = lno2;
					}
				return(c);
			}
		}
		sch(c);
		c = getch();
	}
	sch('\0');
	if (state>1)
		perror("Control syntax");
	return(c);
}

insym (sp, namep)
struct symtab **sp;
char *namep;
{
	register struct symtab *np;

	*sp = np = plookup(namep, 1);
	np->value = np->name;
}
perror(s, x)
{
	printf( 2, "*F*     %d: ", lineno);
	printf( 2, s, x);
	printf( 2, "\n");
	exfail++;
}

sch(c)
{
	register char *rlp;

	rlp = lp;
	if (rlp==ppline+510)
		perror("Line overflow");
	*rlp++ = c;
	if (rlp>ppline+511)
		rlp = ppline+511;
	lp = rlp;
}

savch(c)
{
	*stringbuf++ = c;
	if (stringbuf-sbf <SBSIZE)
		return;
	perror("too much defining");
	cexit(1);
}

trimsav()
{
stringbuf--;
while (*(stringbuf-1)  == ' ' && stringbuf>sbf)
	*--stringbuf = '\0';
stringbuf++;
}

getch()
{
	register int c;

loop:
	if ((c=getc1())=='/' && !instring) {
		if ((c=getc1())!='*')
			{
			ungetc(c,infil);
			return('/');
			}
		for(;;) {
			c = getc1();
		cloop:
			switch (c) {

			case '\0':
				return('\0');

			case '*':
				if ((c=getc1())=='/')
					goto loop;
				goto cloop;

			case '\n':
				if (infil==f1) {
					cputc('\n', cout);
					lineno++;
				}
				depth=0;
				continue;
			}
		}
	}
	return(c);
}

getc1()
{
	register c;

	if ((c = cgetc(infil)) <= 0 && infil==f2) {
		cclose(f2);
		infil = f1;
		inlno = lno1;
		cputc('\n', cout);
		c = getc1();
	}
	if (c<0)
		return(0);
	return(c);
}

plookup(namep, enterf)
char *namep;
{
	register char *np, *snp;
	register struct symtab *sp;
	int i, c, around;

	np = namep;
	around = i = 0;
	while (c = *np++)
		i =+ c;
	i = i % symsiz;
	sp = &symtab[i];
	while (sp->name[0]) {
		snp = sp;
		np = namep;
		while (*snp++ == *np)
			if (*np++ == '\0' || np==namep+8) {
				if (!enterf)
					subst(namep, sp);
				return(sp);
			}
		if (++sp >= &symtab[symsiz])
			if (around++)
				{
				perror("too many defines");
				cexit(1);
				}
			else
			sp = symtab;
	}
	if (enterf) {
		snp = namep;
		for (np = &sp->name[0]; np < &sp->name[8];)
			if (*np++ = *snp)
				snp++;
	}
	return(sp);
}
char revbuff[200], *bp;
backsch(c)
	{
	if (bp-revbuff > 200)
		perror("Excessive define looping", bp--);
	*bp++ = c;
	}

subst(np, sp)
char *np;
struct symtab *sp;
{
	register char *vp;

	lp = np;
	bp = revbuff;
	if (depth++>100)
		{
		perror("define recursion loop\n");
		return;
		}
	if ((vp = sp->value) == 0)
		return;
	/* arrange that define unix unix still
	has no effect, avoiding rescanning */
	if (streq(sp->name,sp->value))
		{
		while (*vp)
			sch(*vp++);
		return;
		}
	backsch(' ');
	if (*vp == '(')
		expdef(vp);
	else
	while (*vp)
		backsch(*vp++);
	backsch(' ');
	while (bp>revbuff)
		ungetc(*--bp, infil);
}

expdef(proto)
  char *proto;
{
char buffer[100], *parg[20], *pval[20], name[20], *cspace, *wp;
char protcop[100], *pr;
int narg, k, i, c;
pr = protcop;
while (*pr++ = *proto++);
proto= protcop;
for (narg=0; (parg[narg] = token(&proto)) != 0; narg++)
	;
/* now scan input */
cspace = buffer;
if ((c=getch()) == ' ')
	while ((c=getch()) == ' ');
ungetc(c,infil);
for(k=0; pval[k] = coptok(&cspace); k++);
if (k!=narg)
  perror("define argument mismatch");
while (c= *proto++)
   {
   if (!letter(c))
      sch(c);
   else
      {
      wp = name;
      *wp++ = c;
      while (letnum(*proto))
        *wp++ = *proto++;
      *wp = 0;
      for (k=0; k<narg; k++)
      if(streq(name,parg[k]))
        break;
      wp = k <narg ? pval[k] : name;
      while (*wp) sch(*wp++);
      }
   }
}
token(cpp) char **cpp;
{
char *val;
int stc;
stc = **cpp;
*(*cpp)++ = '\0';
if (stc==')') return(0);
while (**cpp == ' ') (*cpp)++;
for (val = *cpp; (stc= **cpp) != ',' && stc!= ')'; (*cpp)++)
  {
  if (!letnum(stc) || (val == *cpp && !letter(stc)))
    perror("define prototype argument perror");
  }
return(val);
}
coptok (cpp) char **cpp; {
char *val;
int stc, stop, paren;
paren = 0;
val = *cpp;
if (getch() == ')')
  return(0);
while (((stc = getch()) != ',' && stc != ')') || paren > 0)
  {
  if (stc == '\0')
    {
    perror ("non terminated macro call");
    val=0;
    break;
   }
  if (stc == '"' || stc == '\'')
    {
    stop = stc;
    if (stop == '\'')
       *(*cpp)++ = '\'';
    while ( (stc = getch()) != stop)
      {
      if (stc == '\n' || stc == '0')
        {
        perror ("non-terminated string");
        break;
        }
      if (stc == '\\')
        if ((stc= getch()) != stop && stc != '\\')
          *(*cpp)++ = '\\';
      *(*cpp)++ = stc;
     }
    if (stop = '\'')
      *(*cpp)++ = '\'';
   }
  else if (stc == '\\')
      {
      stc = getch();
      if (stc != '"' && stc != '\\')
        *(*cpp)++ = '\\';
      *(*cpp)++ = stc;
      }
  else
   {
   *(*cpp)++ = stc;
   if (stc== '(')
      paren++;
    if (stc  == ')')
      paren--;
   }
   }
*(*cpp)++ = 0;
ungetc(stc,infil);
return(val);
}
letter(c)
{
if (alpha(c) ||
    (c == '_'))
    return (1);
else
    return(0);
}
letnum(c)
{
if (letter(c) || (c >= '0' && c <= '9'))
  return(1);
else
  return(0);
}
streq(s,t) char *s, *t;
{
int c;
while ( (c= *s++) == *t++)
   if (c==0) return(1);
return(0);
}
alpha(c)
{
switch(c)
 {
  case 'a': case 'b': case 'c': case 'd': case 'e': case 'f': case 'g': case 'h':
  case 'i': case 'j': case 'k': case 'l': case 'm': case 'n': case 'o': case 'p':
  case 'q': case 'r': case 's': case 't': case 'u': case 'v': case 'w': case 'x':
  case 'y': case 'z': case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
  case 'G': case 'H': case 'I': case 'J': case 'K': case 'L': case 'M': case 'N':
  case 'O': case 'P': case 'Q': case 'R': case 'S': case 'T': case 'U': case 'V':
  case 'W': case 'X': case 'Y': case 'Z':
	return(1);
 }
return(0);
}

#ifndef unix
#define long int
#endif
prochex()
{
	long ll;
	register c;
	ll = 0;
	while((c = getch()) != '\n' && c != '\0'
		&& ((c >= '0' && c <= '9') || ((c) >= 'a' && c<='f')))
		ll = (ll<<4) + (c< 'a' ? c - '0' : c - 'a' + 10);
	putoct(ll);
	ungetc(c,infil);
}

#define	OSIGN	034000000000
putoct(lll)
long lll;
{
#ifdef unix
	register i;
	long llt;
	struct {int integ;};
	if(lll) {
		llt = lll>>3;
		llt.integ =& ~0160000;
		putoct(llt);
		i = lll;
		savch('0' + (i & 07));
#endif
#ifndef unix
	if(lll) {
		putoct((lll>>3) & ~OSIGN);
		savch('0' + (lll&07));
#endif
	} else
		savch('0');
}
