








                  Installing and Operating the BBN Networking
                                    Software

                             Beta-Test Distribution


                               Robert F. Gurwitz

                           Computer Systems Division
                         Bolt Beranek and Newman, Inc.
                               50 Moulton Street
                         Cambridge, Massachusetts 02238


                                    _A_B_S_T_R_A_C_T


                    This  document  contains   instructions   for
               installing   and   operating  the  BBN  networking
               software.  The package includes  modifications  to
               the 4.1bsd release of the  VAX*  UNIX**  operating
               system,  as distributed by the University of Cali-
               fornia, Berkeley,  to  support  the  DoD  Standard
               Transmission   Control   and   Internet  Protocols
               (TCP/IP).  In addition, user  level  commands  are
               included,  which implement the TELNET Virtual Ter-
               minal Protocol, the File Transfer Protocol  (FTP),
               and  the  Mail Transfer Protocol (MTP), as well as
               utilities which aid in operating the  network  and
               debugging programs which use the network.



          _1.  _I_n_t_r_o_d_u_c_t_i_o_n

               This document explains how to install the  BBN  network
          software package, which runs under the 4.1bsd release of the
          Berkeley version of UNIX for the VAX.  The distribution con-
          sists  of  two  parts:  a set of modifications to the 4.1bsd
          kernel which supports the  lower  level  network  protocols,
          TCP,  IP,  and  the local network interface;  and a suite of
          user level software (commands and libraries), which includes
          both  higher  level network protocols (TELNET, FTP, and MTP)
          and utilities for writing and debugging programs  which  use
          the lower level network protocols.


          __________________________
          *VAX is a trademark of Digital Equipment Corporation.
          **UNIX is a trademark of Bell Laboratories.




                                October 26, 1981





                                     - 2 -


          _1._1.  _P_r_e_r_e_q_u_i_s_i_t_e_s

               It is assumed that the user is already  running  4.1bsd
          on  a  VAX 11/780 or VAX 11/750.  The current release of the
          system can handle multiple network interfaces on one or more
          nets.   The  system has been developed on the ARPANET, using
          the  Associated  Computer  Consultants  (ACC)  LH/DH-11  IMP
          interface.   A  driver  for  the  LH/DH-11  on the UNIBUS is
          included with the software, and the ARPANET 1822 protocol is
          supported  as  the local network access protocol. Currently,
          this is the only hardware interface and local network proto-
          col  supported.   It  is  expected  that  software  will  be
          developed to handle other hardware interfaces and local net-
          work   protocols   (such  as  for  the  ETHERNET)  by  sites
          interested in using this software over networks  other  than
          the ARPANET.

          _1._2.  _D_i_s_t_r_i_b_u_t_i_o_n _F_o_r_m_a_t

               The software is distributed on a 1600bpi 600'  magnetic
          tape.   The  tape  contains  two files.  The first is a tape
          archive image (see _t_a_r(_1)) of the  sources  for  the  4.1bsd
          kernel  with  the  network  modifications  (in  the standard
          directory hierarchy /usr/src/sys).  The second file is a tar
          of  a  directory  hierarchy  that  includes  the sources and
          libraries for the user level commands.   This  hierarchy  is
          designed  to  be self-contained, and includes src, lib, bin,
          include, and doc directories.

          _2.  _I_n_s_t_a_l_l_i_n_g _t_h_e _K_e_r_n_e_l _M_o_d_i_f_i_c_a_t_i_o_n_s

               There  are  two  paths  for  integrating  the   network
          software into your system.  The kernel contained on the dis-
          tribution tape is a complete version of the  4.1bsd  system.
          If there are few local modifications to your kernel, you may
          want to use the distributed system as a base for  your  pro-
          duction  system and merge local changes into it.  Otherwise,
          if there are extensive local changes to your kernel, you can
          merge  the  network  additions  and  modifications into your
          existing kernel sources.  In either case, you will  want  to
          modify you system configuration files (in /usr/src/sys/conf)
          to include the network.  You should  be  familiar  with  the
          instructions  for  creating  system  configuration files and
          making changes  to  the  kernel  as  described  in  sections
          3.2.3-4 of "Installing and Operating 4.1bsd," by Bill Joy.

          _2._1.  _R_e_a_d_i_n_g _t_h_e _D_i_s_t_r_i_b_u_t_i_o_n _T_a_p_e

               For either method of installing  the  kernel  modifica-
          tions, you should create a directory in /usr/src and read in
          the first file from the tape:

               cd /usr/src
               mkdir netsys



                                October 26, 1981





                                     - 3 -


               cd netsys
               tar xpb 20

          The kernel sources should now be read in.  The network addi-
          tions  (source and header files) are contained in the bbnnet
          subdirectory.  In addition, there are modifications  to  the
          following files:

               fio.c, ioctl.c, locore.s, machdep.c,  main.c,  param.c,
               sys2.c, sys3.c in sys

               file.h, map.h in h

               conf.c in dev

          These modifications are delimited by:

               #ifdef BBNNET
               #endif BBNNET

          Also, there is a device driver, acc.c, in the dev  subdirec-
          tory, and its header file, accreg.h, in the h subdirectory.

               If you wish to merge the  network  software  with  your
          current  system, the bbnnet subdirectory must be created and
          copied in your /usr/src/sys, the BBNNET  modifications  must
          be  made to the files in sys and h, and the driver code must
          be put in dev and h.

               Otherwise, just make your local  modifications  in  the
          files  of  /usr/src/netsys,  and make that your /usr/src/sys
          hierarchy.

          _2._2.  _C_o_n_f_i_g_u_r_i_n_g _t_h_e _N_e_t_w_o_r_k _S_o_f_t_w_a_r_e

               Once  the  sources  have  been  properly  installed  in
          /usr/src/sys, you must modify files in the conf subdirectory
          to include the network additions.  You can use the files  in
          the distributed conf directory as a guide (i.e., conf/BBNSYS
          and conf/files).

               You must add the following entries to your system  con-
          figuration file:

               options BBNNET
               pseudo-device bbnnet
               pseudo-device pty
               device acc0 at uba_x csr _y_y_y vector acc_iint acc_oint

          The _u_b_a and _c_s_r fields of the acc  device  entry  should  be
          modified to the appropriate values for your system.

               You must add the following to the file conf/files:




                                October 26, 1981





                                     - 4 -


               optional acc.c device-driver
               optional pty.c
               optional bbnnet _x_x_x
                    ...

          where the last entries correspond to an entry for each  file
          in  the  bbnnet subdirectory (take these lines from the dis-
          tribution conf/files file).

               Make sure that dev/conf.c has been set up properly  for
          the acc device.  Use the distributed dev/conf.c as a guide.

               In addition to the files in  the  conf  directory,  you
          must  also  modify the file netconf.c in bbnnet directory to
          reflect you host's  interface(s)  to  the  network(s).   The
          first structure in the file, _s_t_r_u_c_t _i_f_c_b, contains one entry
          for each physical network interface device.  It need only be
          modified  if  you  are  attached to a network other than the
          ARPANET or have more than one network interface.  The impor-
          tant  line  in this structure is the second.  On it you must
          include the device  number  of  your  interface  (ACC's  are
          currently the only interface supported:  major device number
          is ACCDEV), the maximum packet size of the network  you  are
          interfaced to (1018 for the ARPANET), and its network number
          (ARPANET is net 10).   The second  structure  in  the  file,
          _s_t_r_u_c_t  _i_f__l_o_c_a_l_x, contains at least one entry for each phy-
          sical interface.   It  gives  the  network  address  of  the
          corresponding  interface.  The address is in internet inter-
          nal format, and is specified in the  ipaddr  macro  as  four
          decimal digits corresponding to the four bytes of the inter-
          net address.  (Thus, the address of BBN-VAX,  host  1/82  on
          the ARPANET would be specified as:

               ipaddr(10,1,0,82).

          Note that an interface may have more than one address.  Nor-
          mally, you should just be able to insert your host's address
          in the macro and leave it at that.  (Ultimately,  this  file
          will  be generated by _c_o_n_f_i_g(_8), as part of the compile time
          configuration process.)

               You should now be  able  to  compile  the  kernel  with
          _m_a_k_e(_1) and produce a running version of vmunix.

          _3.  _I_n_s_t_a_l_l_i_n_g _t_h_e _U_s_e_r _S_o_f_t_w_a_r_e

               The remaining file on the distribution tape consists of
          the  user level commands and libraries that make up the rest
          of the network software  package.   This  file  is  also  in
          _t_a_r(_1)  format,  and  consists  of a standalone hierarchy of
          everything you will need to make the commands and libraries.
          In addition, you will probably have to modify your mail pro-
          grams to operate with the network mailer  and  mail  server.
          The  necessary  modifications  are  described  in  the  next



                                October 26, 1981





                                     - 5 -


          section.

               To read the remaining files off the tape, make a direc-
          tory in the appropriate place and read the tape file:

               mkdir netuser
               cd netuser
               tar xpb 20 [the second file on the distribution tape]

          (N.B. All further relative pathnames will start here.)   The
          file  Contents  contains  a  description of the various sub-
          directories.

               Note: some programs reference the include files "con.h"
          and  "net.h" which are part of the kernel distribution.  You
          should make sure that these files  have  been  installed  in
          /usr/include/sys.

               Edit the file include/netfiles.h to your taste, if  the
          filenames contained therein are undesirable.

               You are now ready to build executables for the commands
          and  the  network  library.  Change to the src directory and
          issue the _M_a_k_e_i_t command.  This will construct libraries  in
          lib and then build the executables in bin.

               Now install the  resulting  files  in  the  appropriate
          places.   If  the  network  library is to be made public (so
          that other programs may use it)  the  file  include/netlib.h
          should   be  installed  in  /usr/include,  and  the  archive
          lib/libnet.a should be moved to /lib or /usr/lib.   Likewise
          the  executables  in bin should be placed in suitable direc-
          tories:

               host, net, netstat, ftp, telnet in /bin or /usr/bin

               mkgate,  mkhost,  prhost,  netser,   ftpsrv,   srvrftp,
               mtpsrv, srvrmtp, mailer in /etc/net

          In addition, you should install the gateway source table  in
          /etc/net.   This  file,  _g_a_t_e_w_a_y._b_i_n,  is  generated from an
          ASCII source file, _g_a_t_e_w_a_y, by the _m_k_g_a_t_e(_1) command, and is
          read  by  the kernel at boot time to initialize the internal
          gateway table.

          Before anything useful  can  be  done,  the  network  device
          should be created in /dev/net:

               mknod /dev/net/tcp c 255 0

          You should edit the MAKE shell script  in  /dev  to  include
          this.

               Also, the network information  files  must  be  set  up



                                October 26, 1981





                                     - 6 -


          correctly.   (The  names of these files are contained in the
          include  file  _i_n_c_l_u_d_e/_n_e_t_f_i_l_e_s._h)  The  file  /_e_t_c/_T_H_I_S_H_O_S_T
          should  contain  the  name  of  the  local  host.   The file
          /_e_t_c/_N_E_T_W_O_R_K_S should contain the host  address  and  network
          number of local system (e.g., 5/82,10 -- host 5 on imp 82 on
          network 10).  The ASCII version of the host  map  should  be
          revised  slightly  (see doc/host_map.5.P) to account for the
          requirement of network capabilities.  A sample host  map  is
          provided  in  the  directory,  etc.   Finally,  the  command
          _m_k_h_o_s_t(_1), must be used to create a binary host name/address
          map from the ASCII, by

               mkhost -o tmpfile
               prhost -i tmpfile

          and inspecting the output of prhost.  If it  is  acceptable,
          running  _m_k_h_o_s_t with no arguments will build a binary map in
          the correct place for use by the library and other software.

               In order to run the TELNET server  (netser),  you  must
          configure pseudo-teletype (pty) devices, which allow network
          users to appear to be logging in on ttys.   The  distributed
          kernel  is  configured for 16 ptys.  To change the number of
          possible ptys, modify NPTY in dev/pty.c.  For each  pty  you
          plan  to  use, create corresponding special files.  Two spe-
          cial files are required for each available pty, created by:

               mknod /dev/pty_x c 21 _y
               mknod /dev/tty_x c 20 _y

          where _x should  be  a  single  capital  letter,  and  _y  the
          corresponding  origin  0  number  (e.g., the first pty would
          have two files, /dev/ptyA and /dev/ttyA, with device numbers
          (21,0)   and   (20,0),  respectively).   You  should  modify
          /dev/MAKE to create as many of these files as  you  require.
          Both special files are required: /dev/ptyx is the actual pty
          device, and the corresponding  /dev/ttyx  is  a  slave  that
          makes  programs  like  _g_e_t_t_y  and  _w_h_o happy.  You must also
          include entries in /etc/ttys for  each  /dev/ttyx,  so  that
          logins can occur.

               You should now be able to run the supplied network com-
          mands.  Add  lines to your /etc/rc file to invoke the TELNET
          (netser), FTP (ftpsrv), and MTP (mtpsrv)  servers,  and  the
          mail  daemon  (mailer).   (Be sure to set up the mail server
          and mailer to work with  your  mail  programs,  see  below.)
          These commands, and their output logfiles, should be run out
          of /etc/net.

          _3._1.  _S_e_t_t_i_n_g _u_p _t_h_e _M_a_i_l _S_o_f_t_w_a_r_e

               The mail software uses MTP (the Mail Transfer Protocol)
          to  send  and  receive  mail  over  the  network.   The mail
          receiver (srvrmtp) gathers up the incoming mail in  a  file,



                                October 26, 1981





                                     - 7 -


          and  then invokes a mail sending program to deliver the con-
          tents of the file to a local user's mailbox.   Two  versions
          of  srvrmtp  are  provided  in this distribution.  One calls
          upon the BBN mail program _s_n_d_m_s_g (not included in this  dis-
          tribution)  to  deliver  mail  locally.   The other uses the
          Berkeley _d_e_l_i_v_e_r_m_a_i_l program  to  perform  this  task.   The
          relevant  code  is #ifdef'd on "DELIVERMAIL", and the binary
          versions are _s_r_v_r_m_t_p and _s_r_v_r_m_t_p._d.

               If your site uses neither of these programs,  you  will
          have  to  modify the routine "sndmsg" in srvrmtp.c to invoke
          your mail program.  Your mail program must be able to read a
          complete  message  (containing  an  RFC733 header plus text)
          from a file and deposit it into a mailbox.   If  it  is  not
          possible  to  specify  an input file as a command line argu-
          ment, srvrmtp can usually achieve the same effect by closing
          the  standard input and opening the file just before execut-
          ing the mail sending program.   See  the  code  in  "sndmsg"
          which invokes _d_e_l_i_v_e_r_m_a_i_l.

               Mail going out to the network is queued in  the  direc-
          tory  /_u_s_r/_s_p_o_o_l/_n_e_t_m_a_i_l.  A mailer daemon scans this direc-
          tory every few minutes looking for work to do.  There is one
          file  for  each  piece  of outgoing mail.  The first line of
          every file contains information for the use of  the  mailer,
          and  the  rest  of  the file is the message to be sent.  The
          format of the information line is as follows:

                    host:user:return:

          with no blanks.  _H_o_s_t is the name of the  destination  host,
          _u_s_e_r is the name of the intended recipient at that host, and
          _r_e_t_u_r_n is the return address for the mail, usually the  ori-
          ginator of the message.  You will have to see to it that the
          program that queues network mail on your system places  mes-
          sages in /_u_s_r/_s_p_o_o_l/_n_e_t_m_a_i_l in this format.

               Any questions regarding the  mail  software  should  be
          directed to Eric Shienbrood (shienbrood@bbn-unix).

          _4.  _O_p_e_r_a_t_i_n_g _t_h_e _N_e_t_w_o_r_k _S_o_f_t_w_a_r_e

               The software should need little attention  once  it  is
          running.   There  are no procedures for bringing the network
          up or down.  The software works if the network is available,
          and  re-initializes  itself  when  the network goes down and
          comes back up.  The _n_e_t_s_t_a_t(_1) command can be used to deter-
          mine  the status of network connections and the condition of
          the software (number of  buffers  in  use,  etc.).   If  any
          errant  connections  are  found  hanging around, they can be
          cleared with the _n_e_t_r_e_s_e_t(_1) command (its  argument  is  the
          TCB  address  taken from netstat).  The other network utili-
          ties, netdebug, trpt, and tcptest, can all be used  to  test
          the  network  software and debug programs written to use the



                                October 26, 1981





                                     - 8 -


          net.

          _5.  _F_u_t_u_r_e _M_o_d_i_f_i_c_a_t_i_o_n_s

               The software package now being distributed is a prelim-
          inary  test  version.  Work is currently underway at BBN and
          Berkeley on performance  evaluation  and  improvement.   The
          user interface will be modified to operate with whatever IPC
          mechanisms ultimately adopted by the ARPA Berkeley  Steering
          Committee.  In addition, the raw IP and local network inter-
          faces  will  be  undergoing  substantial   modification   to
          increase their utility.  The raw interfaces provided in this
          release have not been extensively tested.

               In the meantime, I'd appreciate  your  comments.   Good
          luck!

                                                  Rob Gurwitz
                                                  gurwitz@bbn-unix
                                                  617-497-3041





































                                October 26, 1981


