/*
 *	System error logger - /etc/errlogger
 *
 * Should be started by /etc/rc (if not earlier) & left to run
 * indefinitely. Reports of errors from /dev/errlog are written to
 * "/etc/loggederrors" for later analysis. If this file exists, data
 * will be appended to it, if not, it will be created.
 *
 * This program runs in the background, all by itself.
 */

#define	fault(s)	write(cons, s, sizeof s)

char console[] = "/dev/console";
char errlog[]  = "/dev/errlog";
char errors[]  = "/etc/loggederrors";

char e_open[] = "Errlog: Can't open errlog\n";
char e_creat[] = "Errlog: Can't make error file\n";
char e_rd[] = "Errlog: read error on errlog\n";
char e_lost[] = "Errlog: lost errors\n";
char e_wrt[] = "Errlog: write error\n";

struct hd {
	long	etime;
	int	reclen;
};

struct {
	struct hd hdr;
	char	buf[512];	/* plenty of space */
} err;

main()
{
	register f, l, o;
	register cons;

	for (f = 0; f < 20; f++)
		close(f);
	for (f = 0; f < 14; f++)	/* All std sigs but SIGTERM (14) */
		signal(f, 1);		/* So, lint won't be happy */

	if ((cons = open(console, 1)) < 0)
		exit(1);

	if ((f = open(errlog, 0)) < 0) {
		fault(e_open);
		exit(1);
	}
	if ((o = open(errors, 1)) < 0 && (o = creat(errors, 0666)) < 0) {
		fault(e_creat);
		exit(1);
	}
	lseek(o, 0L, 2);
	if (fork())
		exit(0);

	for (;;) {
		l = read(f, err.buf, 512);
		if (l < 0) {
			fault(e_rd);
			exit(1);
		}
		if (l == 0)
			fault(e_lost);
		time(&err.hdr.etime);
		err.hdr.reclen = l;
		l += sizeof (struct hd);
		if (write(o, &err, l) != l) {
			fault(e_wrt);
			exit(1);
		}
	}
}
