#include	"../mac/mac.h"
#include	"../mac/m.out.h"	/* for magic words */
#include	"mactab.h"
#include	"mactab.x"


/*
 *   Machine header section.
 *
 *   Contains a set necessary data items describing
 *   the target machine's architecture.
 */
phed()
{
	register char *r;
	register char cc;
	register int ndc;
	register int i;

	ndc = 0;			/* number of dc?'s */
	head.h_page = 60;		/* def. page size */
	head.h_i_len = 1;		/* basic instr len = 1 addressable
					/* unit
					*/
	head.h_i_flg = 0;		/* free form instrs */
	head.h_addr = 16;		/* def. addr. len. = 16 bits */
	head.h_mword = MWORDR;		/* r-file magic word */
	head.h_macmword = MWORD;	/* m.out default magic word */

	while (getlin())  {

		getsym();
		if (sym != LBL)  {
			error("symbolic needed", 0);
			continue;
			}

		if (compar("dc", clabel))  {
			if (ndc >= 4)  {
				error("only 4 dc's allowed", 0);
				continue;
				}

			getsym();
			if (sym != LBL && sym != LIT)  {
				error("dc char missing", 0);
				continue;
				}

			head.dctype[ndc].f_class = clabel[0];

			while (*p == ' ' || *p == '\t')
				p++;

			head.dctype[ndc].f_len = fmtscan(&head.dctype[ndc]);

			ndc++;
			continue;
			}

		if (compar("defmt", clabel))  {
			head.dctype[4].f_class = '\0';
			while (*p == ' ' || *p == '\t')
			p++;
			head.dctype[4].f_len = fmtscan(&head.dctype[4]);
			continue;
			}

		if (compar("mac", clabel))  {
			getsym();
			if (sym != STR)  {
				error("string needed", 0);
				continue;
				}

			copy(clabel, head.h_mac);
			continue;
			}

		if (compar("page", clabel))  {
			getsym();
			if (sym != CON)  {
				error("page length required");
				continue;
				}

			head.h_page = mem;
			continue;
			}

		if (compar("byte", clabel))  {
			getsym();
			if (sym != CON || mem <= 0)  {
				error("funny byte width %s", clabel);
				continue;
				}

			head.h_bu_len = mem;
			continue;
			}

		if (compar("word", clabel))  {
			getsym();
			if (sym != CON || mem <= 0)  {
				error("funny word width %s", clabel);
				continue;
				}

			head.h_w_len = mem;
			continue;
			}

		if (compar("instr",clabel))  {
			getsym();
			if (sym != CON || mem <=0)  {
				error("funny instruction width %s", clabel);
				continue;
				}

			head.h_i_len = mem;
			continue;
			}

		if (compar("bind",clabel))  {

			head.h_i_flg = 1;
			continue;

			}

		if (compar("addr",clabel))  {
			getsym();
			if (sym != CON || mem <= 0)  {
				error("funny address bit width %s", clabel);
				continue;
				}

			head.h_addr = mem;
			continue;
			}

		if (compar("magic",clabel))  {
			getsym();
			if (sym != CON)  {
				error("funny magic number %s", clabel);
				continue;
				}

			head.h_macmword = mem;
			continue;
			}

		if (compar("ii", clabel))  {
			warn("illegal instr. no longer required");
			continue;
			}

		if (compar("pc", clabel))  {
			getsym();
			if (sym != LBL)  {
				error("label needed", 0);
				continue;
				}

			if (compar("pre", clabel))
				head.h_pc_post = FALSE;
			else
				if (compar("post", clabel))
					head.h_pc_post = TRUE;
				else
					error("pre/post pc only", 0);

			continue;
			}

		error("bad header descriptor %s", clabel);
		}

	return;
}
