#include	"mac.h"
#include	"m.out.h"
#include	"mac.x"


/*
 *   Define constant routines.
 */
prdc1()
{
	prdc(0);
	return;
}

prdc2()
{
	prdc(1);
	return;
}

prdc3()
{
	prdc(2);
	return;
}

prdc4()
{
	prdc(3);
	return;
}

prdc(n)
register int n;
{
	p = intercode.i_opr;
	if (!*p)  {
		synerr("expression required");
		return;
		}

	/*
	 *   Bump pc up by the length of the constant.
	 */
	locn[lcntr].l_value += head.dctype[n].f_len;

	return;
}



/*
 *   Special dc.
 *	Can define strings or constants.
 */
prdcs()
{
	register struct fd *f;
	register int len;

	/*
	 *   Allow a string, or a single expr.
	 */

	f = &head.dctype[4];
	if (!f->f_len)  {
		/* dc has not been declared in the r-file */
		synerr("dc not allowed");
		return;
		}

	p = intercode.i_opr;

	if (*p == '"')  {
		p++;
		len = 0;
		while (*p++ != '"')
			len++;

		locn[lcntr].l_value += len;
		return;
		}
	synerr("string required");
	return;
}



/*
 *   Null routine - just return.
 */
prnull()
{
	return;
}



/*
 *   Equate a label to a value. (defined expression)
 *   A check has already been made for a re-defined
 *   label tag.
 */
prequ()
{
	register struct	st *q;

	p = intercode.i_opr;		/* operand field */
	q = intercode.i_label;
	if (q == NULL)  {
		synerr("label tag required");
		return;
		}

	q->s_value = expr();
	q->s_mode &= ~(ABS|REL|GLOB); /* These are set to the relocatability
					 of the expression */

	switch(reloc & RLBL) {

	case 0:
		break;

	case RABS:
		q->s_mode |= ABS;
		break;

	case RREL:
		q->s_mode |= REL;
		break;

	case RLBL:
		q->s_mode |= GLOB;
		q->s_mode &= ~DEFN;
		break;
	}

	/* set the new label's class */

	q->s_class = class == -1 ? 0 : class;

	return;
}


/*
 *   Turn on global indicator.
 *   Useful only for loader format output.
 */
prglobal()
{
	register struct	st *q;

	p = intercode.i_opr;
	if (*p++ != '$')  {
		synerr("label required");
		return;
		}

	q = (struct st *)argnum();
	q->s_mode |= GLOB;

	return;
}


/*
 *   Align pc to an even multiple of expr().
 *   If already at the boundary - no align done.
 */
pralign()
{
	register int v;
	register int r;
	register int l;

	p = intercode.i_opr;
	v = expr();
	if (v < 1)
		v = bu;
	else
		v *= bu;
	l = locn[lcntr].l_value;
	r = l % v;
	if (!r)
		/* no align needed */
		return;

	locn[lcntr].l_value += v-r;
	return;
}


/*
 *   Set origin of pc
 */
prorg()
{
	register int v;
	register int l;
	register struct lt *lc = &locn[lcntr];
	register struct ol *ol;

	p = intercode.i_opr;
	v = expr();
	v *= bu;
	if (v < 0)  {
		synerr("negative org");
		return;
		}

	ol = getol(OL);

	(lc->l_currorg)->ol_lcend = lc->l_value;
	(lc->l_currorg)->ol_next = ol;
	lc->l_currorg = ol;

	ol->ol_lcstart = ol->ol_lcend = lc->l_value = v;
	ol->ol_start = NUL; ol->ol_next = NUL;

	/* no pading */
	intercode.i_locn = 0;
	return;
}


/*
 *   Set segment indicator
 */
prseg()
{
	register int v;
	register int l;

	p = intercode.i_opr;
	v = expr();
	if (v < 0 || v >= LCOUNT)  {
		synerr("no such location counter");
		return;
		}

	lcntr = v;
	return;
}


/*
 *   Reserve (n) bu's of null storage.
 */
prds()
{
	register int v;
	register int l;

	p = intercode.i_opr;
	v = expr();
	v *= bu;
	if (v < 0)  {
		synerr("negative ds");
		return;
		}

	locn[lcntr].l_value += v;
	return;
}


/*
 *   end:   Set eof flag, and check symbol table.
 *	    (not ref, undefined etc)
 */
prend()
{
	register struct	st *q;
	register int n;

	eof = TRUE;			/* set end-of-source flag */

	n = 0;
	q = symtab;
	while (q != NULL) {
		if (q->s_mode & LITR)  {		/* skip literals */
			q = nextsym(q);
			continue;
			}

		switch(q->s_mode & (DEFN | GLOB)) {

		case DEFN:
			break;

		case GLOB:
			q->s_value = globno++;
			break;

		case DEFN | GLOB:
			globno++;
			break;

		case 0:
			n++;
			printf("label %-8s is undefined\n", q->s_u.s_name);
			break;
		}

		q = nextsym(q);				/* next symbol */
		}

	if (n) {
		synerr("Undefined labels");
		return;
	}

	p = intercode.i_opr;
	startad = (*p) ? expr() : 0;

	return;
}


/*
 *   Structure offset definition.
 */
prstruc()
{
	register struct st *q;

	p = intercode.i_opr;		/* operand field */
	q = intercode.i_label;

	if (q != NULL)  {
		/* Equate label to struct offset now */
		q->s_value = nstruc;
		}

	nstruc += expr();

	return;
}



/*
 *   End structure offset counter.
 */
prends()
{
	register struct st *q;

	q = intercode.i_label;
	if (q != NULL)  {
		q->s_value = nstruc;
		}

	/* Reset structure counter */
	nstruc = 0;
	return;
}

/*
 *	Include file
 */
princl() {
	register char *q, *r, *s;
	register int len;
	char *filenm;
	FILE *f;

	p = intercode.i_opr;
	if (*p == '"')  {
		p++;
		len = 0;
		q = r = p;
		while (*r++ != '"')
			len++;
		p = r;

	} else {
		synerr("string required");
		return;
	}
	filenm = s = getmem(len + 1);
	r--;	/* reverse over '"' */
	while ( q < r )
		*s++ = *q++;
	*s = '\0';

	if ((f = fopen(filenm, "r")) == NULL) {
		synerr("Can't open include file");
		return;
	}

	if(inclevel >= MAXINCL) {
		synerr("Includes nested too deep");
		return;
	}

	inclstk[inclevel].inc_fil = src;
	inclstk[inclevel].inc_name = currfile;
	inclstk[inclevel].inc_list = liston;
	inclstk[inclevel++].inc_line = nline;

	src = f;
	currfile = filenm;
	nline = 0;
	return;
}

prlsb() {
	symhash[SYMHASH] = NUL;
}
