#include <stdio.h>

#define		INTERDATA
/*
#define		PDP11
*/

/* #define		MAPCH		/* map UC -> lc in symbols */

/*
 *   getsym symbol descriptors.
 */
#define	NUL	0		/* null descriptor */
#define	LBL	1		/* label */
#define	CON	2		/* constant */
#define	SPA	3		/* spaces */
#define	DEL	4		/* delimiter */
#define	EOL	5		/* end of line */
#define	EoF	6		/* end of file - different from stdio */
#define	COM	7		/* comment */
#define	OPR	8		/* operator */
#define	STR	9		/* string */
#define	MCH	10		/* global match */
#define LPL	11		/* literal pool */

#define	EXP	20		/* for mactab only - will NEVER appear */
#define	SKP	21		/* no match symbol */

#define	LIT	22		/* literal */
#define	CHR	23		/* extra character */


/*
 *   pass1 action table descriptors
 */
#define	NOOP	0		/* no-op */
#define	ALBL	1		/* add label to ifield */
#define	DOPV	2		/* decode op & value */
#define	OLBL	3		/* out label to i_opr */
#define	OOPR	4		/* out opr */
#define	ODEL	5		/* out del ',' */
#define	OCON	6		/* out constant */
#define	OCHR	7		/* out character */
#define	OSTR	8		/* output string */
#define	ENDP	9		/* end pass */
#define	SELC	10		/* select options */
#define	EXPR	11		/* call expr parser */
#define	RETN	12		/* return from call */
#define	GOTO	13		/* fail return */
#define	OERR	14		/* error on scan */
#define	OREC	15		/* out i_rec (ok) */
#define LITP	16		/* literal table entry */
#define CLBL	17		/* only label of class mem may appear */

/*
 *   symbol table mode descriptors.
 */
#define	REFR	0x0001
#define	DEFN	0x0002
#define CLAS	0x0004
#define	LITR	0x0008
#define	GLOB	0x0010

#define	REL	0x0100
#define	ABS	0x0200

#define	PMODE	0x1000
#define	RMODE	0x2000


/*
 *   misc. descriptors.
 */
#ifdef	PDP11

#define	WORDSIZ	16		/* word size of host in bits */

#endif


#ifdef	INTERDATA

#define	WORDSIZ	32

#endif

#define	ERR	-1		/* error or undef */
#define	MAXBUF	256		/* general usage buffer size */
#define MAXOPR	256		/* number of slots for intercode operands */
#define	LCOUNT	8		/* number of locn counters */
#define	TRUE	1		/* some truth value */
#define	FALSE	0		/* zero => false */
#define	DEF	1		/* define symbol */
#define	LKP	2		/* lookup flag */
#define	SELFMT	0x01		/* select format */
#define	SELOPC	0x02		/* select opcode class */
#define	SELVAL	0x04		/* select value field */

#define	OP	0x0001		/* opcode bit */
#define	PS	0x0002		/* pseudo bit */

#define	OPTION(c)	flags[(c - 'a')]
#define	BITMASK(m)	(bitmask[(m)])
#define L_PCVAL		s_lit.s_pcvalue
#define L_LCNTR		s_lit.s_llcntr

#define SYMHASH		97		/* size of symbol hash table
					 * - should be a nice number for
					 * mod n hashing (a prime or something
					 */

#define MAXINCL		5		/* max file inclusion level */

/*
 *   struct definition
 */
struct	st	{			/* symbol & literal table */

	union s_ut	{
		char	s_name[8];	/* symbol name */

		struct	{		/* literal ident. for loader */
			int	s_pcvalue;	/* location of literal */
			int	s_llcntr;	/* segment containing lit */
		} s_lit;
	} s_u;

	int	s_value;		/* actual value */
	int	s_mode;			/* symbol or literal relocation mode */
	int	s_lcntr;		/* segment containing sym */
	int	s_class;		/* label class */
	struct	st	*s_next;	/* next in chain */
	};

struct	it	{			/* intermediate code */
	int	i_flags;		/* tag bits - op, pseudo */
	struct st *i_label;		/* label index to symtab */
	int	i_op;			/* opcode table entry */
	int	i_locn;			/* current location */
	char	i_selc[4];		/* action selection */
	char	i_opr[MAXOPR];		/* operand description */
	};

struct	lt	{			/* location counter table */
	int	l_value;		/* lcntr value */
	int	*l_next;		/* next object word */
	int	l_lop;			/* previous instruction pad type */
	struct ol	*l_orgs;		/* code origin block list */
	struct ol	*l_currorg;	/* current code origin block */
	struct rl	*l_rlsts;	/* start of relocation info */
	struct rl	*l_rlste;	/* end of relocation list */
	int	l_rsize;		/* no of relocation entries */
	};

struct	ol	{
	int	*ol_start;		/* code buffer for this origin */
	int	ol_lcstart;		/* loc cntr start */
	int	ol_lcend;		/* loc cntr of end of block */
	int	ol_reloc;		/* relocatability of PC for this org */
	struct ol	*ol_next;		/* link down chain */
};

struct	rl	{ /* Relocation info for a location if relocatable or
			undefined global */
	int	rl_type;	/* relocation type */
	int	rl_mask;	/* relocation bit mask */
	int	rl_addr;	/* address of item to be relocated */
	/* Other interesting info. which depends on the relocation type */
	union {
		int	rl_lcntr;	/* which locn. cntr if not global ref */
		int	rl_gln;		/* index of global label - output form */
		struct st	*rl_glp;	/* pointer to undef global sym */
	}rl_u;
	struct rl	*rl_next;
};

struct	fd	{			/* format descriptor */
	char	f_class;		/* instr class */
	char	f_len;			/* len of instr in bu's */
	int	f_desc[8];		/* descriptor type */
	int	f_value[8];		/* values */
	int	f_width[8];		/* widths of bits */
	};

struct	bt	{			/* i/o buffer */
	int	b_fdesc;		/* file desc */
	int	b_left;			/* nleft */
	char	*b_next;		/* next */
	char	b_buf[512];		/* char buffer */
	};

struct	ht	{			/* header record */
	int	h_mword;		/* magic wd */
	int	h_macmword;
	int	h_literals;		/* # of literals */
	int	h_labels;		/* # pre-def labs */
	int	h_formats;		/* # of f desc */
	int	h_ops;			/* # of ops */
	struct	oc *h_opstart;		/* for relocation of the op table */
	struct	fd	dctype[5];
	int	h_pc_post;		/* pc incr */
	int	h_bu_len;		/* len of bu in bits */
	int	h_w_len;		/* len of wrd in bu */
	int	h_i_len;		/* length of basic instruction */
	int	h_i_flg;		/* address bounded instruction set */
	int	h_addr;			/* bit length of address's */
	int	h_o_len;		/* opcode table len (bytes) */
	int	h_p_len;		/* len of parser table */
	int	h_p_start;		/* start of parser */
	int	h_page;			/* page len */
	char	h_mac[32];		/* title */
	};

struct oc {		/* there is one of these per opcode */
	char oc_name[8];    /* name of the opcode */
	struct os *oc_list; /* selector list for opcode */
};

struct os {		/* There is one of these for each legal opcode
			 * arg picture match
			 */
	int	os_sel,	/* select this when match with arg pic. value */
		os_fmt, /* use this format for if SELFMT is on */
		os_opc;	/* this is the opcode value */
	struct os *os_next;
};

struct	tbl	{			/* parser table */
	int	tb_sym;			/* symbol type */
	int	tb_mem;			/* member type */
	int 	tb_next;		/* next entry */
	int	tb_act;			/* action before next case */
	char	tb_arg[4];		/* args for action */
	};

struct	pt	{			/* print constants */
	int	c_dw;			/* code digit width */
	int	c_bw;			/* code bit width */
	int	l_dw;			/* locn digit width */
	int	l_iw;			/* locn incr. width */
	int	l_ai;			/* locn addr. incr. */
	int	w_dw;			/* word digit width */
	int	w_bt;			/* word bit tally */
	int	w_bw;			/* word bit width */
	int	w_rw;			/* MSD bit width */
	int	f_dw;			/* format digit width */
	int	f_bt;			/* format bit tally */
	int	f_bw;			/* format bit width */
	int	i_dw;			/* instruction form digit width */
	};

struct inclstk {
	FILE	*inc_fil;		/* file pointer for included file */
	char	*inc_name;		/* name of stacked file */
	int	inc_line;		/* line no. of stacked file */
	int	inc_list;		/* stacked liston flag */
};


#define	ST	(sizeof (struct st))
#define	IT	(sizeof (struct it))
#define	LT	(sizeof (struct lt))
#define	FD	(sizeof (struct fd))
#define	BT	(sizeof (struct bt))
#define	HT	(sizeof (struct ht))
#define PT	(sizeof (struct pt))
#define	TBL	(sizeof (struct tbl))
#define OL	(sizeof (struct ol))
#define RL	(sizeof (struct rl))
#define	INT	(sizeof (int))
