/*
 * Spool Queue examination program
 *
 * sq [users...] [-]
 *
 * - =>'s all users
 *
 * S. J. Leffler
 * 5/9/80
 */
#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/dir.h>
#include	<pwd.h>
#include	<sys/stat.h>

#define MAXUSERS	50
#define READ	0
#define SPOOLDIR	"/usr/spool/lpd"
#define	LOCKFILE	"/usr/spool/lpd/lock"

struct passwd user[MAXUSERS];
struct direct *pdir;
int	users;
int	current_pid;
int	rank = 1;
extern struct passwd *getpwnam(), *getpwuid();

main(argc, argv)
char *argv[];
{
	register int	i,
			nitems,
			garbage = 0;
	int	spfd;
	register struct passwd *p;

	argv++;
	while (argc > 1)
	{
		if (argv[0][0] == '-') {
			if (users)
				usage();
			users = -1;
		} else {
			if (users < 0)
				usage();
			if (users >= MAXUSERS)
				fatal("too many users");
			p = getpwnam(*argv);
			if (p)
				user[users++] = *p;
			else
				printf("unknown user %s\n", *argv);
		}
		argc--;
		argv++;
	}
	if (!users) {
		if ((p = getpwuid(getuid())) == NULL)
			fatal("who are you?");
		user[users++] = *p;
	}
	/*
	 * Find all the spool files in the spooling directory
	 */
	if ((spfd = open(SPOOLDIR, READ)) < 0)
		fatal("can't examine %s\n", SPOOLDIR);
	lseek(spfd, (long)(2*sizeof(struct direct)), 0);	/* skip . & .. */
	pdir = (struct direct *)malloc(sizeof(struct direct));
	nitems = 0;
	while (1)
	{
		struct direct proto;
		/*
		 * Collect the daemon files (dfxxxxx)
		 */
		if (read(spfd, (char *)&proto, sizeof(proto)) != sizeof(proto))
			break;
		if (proto.d_ino == 0 || proto.d_name[0] != 'd' || proto.d_name[1] != 'f')
			continue;	/* just daemon files */
		nitems++;
		if (pdir != NULL)
			pdir = (struct direct *)realloc((char *)pdir, nitems*sizeof(struct direct));
		else
			pdir = (struct direct *)malloc(sizeof(struct direct));
		if (pdir == NULL)
			fatal("out of memory");
		pdir[nitems-1] = proto;
	}
	if (nitems == 0) {
		printf("no entries\n");
		exit(0);
	}
	close(spfd);
	if ((spfd = open(LOCKFILE, READ)) < 0)
		garbage = nitems;
	else {
		lseek(spfd, (long)sizeof(int), 0);	/* skip daemon id */
		if (read(spfd, (char *)&current_pid, sizeof(int)) != sizeof(int))
			fatal("bad lock file");
		close(spfd);
	}
	/*
	 * Now, examine the daemon files and print out the jobs to
	 * be done for each user
	 */
	for (i = garbage; i < nitems; i++)
		inform(pdir[i].d_name, 1);

	/*
	 * What's left is garbage, inform the user
	 */
	if (garbage > 0)
		printf("Left over garbage:\n");
	for (i = 0; i < garbage; i++)
		inform(pdir[i].d_name, 0);

	exit(0);
}

inform(s, flag)
char *s;
{
	int	spfd;
	register int j;
	FILE	*fd;
	char	line[100];
	char	file[100],
		ufile[100],
		*format = NULL;
	int	daemon_pid = atoi(s+3);
	/*
	 * There's a good chance the daemon file has gone away
	 * in the meantime; if this is the case just keep going
	 */
	strcpy(line, SPOOLDIR);
	strcat(line, "/");
	strcat(line, s);
	if ((spfd = open(line, READ)) >= 0)
	{
		struct stat buf;

		fstat(spfd, &buf);
		for (j = 0; j < users; j++)
			if (user[j].pw_uid == buf.st_uid)
				break;
		if (users < 0 || j < users) {	/* found one */
			putchar('\n');
			if (users < 0) {
				register struct passwd *p;

				if ((p = getpwuid(buf.st_uid)) == NULL)
					printf("unknown user: ");
				else
					printf("%s: ", p->pw_name);
			} else {
				if (user[j].pw_name == NULL)
					printf("unknown user: ");
				else
					printf("%s: ", user[j].pw_name);
			}
			if (flag)
			{
				if (daemon_pid == current_pid)
					printf("currently active\n");
				else {
					if (rank == 1)
						printf("1st\n");
					else if (rank == 2)
						printf("2nd\n");
					else if (rank == 3)
						printf("3rd\n");
					else
						printf("%dth\n", rank);
					rank++;
				}
			}
			/*
			 * Now list the files associated with the
			 * print job
			 */
			fd = fdopen(spfd, "r");
			while (fgets(line, sizeof(line), fd) != NULL)
			{
				switch(line[0])
				{
					default:
						continue;
						
					case 'R':
						if (file[0] == '\0')
							strcpy(file, line+1);
						break;

					case 'H':
						strcpy(file, line+1);
						break;
						
					case 'B':
						format = "binary";
						break;
						
					case 'U':
						if (file[0] == '\0')
							strcpy(file, line+1);
						strcpy(ufile, line+1);
						break;
				}
				if (ufile[0]) {
					register char *t = file;
					struct stat lbuf;

					putchar('\t');
					while (*t && *t != '\n') t++;
					*t = '\0';
					printf("%-32.32s", file);
					t = ufile;
					while (*t && *t != '\n')t++;
					*t = '\0';
					if (!stat(ufile, &lbuf))
						printf(" %D bytes", lbuf.st_size);
					if (format) {
						printf(" (%s)", format);
						format = NULL;
					}
					putchar('\n');
					ufile[0] = file[0] = '\0';
				}
			}
			fclose(fd);
		}
		close(spfd);
	}
}

usage()
{
	printf("usage: sq [users...] [-]\n");
	exit(1);
}

fatal(s)
char *s;
{
	fprintf(stderr, "sq: %s\n", s);
	exit(2);
}
