# include "mfile2"
/*
 * a lot of the machine dependent parts of the second pass
 */
/*
 * The size of the largest structure (in words) that is moved in
 * a series of moves, rather than a loop ... this is also defined
 * in the first pass in code.c, and should really be the same.
 */
# define BIGSIZE	6
int	toff = 0;		/* number of stack locations used for args */
/*
 *	Table of operators that are too hard to do in-line, the
 *	routine hardops transforms the expression trees when they are
 *	read in, so that these operators are replaced with the
 *	appropriate function calls.
 */
struct functbl{
	int	fop;
	TWORD	ftype;
	char	*func;
}opfunc[] = {
	DIV,		LONG,	"ldiv",
	MOD,		LONG,	"lrem",
	MUL,		LONG,	"lmul",
	ASG DIV,	LONG,	"aldiv",
	ASG MOD,	LONG,	"alrem",
	ASG MUL,	LONG,	"almul",
	DIV,		ULONG,	"uldiv",
	MOD,		ULONG,	"ulrem",
	MUL,		ULONG,	"ulmul",
	ASG DIV,	ULONG,	"auldiv",
	ASG MOD,	ULONG,	"aulrem",
	ASG MUL,	ULONG,	"aulmul",
	0,		0,	0
};
/*
 *	When the IO macro appears in the code table the hopcode function
 *	is called to extract the correct op code from the hoptab table.
 */
struct hoptab {
	int     opmask;
	char   *opstring;
}ioptab[] = {
	ASG PLUS,	"a",	/* add */
	ASG MINUS,	"s",	/* subtract */
	ASG OR,		"o",	/* or */
	ASG AND,	"d",	/* dot */
	ASG ER,		"x",	/* xor */
	ASG MUL,	"my",	/* multiply */
	ASG DIV,	"dv",	/* divide */
	ASG MOD,	"dv",	/* divide */
	ASG LS,		"l",	/* left arithmetic/logical shift */
	ASG RS,		"r",	/* right arithmetic/logical shift */
	-1,		""
};
/*
 * keyed to register number tokens
 */
char   *rnames[] = {
	"b", "a", "e", "d",		/* shared D register */
	"i", "j", "k",			/* index registers */
	"x"				/* SAU registers */
};
/*
 *	Register status table, indexed by the register defines in mac2defs.
 */
SHAPESZ     rstatus[] = {
	SBREG, SAREG|SACREG, SAREG, SDREG,
	SAREG|SIREG|SINREG, SAREG|SJREG|SINREG, 0,
	SXREG,
};
/*
 * Resource preference table.
 *
 * Used in reclaiming resources when rewriting a tree in reclaim().
 * Left hand side is the cookie the reclaim was done with, the right hand
 * side is the shape(s) preferred.
 */
struct respref  respref[] = {
	INDREG, SDREG,
	INXREG, SXREG,
	ININREG, SINREG,
	INAREG|INDREG|INXREG, SAREG|SDREG|SXREG,
	INAREG|INDREG|INXREG|ININREG,
		SAREG|SDREG|SXREG|SOREG|STIREG|STJREG|SNAME|STARNM|SCON,
	INTEMP, SOREG|INTEMP,
	FORARG, FORARG,
	INAREG|INDREG, SOREG|SNAME,
	FORCC,	SAREG|SDREG|SXREG|SOREG|STIREG|STJREG|SNAME|STARNM,
	0,	0
};
/*
 *	Conditional branch op code table, used by cbgen for generating
 *	code for the conditional branch sequences.
 */
char   *ccbranches[] = {
/* EQ */  "	boz	L%d\n",
/* NE */  "	bnz	L%d\n",
/* LE */  "	bnp	L%d\n",
/* LT */  "	bon	L%d\n",
/* GE */  "	bnn	L%d\n",
/* GT */  "	bop	L%d\n",
/* ULE */ "	bnp	L%d\n",
/* ULT */ "	bon	L%d\n",
/* UGE */ "	bnn	L%d\n",
/* UGT */ "	bop	L%d\n",
};
/*
 *	Conditional branch op code table, used (as above) for floating point
 */
char	*fccbranches[] = {
/* EQ */  "	bzs	L%d\n",
/* NE */  "	bzr	L%d\n",
/* LT */  "	bns	L%d\n",
/* LE */  "	bpr	L%d\n",
/* GE */  "	bnr	L%d\n",
/* GT */  "	bps	L%d\n"
};
/*
 * Table used to reverse relationals; needed in case the order of
 * a comparison with memory ends up reversed. (This avoids placing
 * the other side in a register).
 */
short revrel[] = {
	EQ, NE,
	GE, GT,
	LE, LT,
	UGE, UGT,
	ULE, ULT
};
/*
 * identify line l and file fn
 */
#ifndef lineid
lineid (l, fn)
char   *fn;
{
	printf("\t\t\t/ line %d, file %s\n", l, fn);
}
#endif
/*
 * End a block, and set size of the stack frame needed for local variables
 * and compiler generated temporaries.
 */
eobl2 ()
{
	OFFSZ spoff;		       /* offset from stack pointer */
	spoff = maxoff;
	if (spoff >= AUTOINIT)
		spoff -= AUTOINIT;
	spoff /= SZCHAR;
	SETOFF (spoff, 3);
	spoff /= 3;
	printf(".F%d = %D\n", ftnno, spoff);
	if (fltused) {
		fltused = 0;
		printf("	.globl	fltused\n");
	}
}
/*
 * output the appropriate string from the hoptab table
 */
hopcode (f, o)
	char	f;
	int	o;
{
	register struct hoptab *q;
	for (q = ioptab; q->opmask >= 0; ++q) {
		if (q->opmask == o  || q->opmask-1 == o) {
			printf ("%s", q->opstring);
			return;
		}
	}
	cerror ("no hoptab for %s", opst[o]);
}
/*
 * Machine independent interface to the code tables,
 * called when expand() runs across a `Z' in the code string.
 */
zzzcode (p, c)
NODE * p;
{
	register        m;
	extern int	negrel[];
	NODE		*r;
	switch (c) {
		case '?':			/* fixup STASG regs */
			r = getlr(p, 'L');
			goto stfix;
		case '@':			/* ditto, for the left */
			r = getlr(p, 'R');
		stfix:
			m = p->stsize / NCHPERINT;
			if (m <= BIGSIZE)	/* nothing to fix */
				return;
			printf("\tso%s\t%d\n", rnames[r->rval], m & ~01);
			return;
		case 'A':
			/*
			 * Can't init a char * by `.bac 0,0', so check first
			 */
			if (p->left->name[0] == '\0') {
				printf("	.word	");
				adrcon(p->left->lval);
			} else {
				printf("	.bac	");
				conput(p->left);
			}
			putchar('\n');
			return;
		case 'B':				/* fix up bll's */
			switch(p->left->op) {
				case ICON:
					p->left->op = NAME;
					conput(p->left);
					return;
				case REG:
					p->left->op = OREG;
					break;
				case NAME:
				case OREG:
					putchar('*');
					break;
				default:
					cerror("unexpected op %s to ZB", opst[p->left->op]);
			}
			adrput(p->left);
			return;
		case 'D':			/* stack char calulations (-) */
			psconv(p, getlr(p, 'L')->rval);
			return;
		case 'E':			/* same, but for (+) */
			paconv(p, getlr(p, '1')->rval);
			return;
		case 'G':			/* same, but use I1 for IL */
			bpadd(p, getlr(p, '1')->rval);
			return;
		case 'H':			/* ditto, but for I1 */
			psconv(p, getlr(p, '1')->rval);
			return;
		case 'I':
			cbgen (p->op, p->label, c);
			return;
		case 'K':			/* ditto, for the left */
			paconv(p, getlr(p, 'L')->rval);
			return;
		case 'J':			/* optimize -= for char * */
		case 'L':			/* optimize += for char * */
			if ((p->right->lval % 3) == 0) {
				p->right->lval /= 3;
				if (special(p->right, SCCON)) {
					printf("	aom	%ld\n",
					 c == 'L' ? p->right->lval : -p->right->lval);
					printf("	.lac	");
					conput(p->left);
					putchar('\n');
				} else {
					m = getlr(p,'1')->rval;
					if (c == 'J')
						printf("\ttn%s\t%ld\n", rnames[m],
							p->right->lval);
					else
						printf("\tto%s\t%ld\n", rnames[m],
							p->right->lval);
					printf("\ta%sm\t", rnames[m]);
					adrput(p->left);
					putchar('\n');
				}
				return;
			}
			printf("\ttm%s\t", rnames[m = getlr(p, '1')->rval]);
			adrput(p->left);
			putchar('\n');
			if (c == 'J')
				bpsub(p, m);
			else
				bpadd(p, m);
			printf("	t%sm	", rnames[m]);
			adrput(p->left);
			putchar('\n');
			return;
		case 'M':			/* fix up - on -= */
			p->right->lval = -p->right->lval;
			return;
		case 'N':
			/*
			 * Logical ops, turn into 0-1
			 */
			cbgen(0, m = getlab(), 'I');
			deflab(p->label);
			printf("	tz%s\n", rnames[getlr(p, '1')->rval]);
			deflab(m);
			return;
		case 'O':			/* fix up bpoint + cons */
			bpadd(p, getlr(p, 'L')->rval);
			return;
		case 'P':			/* fix up bpoint - cons */
			bpsub(p, getlr(p, 'L')->rval);
			return;
		case 'Q':			/* fix up bpoint - cons */
			bpsub(p, getlr(p, '1')->rval);
			return;
		case 'R':			/* reversed logical compares */
		case 'F':			/* floating version of " */
			if (p->op > NE)
				p->op = revrel[p->op - EQ];
			cbgen(p->op, p->label, c);
			return;
		case 'S':			/* inverted logical compares */
			/*
			 * Only happens on longs, when we subtract in opposite
			 * direction.
			 */
			m = p->op;
			if (m != EQ && m != NE)
				p->op = negrel[m - EQ];
			cbgen(p->op, p->label, 'I');
			return;
		case ']':			/* Rd => Ra in PA/SCONV */
			getlr(p, '1')->rval = Ra;
			return;
		case 'T':
			/*
			 * Truncate longs for type conversions:
			 * LONG|ULONG->CHAR|UCHAR|INT|UNSIGNED
			 */
			m = p->type;
			p = p->left;
			if (p->op != REG)
				cerror("illegal ZT conversion, op %s", opst[p->op]);
			rfree (p->rval, p->type);
			p->rval = Ra;
			p->type = m;
			rbusy (p->rval, m);
			return;
		case 'U':		/* negate value for tnR */
			p->lval = -p->lval;
			return;
		case 'V':		/* structure argument */
			if (p->op != STARG)
				cerror("zzzcode, ZV: not a STARG");
			starg(p, getlr(p, 'L'));
			return;
		case 'W': 	       /* structure assignment */
			if (p->op != STASG)
				cerror ("zzzcode, ZW: not a structure");
			stasg(p, getlr(p, 'L'), getlr(p, 'R'));
			return;
		case 'X':
		case 'Y':
			/*
			 * To insure we get the right registers
			 * for a mod op, we request the D register,
			 * now we must coerce things so that it
			 * appears that the result is in the E register.
			 * To do this we place it on the left (X) or
			 * right (Y) rval, as needed.
			 */
			m = p->type;
			p = (c == 'X' ? p->left : p->right);
			if (p->op != REG)
				cerror("illegal ZX conversion, op %s", opst[p->op]);
			rfree(p->rval, p->type);
			p->rval = Re;
			p->type = m;
			rbusy(p->rval, m);
			return;
		case 'Z':
			/*
			 * Fix up long ops that use constants, but
			 * only the top part...blasted longs on the /6
			 */
			{
				register NODE	*r = p->right;
				if (r->op == ICON && r->name[0] == '\0')
					printf("$0%O", r->lval >> SZINT-1);
				else
					adrput(r);
			}
			break;
		default:
			cerror("illegal zzzcode %c", c);
	}
}
#ifndef rmove
/*
 *	Register transfer, usually called only in reclaim() when
 *	the result is not in a MUSTDO register.
 */
rmove(rt, rs, t)
	TWORD	t;
	int	rt,
		rs;
{
	printf("	t%s%s\n", rnames[rs], rnames[rt]);
}
#endif
#ifndef setregs
/*
 * Set up the number of free registers, easy since there are no register
 * variables used.
 */
setregs()
{
	fregs = 4;
}
#endif
#ifndef szty
/*
 * Size of type t in registers (sort of)
 */
szty(t)
	TWORD	t;
{
	if(t == LONG || t == ULONG)
		return(SZLONG/SZINT);
	return(1);
}
#endif
#ifndef rewfld
/*
 * Rewrite rules for fields
 */
rewfld(p)
	NODE	*p;
{
	return(1);
}
#endif
/*
 * What register should be used to call the function under p
 */
callreg(p)
	NODE	*p;
{
	switch(p->type){
		case DOUBLE:
		case FLOAT:
			return(FRx);
		case LONG:
		case ULONG:
			return(Rd);
		default:
			return(Ra);
	}
	/* NOTREACHED */
}
/*
 * Boolean, return 1 if p/o represent a leaf node in the tree
 */
shltype(o, p)
	NODE	*p;
{
	if(o == NAME || o == REG || o == ICON || o == OREG)
		return(1);
	return(o == UNARY MUL && shumul(p->left));
}
/*
 * Boolean, does the tree p form a field shape
 */
flshape(p)
	register NODE	*p;
{
	register	 o = p->op;
	if(o == NAME || o == REG || o == ICON || o == OREG)
		return(1);
	return(o == UNARY MUL && shumul(p->left));
}
/*
 * Boolean, does p represent a temporary shape.
 */
shtemp(p)
	register NODE	*p;
{
	if(p->op == UNARY MUL)
		p = p->left;
	if(p->op == REG || p->op == OREG)
		return(!istreg(p->rval));
	return(p->op == NAME || p->op == ICON);
}
/*
 * Is v the right value to increment something of type t ?
 */
spsz(t, v)
	TWORD	t;
	CONSZ	v;
{
	if(!ISPTR(t))
		return(0);
	t = DECREF(t);
	if(ISPTR(t))
		return(v == 1);
	switch(t){
		case UCHAR:
		case CHAR:
		case INT:
		case UNSIGNED:
			return(v == 1);
		case DOUBLE:
		case FLOAT:
		case LONG:
		case ULONG:
			return(v == 2);
	}
	return(0);
}
/*
 * Define the shapes that may lie under a UNARY MUL (i.e. STARNM & STREG's)
 */
SHAPESZ
shumul(p)
	register NODE	*p;
{
	register	o = p->op;
	if(o == NAME || o == OREG)
		return(STARNM);
	if (o == REG) {
		if (p->rval == Ri)
			return(STIREG);
		if (p->rval == Rj)
			return(STJREG);
	}
	return(0);
}
/*
 *	Help build instruction mnemonics by outputing register names or
 *	`m' for a memory reference.
 */
insput(p, c)
	register NODE	*p;
	char		c;
{
	register	m;
	extern int	consflg;
	switch(c) {
		case '1':
		case '2':
		case '3':
		case 'R':
		case 'L':
			m = p->op;
			p = getlr(p, c);
			switch(p->op) {
		
				case NAME:
				case OREG:
				case UNARY MUL:
					putchar('m');
					return;
		
				case REG:
					printf("%s", rnames[p->rval]);
					return;
		
				case ICON:
					/*
					 * Check to see if it'll fit as an operand or must be
					 * a memory reference.
					 */
					/*
					 * Don't make doa, ooa, xoa
					 */
					if (m != ER && m != OR && m != AND &&
					    special(p, SICON)) {
						putchar('o');
						consflg = 1;
					} else
						putchar('m');
					return;
		
				default:
					cerror("bad insput, operator %o\n", p->op);
					/* NOTREACHED */
			}
			return;
		case 'H':			/* output a sign extend if char */
		case 'E':			/* same, but TPTRTO */
			m = getlr(p, 'L')->type;
			if (c == 'E')
				m = DECREF(m);
		bright:
			if (m == CHAR)
				printf("	esb\n");
			else if (m == UCHAR)
				printf("	ezb\n");
			return;
		case 'Y':			/* same as above, but for right */
			m = getlr(p, 'R')->type;
			goto bright;
		case 'V': 			/* sign extend A, on the left */
			m = getlr(p, 'L')->type;
		Aright:
			if (m == LONG || m == ULONG)
				return;
			if (ISUNSIGNED (m) || ISPTR(m))
				printf("\ttze\n\tlld\t1\n\trla\t1\n");
			else
				printf("	esa\n");
			return;
		case 'W':			/* same, but for right */
			m = getlr(p, 'R')->type;
			goto Aright;
		/*
		 * stack management macros
		 */
		case '-': 			/* push a single word */
			if (toff++)
				printf("\taom\t-1\n\t.lac\tstack\n");
			return;
		case '4':			/* push a double word */
			if (toff == 0) {
				printf("\taom\t-1\n\t.lac\tstack\n");
				toff++;
			} else  {
				printf("\taom\t-2\n\t.lac\tstack\n");
				toff += 2;
			}
			return;
		case '%':		/* table names for shifts */
			switch(p->type) {
				case INT: printf("sw"); break;
				case UNSIGNED: printf("uw"); break;
				case LONG: printf("sd"); break;
				case ULONG: printf("ud"); break;
				default:
					cerror("bad zzzcode for Z%%, type %o", m);
			}
			return;
		case 'X':			/* logical/arithmetic shift? */
			putchar(ISUNSIGNED(p->type) ? 'l' : 'a');
			return;
		default:
			cerror("bad insput, code %c", c);
	}
}
#ifndef genscall
/*
 * Generate code for a call of a function returning a structure
 */
genscall(p, cookie)
	register NODE	*p;
	COOKSZ		cookie;
{
	return(gencall(p, cookie));
}
#endif
/*
 * Generate a call for a normal function call
 */
gencall(p, cookie)
	register NODE	*p;
	COOKSZ		cookie;
{
	register	temp,
			m,
			o,
			r = -1;
	if(p->right)
		temp = argsize(p->right);
	else
		temp = 0;
	if(p->right)		/* generate arguments */
		genargs(p->right);
	/*
	 * Insure that we can address the function to be called
	 */
recheck:
	o = p->left->op;
	if (o != ICON && o != REG && o != OREG && o != NAME) {
		if (o == UNARY MUL) {
			order(p->left->left, INAREG);
			canon(p->left);
			goto recheck;
		}
		order(p->left, INAREG);
	}
	p->op = UNARY CALL;
	m = match(p, INAREG|INDREG|INXREG);
	toff -= temp;
	if(toff <= 0 && temp >= 1)
		temp--, toff++;
	if(temp) {
		if(temp == 1)
			printf("	aum	!stack\n");
		else if(temp >= -127 && temp <= 128)
			printf("\taom\t%d\n\t.lac\tstack\n", temp);
		else {
			if ((p->rall & MUSTDO) && (p->rall & ~MUSTDO) == Rj)
				printf("\ttoi\t%d\n\taim\t!stack\n", temp);
			else
				printf("\ttoj\t%d\n\tajm\t!stack\n", temp);
		}
	}
	return(m != MDONE);
}
/*
 * Generate code for a conditional branch
 */
cbgen(o, lab, mode)
{
	extern short	negrel[];
	if(o == 0)
		printf("	buc	L%d\n", lab);
	else if(o > UGT)
		cerror("bad conditional branch: %s", opst[o]);
	else {
		if(mode == 'F') {
			if (o > GT)
				cerror("bad floating branch %s",
					opst[o]);
			printf(fccbranches[o - EQ], lab);
		} else
			printf(ccbranches[o - EQ], lab);
	}
}
/*
 * If the template matching fails with one cookie, give another to try
 */
COOKSZ
nextcook(p, cookie)
	register NODE	*p;
	COOKSZ		cookie;
{
	if(cookie == FORREW)
		return((COOKSZ)0);
	if(!(cookie & (INAREG|INBREG)))
		return(INAREG|INBREG|INDREG|INXREG);
	if(!(cookie & INTEMP) && asgop(p->op))
		return(INTEMP|INAREG|INDREG|INBREG|INXREG);
	return(FORREW);
}
#ifndef lastchance
/*
 * Last chance to generate code for a subtree, otherwise halt with a
 * no match error.
 */
lastchance(p, cook)
	register NODE	*p;
	COOKSZ		cook;
{
	return(0);
}
#endif
/*
 * Replace hard operators in a tree with function calls,
 *	this is only used for long *, /, and %.
 */
hardops(p)
	register NODE	*p;
{
	register NODE	*q;
	register struct functbl *f;
	register	o = p->op;
	register TWORD	t = p->type;
	if(t != LONG && t != ULONG)
		return;
	for(f = opfunc; f->fop; f++)
		if(o == f->fop && t == f->ftype)
			goto convert;
	return;
convert:
	if(asgop(o)){
		switch(p->left->op){
			case UNARY MUL:
				p->left->op = FREE;
				p->left = p->left->left;
				break;
			case NAME:
				p->left->op = ICON;
				p->left->type = INCREF(p->left->type);
				break;
			case OREG:
				p->left->op = REG;
				p->left->type = INCREF(p->left->type);
				if(p->left->lval != 0) {
					q = talloc();
					q->op = PLUS;
					q->rall = NOPREF;
					q->type = p->left->type;
					q->left = p->left;
					q->right = talloc();
					q->right->op = ICON;
					q->right->rall = NOPREF;
					q->right->type = INT;
					q->right->name[0] = '\0';
					q->right->lval = p->left->lval;
					q->right->rval = 0;
					p->left->lval = 0;
					p->left = q;
				}
				break;
			default:
				cerror("bad address for hard ops");
		}
	}
	q = talloc();
	q->op = CM;
	q->rall = NOPREF;
	q->type = INT;
	q->left = p->left;
	q->right = p->right;
	p->op = CALL;
	p->right = q;
	p->left = q = talloc();
	q->op = ICON;
	q->rall = NOPREF;
	q->type = INCREF(FTN + p->type);
	strcpy(q->name, f->func);
	q->lval = 0;
	q->rval = 0;
	return;
}
/*
 * Launder the trees read in from the first pass
 */
myreader(p)
	register NODE	*p;
{
	walkf(p, hardops);
	canon(p);
	toff = 0;
}
/*
 * Boolean, does node p have the special shape shape ?
 */
/*
 * For cross-compiling we can't switch on a long, so ...
 */
#if pdp11
special(p, shape)
	register NODE	*p;
	SHAPESZ		shape;
{
	if (p->op == ICON && p->name[0] == '\0') {
		if (shape == SCCON)
			return (p->lval >= -128 && p->lval <= 127);
		if (shape == SICON)
			return (p->lval >= 0 && p->lval <= 32767);
		if (shape == SNCON)
			return(p->lval < 0 && p->lval >= -32767);
		if (shape == SONE)
			return(p->lval == 1);
		if (shape == SMONE)
			return(p->lval == -1);
		cerror("bad special shape %lo", (long)shape);
	}
	return(0);
}
#else
special(p, shape)
	register NODE	*p;
	SHAPESZ		shape;
{
	if (p->op == ICON && p->name[0] == '\0')
		switch(shape)
		{
			case SCCON:
				return(p->lval >= -128 && p->lval <= 127);
			case SICON:
				return(p->lval >= 0 && p->lval <= 32767);
			case SNCON:
				return(p->lval < 0 && p->lval > -32767);
			case SONE:
				return(p->lval == 1);
			case SMONE:
				return(p->lval == -1);
			default:
				cerror("bad special shape %o\n", shape);
		}
	return(0);
}
#endif
# ifndef ONEPASS
main(argc, argv)
int argc;
char **argv;
{
	return(mainp2(argc, argv));
}
where(c)
char c;
{
	extern char	filename[];
	fprintf(stderr, "%s, line %d: ", filename, lineno);
}
dexit(v)
int v;
{
	exit(v);
}
#endif
/*
 * Fix up PACONV for register r
 */
paconv(p, r)
	register NODE	*p;
	register	r;
{
	CONSZ		words,
			save;
	register	bytes;
	if (p->right->lval < 0 || p->right->name[0] != '\0')
		cerror("unexpected constant to paconv");
	bytes = p->right->lval%3 + 1;
	save = p->right->lval;
	words = (p->right->lval /= 3);
	if (words) {
		printf("	ao%s	", rnames[r]);
		acon(p->right);
		putchar('\n');
	}
	while (bytes-- > 0)
		printf("\tbb%s\t.+1\n", rnames[r]);
	p->right->lval = save;
}
/*
 * Fix up PSCONV for register r
 */
psconv(p, r)
	register NODE	*p;
	register	r;
{
	CONSZ		words,
			save;
	register	bytes;
	if (p->right->lval <= 0 || p->right->name[0] != '\0')
		cerror("unexpected constant for psconv");
	bytes = 3 - (p->right->lval-1)%3;
	words = (p->right->lval-1)/3+1;
	save = p->right->lval;
	p->right->lval = words;
	if (words) {
		printf("	so%s	", rnames[r]);
		acon(p->right);
		putchar('\n');
	}
	while (bytes-- > 0)
		printf("\tbb%s\t.+1\n", rnames[r]);
	p->right->lval = save;
}
/*
 * Fix up bpoint + constant
 *	bpoint is in register r
 */
bpadd(p, r)
	register NODE	*p;
	register	r;
{
	CONSZ		words;
	register	bytes;
	if (p->right->lval < 0 || p->right->name[0] != '\0')
		cerror("unexpected constant to bpadd");
	bytes = p->right->lval % 3;
	words = p->right->lval/3;
	if (words)
		printf("	ao%s	%ld\n", rnames[r], words);
	while (bytes-- > 0)
		printf("	bb%s	.+1\n", rnames[r]);
}
/*
 * Fix up bpoint - constant
 *	bpoint is in register r
 */
bpsub(p, r)
	register NODE	*p;
	register	r;
{
	CONSZ		words;
	register	bytes;
	if (p->right->lval <= 0 || p->right->name[0] != '\0')
		cerror("unexpected constant to bpsub");
	bytes = 2 - (p->right->lval-1)%3;
	words = (p->right->lval-1)/3+1;
	while(bytes-- > 0)
		printf("	bb%s	.+1\n", rnames[r]);
	if (words)
		printf("	so%s	%ld\n", rnames[r], words);
}
/*
 * Handle generating code for STASG nodes
 */
stasg(p, l, r)
NODE		*p;
register NODE	*l,
		*r;
{
	register int	size = p->stsize / NCHPERINT;
	register char	*reg;
	int		ricon = (r->op == ICON),
			licon = (l->op == ICON);
	int		r1;

	if (size <= BIGSIZE) {		/* use a series of moves */
		register int	count = size;
		reg = "d";
		while (count > 1) {
		cheat:
			printf("	tm%s	!", reg);
			if (ricon) {
				conput(r);
				printf("+%d\n", count-2);
			} else
				printf("%d,%s\n", count-2, rnames[r->rval]);
			printf("	t%sm	!", reg);
			if (licon) {
				conput(l);
				printf("+%d\n", count-2);
			} else
				printf("%d,%s\n", count-2, rnames[l->rval]);
			count -= 2;
		}
		if (count == 1) {
			count = 2;
			reg = "a";
			goto cheat;
		}
	} else {		/* build a loop */
		register char	*indexreg;
		/*
		 * Do it in doubles
		 */
		if (!ricon && !licon) {	/* steal the K register */
			indexreg = rnames[Rk];
			printf("	tkv\n");
		} else
			indexreg = rnames[getlr(p, '1')->rval];
		printf("	tn%s	%d\n", indexreg, size & ~01);
		printf("9:	tmd	!");
		if (ricon) {
			conput(r);
			printf("+%d,%s\n", size & ~01, indexreg);
		} else
			printf("0,%s\n", rnames[r->rval]);
		printf("	tdm	!");
		if (licon) {
			conput(l);
			printf("+%d,%s\n", size & ~01, indexreg);
		} else
			printf("0,%s\n", rnames[l->rval]);
		if (!ricon)
			printf("	ao%s	2\n", rnames[r->rval]);
		if (!licon)
			printf("	ao%s	2\n", rnames[l->rval]);
		printf("	ao%s	1\n", indexreg);
		printf("	bw%s	9b\n", indexreg);
		/*
		 * Cleanup an extra word
		 */
		if (size & 01) {
			printf("	tma	!");
			if (ricon) {
				conput(r);
				printf("+%d\n", size-1);
			} else
				printf("0,%s\n", rnames[r->rval]);
			printf("	tam	!");
			if (licon) {
				conput(l);
				printf("+%d\n", size-1);
			} else
				printf("0,%s\n", rnames[l->rval]);
		}
		if (*indexreg == 'k')
			printf("	tvk\n");
	}
}
/*
 * Build code for STARG's
 */
starg(p, l)
	NODE		*p;
	register NODE	*l;
{
	register int	size = p->stsize / NCHPERINT;
	register char	*reg;
	register int	icon = (l->op == ICON);

	if (size <= BIGSIZE) {		/* use a series of moves */
		register int	count = size;
		reg = "d";
		while (count > 1) {
		cheat:
			printf("	tm%s	!", reg);
			if (icon) {
				conput(l);
				printf("+%d\n", count-2);
			} else
				printf("%d,%s\n", count-2, rnames[l->rval]);
			/*
			 * Now push it on the stack
			 */
			insput(p, *reg == 'a' ? '-' : '4');
			printf("	t%sm	*!stack\n", reg);
			count -= 2;
		}
		if (count == 1) {
			count = 2;
			reg = "a";
			goto cheat;
		}
	} else {		/* build a loop */
		register char	*indexreg = rnames[getlr(p, '1')->rval];

		/*
		 * Fix up single word transfers first, so we can keep
		 * the stack clean - i.e. when we use the empty stack
		 * location the insput call will not decrement the stack
		 */
		if (size & 01) {
			printf("	tma	!");
			if (icon) {
				l->lval += size-1;
				conput(l);
				l->lval -= size-1;
				putchar('\n');
			} else
				printf("%d,%s\n", size-1, rnames[l->rval]);
			insput(p, '-');
			printf("	tam	*!stack\n");
		}
		/*
		 * Check for the case where we have an even sized structure
		 * and haven't pushed anything onto the stack yet...
		 * in this case we must push a double word special
		 */
		if (!(size & 01) && toff == 0) {
			printf("	tmd	!");
			if (icon) {
				l->lval += size-2;
				conput(l);
				l->lval -= size-2;
				putchar('\n');
			} else
				printf("%d,%s\n", size-2, rnames[l->lval]);
			insput(p, '4');
			printf("	tdm	*!stack\n");
			size -= 2;
		}
		printf("	to%s	%d\n", indexreg, (size & ~01)-2);
		if (!icon)
			printf("	ao%s	%d\n", rnames[l->rval],
				(size & ~01)-2);
		printf("9:	tmd	!");
		if (icon) {
			conput(l);
			printf(",%s\n", indexreg);
		} else
			printf("0,%s\n", rnames[l->rval]);
		printf("\taom\t-2\n\t.lac\tstack\n");
		printf("	tdm	*!stack\n");
		if (!icon)
			printf("	so%s	2\n", rnames[l->rval]);
		printf("	so%s	2\n", indexreg);
		printf("	bnn	9b\n");
		/*
		 * Adjust toff so we'll pop the stack frame correctly
		 */
		toff += (size & ~01);
	}
}
