/*
 * taskinfo_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `taskinfo.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include "db.h"
#include "xplan.h"

void	deliverable_notify(Panel_item, int, Event *);
void	milestone_notify(Panel_item, int, Event *);

extern int selected, last_selected;
extern struct task_node *current_task;

/*
 * Notify callback function for `dependenciesButton'.
 */
void
taskinfo_taskinfoPopup_dependenciesButton_notify_callback(Panel_item item, Event *event)
{
	taskinfo_taskinfoPopup_objects *ip = (taskinfo_taskinfoPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Dependencies_dependenciesPopup->dependenciesPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Dependencies_dependenciesPopup->dependenciesPopup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `resourcesButton'.
 */
void
taskinfo_taskinfoPopup_resourcesButton_notify_callback(Panel_item item, Event *event)
{
	taskinfo_taskinfoPopup_objects *ip = (taskinfo_taskinfoPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Resources_resourcesPopup->resourcesPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Resources_resourcesPopup->resourcesPopup, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `applyButton'.
 */
void
taskinfo_taskinfoPopup_applyButton_notify_callback(Panel_item item, Event *event)
{
   char *name;
   Xv_notice notice;

   taskinfo_taskinfoPopup_objects *ip = (taskinfo_taskinfoPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);

   /* Get the task name from the popup window */
   name = (char *) xv_get(Taskinfo_taskinfoPopup->name,
			  PANEL_VALUE);

   if ((strcmp(name, "New Task")==0) ||
       (find_task(get_main_task_list(), name) &&
	(strcmp(name, current_task->data->name)!=0))) {
      notice = xv_create(Taskinfo_taskinfoPopup->taskinfoPopup, NOTICE,
			 NOTICE_MESSAGE_STRINGS, 
			 "That task name is already in use.", NULL,
			 NOTICE_BUTTON_YES, "Continue",
			 XV_SHOW, TRUE,
			 NULL);
      xv_destroy_safe(notice);
      return;
   }
   
   store_data_from_taskinfoPopup(current_task);
   if (selected != -1)
     xv_set(Main_mainWindow->taskList, PANEL_LIST_STRING, selected,
	    current_task->data->name,
	    NULL);
   else 
     xv_set(Main_mainWindow->taskList, PANEL_LIST_STRING, last_selected,
	    current_task->data->name,
	    NULL);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Notify callback function for `resetButton'.
 */
void
taskinfo_taskinfoPopup_resetButton_notify_callback(Panel_item item, Event *event)
{
	taskinfo_taskinfoPopup_objects *ip = (taskinfo_taskinfoPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	load_data_to_taskinfoPopup(current_task);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Done callback function for `taskinfoPopup'.
 */
void
taskinfo_taskinfoPopup_done_callback(Frame frame)
{
   int first;

   xv_set(frame, XV_SHOW, FALSE, NULL);

   first = (int) xv_get(Main_mainWindow->taskList,
			PANEL_LIST_FIRST_SELECTED);
   if (first != -1) 
     xv_set(Main_mainWindow->taskList, PANEL_LIST_SELECT,
		  first, FALSE, NULL);
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}
