/* FILE dependencies_stubs.c ****************************************
 *
 * xplan - project planning tool
 * Copyright (C) 1992 Brian Gaubert, Mark M. Lacey, Richard Malingkas,
 * and Mike Marlow.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License (distributed with this program in the file
 * COPYING) for more details.
 * 
 * If you did not received a copy of the GNU General Public License
 * along with this program, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * Since this was a project for a one semester software engineering
 * course, the authors will not be offering support for the product
 * after its release.
 *
 * DESCRIPTION OF CONTENTS
 *
 * dependencies_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `dependencies.G'.
 *
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>
#include "db.h"
#include "xplan.h"

void		list_Menu_callback(Panel_item, Event *);

/* variables to control the list */
extern struct task_node *current_task;
int selected_dep=-1, last_selected_dep=-1;
struct task_node *current_dep=NULL;

/* FUNCTION dependency_insert_before ****************************************

   PURPOSE

   Menu handler for `insertMenu (Before)'.

   INPUTS

   item, op --- see XView programming manual

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 7 Dec 1992
   Tester.... Mark M. Lacey, 7 Dec 1992
*/
Menu_item
dependency_insert_before(Menu_item item, Menu_generate op)
{
   char *task_name;
   struct task_node *node, *new_node1, *new_node2;
   struct task_info *info;

   Xv_notice       notice;

   dependencies_dependenciesPopup_objects * ip = (dependencies_dependenciesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* if nothing is selected in the list, pop up a notice */
		/* that says they have to select something to add */
		/* before */
		if (selected_dep == -1) {
		   notice = xv_create(ip->dependenciesPopup, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "You must first select a dependency to add before", 
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		}

		/* get the name of the dependency they have entered */
		task_name = (char *) xv_get(ip->dependencyField,
					    PANEL_VALUE);

		/* try to find it in our list -- if not found pop up */
		/* message and return */
		node = find_task(get_main_task_list(), task_name);
		if (!node) {
		   notice = xv_create(ip->dependenciesPopup, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "That task does not currently exist",
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* create a new task node for this dependency */
		new_node1 = create_task_node(node->data, NULL, NULL);
		/* add this before the currently selected task in the */
		/* dependency list */
		add_task_before(current_task->data->dependencies, 
				current_dep, new_node1);

		/* create a node for the dependents list of the the */
		/* node that we added as a dependency */
		new_node2 = create_task_node(current_task->data, NULL,
					    NULL);
		/* add this new node to the end of the dependents list */
		add_task_to_end(node->data->dependents, new_node2);

		/* insert the string in the proper place int the list */
		/* and select it */
		xv_set(ip->dependencyList, PANEL_LIST_INSERT, selected_dep,
		       PANEL_LIST_STRING, selected_dep,
		       new_node1->data->name,
		       PANEL_LIST_SELECT, selected_dep, TRUE, NULL);

		/* make this the current dependency selected */
		current_dep = new_node1;

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/* FUNCTION dependency_insert_after ****************************************

   PURPOSE

   Menu handler for `insertMenu (After)'.

   INPUTS

   item, op --- see XView programming manual

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 7 Dec 1992
   Tester.... Mark M. Lacey, 7 Dec 1992
*/
Menu_item
dependency_insert_after(Menu_item item, Menu_generate op)
{
   char *task_name;
   struct task_node *node, *new_node1, *new_node2;
   struct task_info *info;

   Xv_notice       notice;

   dependencies_dependenciesPopup_objects * ip = (dependencies_dependenciesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* if nothing is selected in the list, pop up a notice */
		/* that says they have to select something to add */
		/* after */
		if (selected_dep == -1) {
		   notice = xv_create(ip->dependenciesPopup, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "You must first select a dependency to add after", 
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		}

		/* get the name of the dependency they have entered */
		task_name = (char *) xv_get(ip->dependencyField,
					    PANEL_VALUE);

		/* try to find it in our list -- if not found pop up */
		/* message and return */
		node = find_task(get_main_task_list(), task_name);
		if (!node) {
		   notice = xv_create(ip->dependenciesPopup, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "That task does not currently exist",
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* create a new task node for this dependency */
		new_node1 = create_task_node(node->data, NULL, NULL);
		/* add this after the currently selected task in the */
		/* dependency list */
		add_task_after(current_task->data->dependencies, 
				current_dep, new_node1);

		/* create a node for the dependents list of the the */
		/* node that we added as a dependency */
		new_node2 = create_task_node(current_task->data, NULL,
					    NULL);
		/* add this new node to the end of the dependents list */
		add_task_to_end(node->data->dependents, new_node2);

		/* increment counter for currently selected item */
		selected_dep = selected_dep + 1;

		/* insert string and select it */
		xv_set(ip->dependencyList, PANEL_LIST_INSERT, selected_dep,
		       PANEL_LIST_STRING, selected_dep,
		       new_node1->data->name,
		       PANEL_LIST_SELECT, selected_dep, TRUE, NULL);

		/* make this new dependency the current one */
		current_dep = new_node1;

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/* FUNCTION dependency_insert_top ****************************************

   PURPOSE

   Menu handler for `insertMenu (Top)'.

   INPUTS

   item, op --- see XView programming manual

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 7 Dec 1992
   Tester.... Mark M. Lacey, 7 Dec 1992
*/
Menu_item
dependency_insert_top(Menu_item item, Menu_generate op)
{
   char *task_name;
   struct task_node *node, *new_node1, *new_node2;
   struct task_info *info;

   Xv_notice       notice;

   dependencies_dependenciesPopup_objects * ip = (dependencies_dependenciesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* get the name of the dependency they have entered */
		task_name = (char *) xv_get(ip->dependencyField,
					    PANEL_VALUE);

		/* try to find it in our list -- if not found pop up */
		/* message and return */
		node = find_task(get_main_task_list(), task_name);
		if (!node) {
		   notice = xv_create(ip->dependenciesPopup, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "That task does not currently exist",
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* create a new task node for this dependency */
		new_node1 = create_task_node(node->data, NULL, NULL);
		/* add this after the currently selected task in the */
		/* dependency list */
		add_task_to_beginning(current_task->data->dependencies, 
				      new_node1);

		/* create a node for the dependents list of the the */
		/* node that we added as a dependency */
		new_node2 = create_task_node(current_task->data, NULL, NULL);
		/* add this new node to the end of the dependents list */
		add_task_to_end(node->data->dependents, new_node2);

		/* make the currently selected item in the list the */
		/* top one */
		selected_dep = 0;

		/* insert string and select it */
		xv_set(ip->dependencyList, PANEL_LIST_INSERT, selected_dep,
		       PANEL_LIST_STRING, selected_dep,
		       new_node1->data->name,
		       PANEL_LIST_SELECT, selected_dep, TRUE, NULL);

		/* save this as the current dependency */
		current_dep = new_node1;

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/* FUNCTION dependency_insert_bottom ****************************************

   PURPOSE

   Menu handler for `insertMenu (Bottom)'.

   INPUTS

   item, op --- see XView programming manual

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 7 Dec 1992
   Tester.... Mark M. Lacey, 7 Dec 1992
*/
Menu_item
dependency_insert_bottom(Menu_item item, Menu_generate op)
{
   char *task_name;
   struct task_node *node, *new_node1, *new_node2;
   struct task_info *info;
   int nrows;
   Xv_notice       notice;

   dependencies_dependenciesPopup_objects * ip = (dependencies_dependenciesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* get the name of the dependency they have entered */
		task_name = (char *) xv_get(ip->dependencyField,
					    PANEL_VALUE);

		/* try to find it in our list -- if not found pop up */
		/* message and return */
		node = find_task(get_main_task_list(), task_name);
		if (!node) {
		   notice = xv_create(ip->dependenciesPopup, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "That task does not currently exist",
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* create a new task node for this dependency */
		new_node1 = create_task_node(node->data, NULL, NULL);
		/* add this after the currently selected task in the */
		/* dependency list */
		add_task_to_end(current_task->data->dependencies, 
				new_node1);

		/* create a node for the dependents list of the the */
		/* node that we added as a dependency */
		new_node2 = create_task_node(current_task->data, NULL, NULL);
		/* add this new node to the end of the dependents list */
		add_task_to_end(node->data->dependents, new_node2);

		/* find out how many rows there are */
		nrows = (unsigned) xv_get(ip->dependencyList,
					  PANEL_LIST_NROWS,
					  NULL);

		/* store this as the currently selected item */
		selected_dep = nrows;

		/* insert the new string and select it */
		xv_set(ip->dependencyList, PANEL_LIST_INSERT, selected_dep,
		       PANEL_LIST_STRING, selected_dep,
		       new_node1->data->name,
		       PANEL_LIST_SELECT, selected_dep, TRUE, NULL);

		/* make this the new current dependency */
		current_dep = new_node1;

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/* FUNCTION dependency_delete ****************************************

   PURPOSE

   Notify callback function for `deleteButton'.

   INPUTS

   item, event --- see XView programming manual

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 7 Dec 1992
   Tester.... Mark M. Lacey, 7 Dec 1992
*/
void
dependency_delete(Panel_item item, Event *event)
{
   Xv_notice notice;
   int nrows;

	dependencies_dependenciesPopup_objects *ip = (dependencies_dependenciesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
   /* if there isn't a dependency selected, show a message a return */
   if (selected_dep == -1) {
	   notice = xv_create(ip->dependenciesPopup, NOTICE,
			      NOTICE_MESSAGE_STRINGS, 
			      "You must first select a dependency to delete",
			      NULL,
			      NOTICE_BUTTON_YES, "Continue",
			      XV_SHOW, TRUE,
			      NULL);
	   xv_destroy_safe(notice);
	   return;
	}

   /* otherwise remove this from the dependents list of the currently */
   /* selected dependency, and then the dependency list we are working */
   /* on now */
   remove_task_node(current_dep->data->dependents,
		    find_task(current_dep->data->dependents,
			      current_task->data->name));
   remove_task_node(current_task->data->dependencies, current_dep);
   
   /* find out which is the current item in the list */
   current_dep = list_current(current_task->data->dependencies);

   /* delete it from the GUI's list */
   xv_set(ip->dependencyList, PANEL_LIST_DELETE, selected_dep, NULL);

   /* find out how many rows there are */
   nrows = (unsigned) xv_get(ip->dependencyList, PANEL_LIST_NROWS,
			     NULL);

   /* if the selected one is the last one in the list, decrement the */
   /* number of the selected item */
   if (selected_dep == nrows) selected_dep = selected_dep -1;

   /* highlite our new current item */
   xv_set(ip->dependencyList, PANEL_LIST_SELECT, selected_dep, TRUE,
	  NULL);
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/* FUNCTION dependency_list_notify **************************************

   PURPOSE

   Notify callback function for `deleteButton'.

   INPUTS

   See XView programming manual

   AUTHOR/AUDITOR/TESTER
   
   Author.... Mark M. Lacey, 7 Dec 1992
   Tester.... Mark M. Lacey, 7 Dec 1992
*/
/*
 * Notify callback function for `dependencyList'.
 */
int
dependency_list_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	dependencies_dependenciesPopup_objects *ip = (dependencies_dependenciesPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
	   /* -1 is what we use to signify that nothing is selected */
	   selected_dep = -1;
		break;

	case PANEL_LIST_OP_SELECT:
	   /* set up the pointer to the currently selected item and */
	   /* also the row */
	   current_dep = find_task(current_task->data->dependencies,
				   string);
	   selected_dep = row;

		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

Panel_setting
dependency_enter_callback(Panel_item item, Event *event)
{
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */
}
