/*
 * rasview_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `rasview.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <gdd.h>
#include "rasview_ui.h"

/*
 * Create object `file_menu' in the specified instance.
 */
Xv_opaque
rasview_file_menu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	rasview_load_handler();
	extern Menu_item	rasview_close_handler();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Load...",
			MENU_GEN_PROC, rasview_load_handler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear",
			MENU_GEN_PROC, rasview_close_handler,
			NULL,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `win'.
 */
rasview_win_objects *
rasview_win_objects_initialize(ip, owner)
	rasview_win_objects	*ip;
	Xv_opaque	owner;
{
	if (!ip && !(ip = (rasview_win_objects *) calloc(1, sizeof (rasview_win_objects))))
		return (rasview_win_objects *) NULL;
	if (!ip->win)
		ip->win = rasview_win_win_create(ip, owner);
	if (!ip->controls)
		ip->controls = rasview_win_controls_create(ip, ip->win);
	if (!ip->file_button)
		ip->file_button = rasview_win_file_button_create(ip, ip->controls);
	if (!ip->drop_target1)
		ip->drop_target1 = rasview_win_drop_target1_create(ip, ip->controls);
	if (!ip->canvas)
		ip->canvas = rasview_win_canvas_create(ip, ip->win);
	return ip;
}

/*
 * Create object `win' in the specified instance.
 */
Xv_opaque
rasview_win_win_create(ip, owner)
	rasview_win_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 581,
		XV_HEIGHT, 594,
		XV_LABEL, "RasView",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `controls' in the specified instance.
 */
Xv_opaque
rasview_win_controls_create(ip, owner)
	rasview_win_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 40,
		WIN_BORDER, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `file_button' in the specified instance.
 */
Xv_opaque
rasview_win_file_button_create(ip, owner)
	rasview_win_objects	*ip;
	Xv_opaque	owner;
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 15,
		XV_Y, 10,
		PANEL_LABEL_STRING, "File",
		PANEL_ITEM_MENU, rasview_file_menu_create((caddr_t) ip, ip->win),
		NULL);
	return obj;
}

/*
 * Create object `drop_target1' in the specified instance.
 */
Xv_opaque
rasview_win_drop_target1_create(ip, owner)
	rasview_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void	canvas_drop_function();
	extern void	rasview_drag_function();
	Xv_opaque	obj;
	Drag_drop	dnd;
	Selection_item	sel_item;
	Cursor		dnd_cursor;
	Cursor		dnd_accept_cursor;
	Xv_opaque	drop_target1_accept_cursor_image;
#include "drop_cursor.xbm"
	Xv_opaque	drop_target1_cursor_image;
#include "drag_cursor.xbm"
	
	drop_target1_accept_cursor_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, drop_cursor_bits,
		XV_WIDTH, drop_cursor_width,
		XV_HEIGHT, drop_cursor_height,
		NULL);
	drop_target1_cursor_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_X_BITS, drag_cursor_bits,
		XV_WIDTH, drag_cursor_width,
		XV_HEIGHT, drag_cursor_height,
		NULL);
	obj = xv_create(owner, PANEL_DROP_TARGET,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 540,
		XV_Y, 10,
		NULL);
	
	dnd_cursor = xv_create(XV_NULL, CURSOR,
		CURSOR_IMAGE, drop_target1_cursor_image,
		CURSOR_OP, PIX_SRC^PIX_DST,
		CURSOR_XHOT, 17,
		CURSOR_YHOT, 24,
		NULL);
		
	dnd_accept_cursor = xv_create(XV_NULL, CURSOR,
		CURSOR_IMAGE, drop_target1_accept_cursor_image,
		CURSOR_OP, PIX_SRC^PIX_DST,
		CURSOR_XHOT, 17,
		CURSOR_YHOT, 24,
		NULL);
		
	dnd = xv_create(owner, DRAGDROP,
		DND_CURSOR, dnd_cursor,
		DND_ACCEPT_CURSOR, dnd_accept_cursor,
		NULL);
		
	sel_item = xv_create(dnd, SELECTION_ITEM, NULL);
	
	xv_set(obj,
		PANEL_NOTIFY_PROC, gdd_drop_target_notify_proc,
		PANEL_DROP_DND, dnd,
		XV_KEY_DATA, SELECTION_ITEM, sel_item,
		NULL);
		
	gdd_register_drop_target(obj, canvas_drop_function, rasview_drag_function);
	return obj;
}

/*
 * Create object `canvas' in the specified instance.
 */
Xv_opaque
rasview_win_canvas_create(ip, owner)
	rasview_win_objects	*ip;
	Xv_opaque	owner;
{
	extern void	rasview_canvas_repaint();
	extern void	canvas_drop_function();
	Xv_opaque	obj;
	Xv_drop_site	drop_site;
	Rect		rectlist[2];
	
	obj = xv_create(owner, CANVAS,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->controls, XV_Y) +
		      (int)xv_get(ip->controls, XV_HEIGHT),
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		CANVAS_REPAINT_PROC, rasview_canvas_repaint,
		NULL);
	xv_create(obj, SCROLLBAR, SCROLLBAR_DIRECTION, SCROLLBAR_HORIZONTAL, NULL);
	xv_create(obj, SCROLLBAR, SCROLLBAR_DIRECTION, SCROLLBAR_VERTICAL, NULL);
	notify_interpose_event_func(canvas_paint_window(obj),
		(Notify_func) gdd_load_event_proc, NOTIFY_SAFE);
	/*
	 * This line is here for backwards compatibility. It will be
	 * removed for the next release.
	 */
	xv_set(canvas_paint_window(obj), XV_KEY_DATA, INSTANCE, ip, NULL);
	
	drop_site = xv_create(canvas_paint_window(obj), DROP_SITE_ITEM,
		DROP_SITE_ID, 1,
		DROP_SITE_EVENT_MASK, DND_ENTERLEAVE | DND_MOTION,
		NULL);
		
	xv_set(canvas_paint_window(obj),
		XV_KEY_DATA, DROP_SITE_ITEM, drop_site,
		NULL);
	
	rectlist[0] = *(Rect *) xv_get(obj, XV_RECT);
	rectlist[0].r_left = 0;
	rectlist[0].r_top = 0;
	rectlist[1].r_width = 0;
	rectlist[1].r_height = 0;
	gdd_register_drop_site(drop_site, canvas_drop_function);
	gdd_activate_drop_site(drop_site, rectlist);
	return obj;
}

