//
// olwais_stubs.cc - Notify and event callback function stubs.
// This file was generated by `gxv++' from `olwais.G'.
//
/*
  $Header:$
  $Log:$
*/
#include <stdio.h>

#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>
#include <gfm.h>
#include <time.h>
#include <unistd.h>
#include "olwais_ui.h"
#include "directory.h"
#include "profile.h"
/* External variables for wais */
extern "C" {
#include "wais.h"
#include "wais-ui.h"
#include "xpm.h"
#include "foo.icon"
int Sources;
void  PrintStatus(long a ,long b , char* c, ...) {
  /*ARGSUSED*/
}
int log_file_name;
int NumSources;
int command_name;
}
Question q ;
dispatch* show;
#include "olutils.h"

/* Interface objects from devguide*/

olwais_Alert_objects	Olwais_Alert;
olwais_olw_objects	Olwais_olw;
olwais_ResultsPopup_objects	Olwais_ResultsPopup;
olwais_SourceSelectPopup_objects	Olwais_SourceSelectPopup;

// objects to manage interface in C++ 
ol_list source_list;
ol_list chosen_list;
ol_list relevant_list;
ol_list results;
ol_button add_button;
ol_text   keyword_text;
ol_frame search_frame;
ol_frame source_frame;
ol_frame results_frame;

ol_menu results_menu("Results");
ol_menu relevant_menu("Relevant");
#define DCLICK 500000

void	AddRelevantDoc(Xv_opaque, Event *, GDD_DROP_INFO *);
void	DeSelectChosen(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
void	DeSelectSources(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
void	set_sources(Panel_item, Event *);
void 	construct_source_list();
void	PrepareSources(void);

Menu_item make_relevant(Menu it, Menu_item ot) {
  printf("time to make relevant\n");
  Xv_opaque glyph; DocumentID data;
  ol_list results_list(Olwais_ResultsPopup.ResultsList);
  char* headline;
  int n = results_list.get_first();
  if (n >= 0 ) {
    headline = results_list.get_item(n, (void**)&data,&glyph);
    printf("%s is %s!!!\n", headline,data->doc->headline);
    relevant_list.append(headline,data,glyph);
  }
  return 0;
}

Menu_item make_irrelevant(Menu it, Menu_item ot) {
  printf("deleting irrelevant item %d\n",relevant_list.get_first());
  relevant_list.delete_selected();
  return 0;

}
void display_alert(char* message) {
  xv_create(Olwais_olw.olw,NOTICE,
	    NOTICE_MESSAGE_STRING,message,
	    NOTICE_BUTTON,"Ok",1,
	    NOTICE_LOCK_SCREEN,TRUE,
	    XV_SHOW,TRUE,
	    NULL);
}


 
int 	doDoc(Panel_item item,  char* name, Xv_opaque client_data,
	      Panel_list_op the_op, Event* the_event, int row) ;


int load_question_callback(gfm_popup_objects* ip, char* dir,char* file) {
  Question q = new _Question;
  char buf[1024];
  sprintf(buf,"%s/%s",dir,file);
  FILE* f = fopen(buf,"r");
  if(f != 0) {
    ReadQuestion(q,f);
    keyword_text.set_text(strdup(q->keywords));
    SourceList x = q->Sources;
    chosen_list.delete_all();
    while(x) {
      chosen_list.append(strdup(x->thisSource->filename));
      x = x->nextSource;
    }
//    WriteQuestionfp(stdout,q);
    delete q;
  } 
  return GFM_OK;
}

//
// Global object definitions.
//




#ifdef MAIN

Attr_attribute	INSTANCE;
char* home;
main(int argc, char **argv)
{

  home = getenv("HOME");
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
  INSTANCE = xv_unique_key();
  
  Olwais_olw.objects_initialize(NULL);
  Olwais_ResultsPopup.objects_initialize(Olwais_olw.olw);
  Olwais_SourceSelectPopup.objects_initialize(Olwais_olw.olw);
  Olwais_Alert.objects_initialize(Olwais_olw.olw);
  
  search_frame= ol_frame(Olwais_olw.olw);
  source_frame = ol_frame(Olwais_SourceSelectPopup.SourceSelectPopup);
  results_frame=ol_frame(Olwais_ResultsPopup.ResultsPopup);
  
  source_list = ol_list(Olwais_SourceSelectPopup.SourcesList);
  source_list.set_unique(FALSE);
  chosen_list = ol_list(Olwais_SourceSelectPopup.ChosenSourcesList);
  chosen_list.set_unique(FALSE);
  relevant_list = ol_list(Olwais_olw.RelevanceFeedbackList);
  relevant_list.set_unique(FALSE);

  add_button = ol_button(Olwais_SourceSelectPopup.AddSources);
  keyword_text = ol_text(Olwais_olw.KeywordsText);
  char fname[1024];
  sprintf(fname,"%s/.olwrc",home);
  show = load_dispatches(fname);

  results = ol_list(Olwais_ResultsPopup.ResultsList);
  results.set_menu(Xv_opaque(results_menu));
  results_menu.add_item("Make relevant",make_relevant);

  relevant_list.set_menu(Xv_opaque(relevant_menu));
  relevant_menu.add_item("Remove item",make_irrelevant);


  Xv_Screen scr = (Xv_Screen)xv_get(search_frame,XV_SCREEN);
  Display* disp= (Display *)xv_get(search_frame, XV_DISPLAY);
  int num_scr = (int)xv_get(scr,SCREEN_NUMBER);
  Pixmap the_icon,the_shape;
  XpmCreatePixmapFromData(disp, RootWindow(disp,num_scr),
			  foo_icon, &the_icon,&the_shape,
			  NULL);
  Server_image boo = xv_create(NULL,SERVER_IMAGE,
			       XV_WIDTH,64,
			       XV_HEIGHT,100,
			       SERVER_IMAGE_PIXMAP,the_icon,
			       NULL);
  search_frame.set_icon(boo);
	
	//
	// Initialize the Drag Drop package.
	//
	gdd_init_dragdrop(Olwais_olw.olw);
	
	//
	// Turn control over to XView.
	//
	xv_main_loop(Olwais_olw.olw);
}

#endif


//
// Menu handler for `FileMenu (Load Question.....)'.
//
Menu_item
olwais_FileMenu_item0_callback(Menu_item item, Menu_generate op)
{
  olwais_olw_objects * ip = (olwais_olw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  switch (op) {
  case MENU_DISPLAY:
    break;
    
  case MENU_DISPLAY_DONE:
    break;
    
  case MENU_NOTIFY:
    
// gxv_start_connections DO NOT EDIT THIS SECTION
    
    {
      {
	char buf[1024];
	
	sprintf(buf,"%s/wais-questions/",home);

	gfm_popup_objects* open_dialog = 
	  gfm_initialize(NULL,NULL,"Load Question");
	gfm_activate(open_dialog,
		     buf, // directory
		     NULL, // ed pattern
		     NULL, // filter
		     load_question_callback, // callback
		     NULL, // glyph
		     GFM_LOAD);
      }
    }
    
    // gxv_end_connections
    
    break;
    
  case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

void olwais_olw_HelpButton_notify_callback(Panel_item i, Event* foo) {
  if(fork()) {
    FILE *out,*in;
    in = fopen("help.au","r");
    out = fopen("/dev/audio","w");
    int c;
    if(in && out) {
      while((c = getc(in)) != EOF) {
	putc(c,out);
      }
      fclose(in); fclose(out);
    }
    exit(1);
  }
}
//
// Notify callback function for `SearchButton'.
//
int save_question_callback(gfm_popup_objects* ip, char* dir,char* file) {
  Question q = new _Question;
  char path[1024];
  sprintf(path,"%s/wais-sources/:",home);
  q->sourcepath = path;
  q->maxresdocs = 40;
  strcpy(q->name,"hello world");
  strcpy(q->keywords,keyword_text.get_text());
  int n;
  for(n=0;n <chosen_list.num_rows();n++) {
    SourceID sid;
    void* client_data;
    Xv_opaque glyph;
    sid = new _SourceID;
    char* foo = (chosen_list.get_item(n,&client_data,&glyph));
    sid->filename=strdup(foo);
    q->Sources = makeSourceList(sid,q->Sources);
    
  }
  q->numsources=n;
  char buf[1024];
  sprintf(buf,"%s/%s",dir,file);
  FILE *f=fopen(buf,"w");
  if(f != 0) {
    WriteQuestionfp(f,q);
    delete q;
    return GFM_OK;
  } else {
    sprintf(buf,"Couldn't save question to %s/%s",dir,file);
    display_alert(buf);
    delete q;
    return GFM_ERROR;
  }

}

Menu_item save_callback(Menu i, Menu_item t) {
  char buf[1024];
  
  sprintf(buf,"%s/wais-questions/",home);
  gfm_popup_objects* save_dialog = 
    gfm_initialize(NULL,NULL,"Save Question");
  gfm_activate(save_dialog,
	       buf, // directory
	       NULL, // ed pattern
	       NULL, // filter
	       save_question_callback, // callback
	       NULL, // glyph
	       GFM_SAVE);
  return 0;
}

void
DoSearch(Panel_item item, Event *event)
{
  olwais_olw_objects *ip = (olwais_olw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
  
  if(strcmp(keyword_text.get_text(),"") == 0 || chosen_list.num_rows() == 0) {
    display_alert("You must specify keywords and sources");
    if(chosen_list.num_rows() == 0) {
      PrepareSources();
      source_frame.show();
    }
  } else {
    if(!q) {
      q= new _Question;
    }
    bzero(q,sizeof(_Question));
    int n;
    char buf[1024];
    sprintf(buf,"%s/wais-sources/:",home);
    q->sourcepath = buf;
    q->maxresdocs = 40;
    strcpy(q->name,"hello world");
    strcpy(q->keywords,keyword_text.get_text());
    results.delete_all();
    results.show(1);
    
    for(n=0;n <chosen_list.num_rows();n++) {
      SourceID sid;
      void* client_data;
      Xv_opaque glyph;
      sid = new _SourceID;
      char* foo = (chosen_list.get_item(n,&client_data,&glyph));
      sid->filename=strdup(foo);
      q->Sources = makeSourceList(sid,q->Sources);
      
    }
    q->numsources=n;
    DocList dlist=0;
    for (n = 0; n < relevant_list.num_rows();n++) {
      DocumentID did;
      Xv_opaque glyph;
      relevant_list.get_item(n,(void**)&did,&glyph);
      dlist = makeDocList(did,dlist);
    }
    q->RelevantDocuments=dlist;
    search_frame.set_busy(TRUE);
    SearchWais(q);
//    freeDocList(q->RelevantDocuments);
    search_frame.set_busy(FALSE);
    DocList dl = q->ResultDocuments;
    sort_document_list(dl);
    while (dl) {
      results.append(dl->thisDoc->doc->headline,(void*)copy_docid(dl->thisDoc));
      dl = dl->nextDoc;
    }
    results.set_notify_proc(doDoc);
    // gxv_start_connections DO NOT EDIT THIS SECTION
    
    char msgbuf[1024];
    sprintf(msgbuf,"Results for <%s>",q->keywords);
    results_frame.set_header(buf);
    xv_set(Olwais_ResultsPopup.ResultsPopup, XV_SHOW, TRUE, NULL);
    
    // gxv_end_connections
  }
}

//
// Drop callback function for `RelevanceFeedbackList'.
//
void
olwais_olw_RelevanceFeedbackList_drop_callback(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info)
{
	olwais_olw_objects *ip = (olwais_olw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
//	fputs("Successful Drop. GDD_DROP_INFO contents:\n", stderr);
//	gdd_print_drop_info(drop_info);
	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	AddRelevantDoc(item, event, drop_info);
	
	// gxv_end_connections

}

//
// User-defined action for `RelevanceFeedbackList'.
//
void
AddRelevantDoc(Xv_opaque item, Event *event, GDD_DROP_INFO *drop_info)
{

}

//
// Notify callback function for `SelectSourcesButton'.
//
void
olwais_olw_SelectSourcesButton_notify_callback(Panel_item item, Event *event)
{
	olwais_olw_objects *ip = (olwais_olw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	xv_set(Olwais_SourceSelectPopup.SourceSelectPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
	xv_set(Olwais_SourceSelectPopup.SourceSelectPopup, XV_SHOW, TRUE, NULL);
	
	PrepareSources();
	
	// gxv_end_connections

}

//
// Notify callback function for `ResultsList'.
//
int
ViewDoc(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	olwais_ResultsPopup_objects *ip = (olwais_ResultsPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		break;

	case PANEL_LIST_OP_SELECT:
		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	// gxv_end_connections

	return XV_OK;
}

//
// Notify callback function for `SourcesList'.
//
int
olwais_SourceSelectPopup_SourcesList_notify_callback(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	olwais_SourceSelectPopup_objects *ip = (olwais_SourceSelectPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		break;

	case PANEL_LIST_OP_SELECT:
		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	DeSelectChosen(item, string, client_data, op, event, row);
	
	xv_set(Olwais_SourceSelectPopup.AddSources, PANEL_LABEL_STRING, "->", NULL);
	
	// gxv_end_connections

	return XV_OK;
}

//
// User-defined action for `SourcesList'.
//
void
DeSelectChosen(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	chosen_list.deselect_all();
}

//
// Notify callback function for `ChosenSourcesList'.
//
int
olwais_SourceSelectPopup_ChosenSourcesList_notify_callback(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	olwais_SourceSelectPopup_objects *ip = (olwais_SourceSelectPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		break;

	case PANEL_LIST_OP_SELECT:
		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	DeSelectSources(item, string, client_data, op, event, row);
	
	xv_set(Olwais_SourceSelectPopup.AddSources, PANEL_LABEL_STRING, "<-", NULL);
	
	// gxv_end_connections

	return XV_OK;
}

//
// User-defined action for `ChosenSourcesList'.
//
void
DeSelectSources(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	source_list.deselect_all();
}

//
// Notify callback function for `AddSources'.
//
void
AddOrDeleteSources(Panel_item item, Event *event)
{
	olwais_SourceSelectPopup_objects *ip = (olwais_SourceSelectPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	if(strcmp(add_button.get_label(),"<-")) {
	  // transfer to chosen list
	    int n;
	  for(n = source_list.get_first(); n != -1; n = source_list.get_next()) {
	    char* tmp;
	    void* x;
	    Xv_opaque y;
	    tmp = source_list.get_item(n,&x,&y);
	    chosen_list.append(tmp,x,y);
	    source_list.select(n,0);
	  }
	} else {
	  chosen_list.delete_selected();
	}


      
	// gxv_start_connections DO NOT EDIT THIS SECTION

	// gxv_end_connections

}

//
// Notify callback function for `AutopickSourcesButton'.
//
void
olwais_SourceSelectPopup_AutopickSourcesButton_notify_callback(Panel_item item, Event *event)
{
	olwais_SourceSelectPopup_objects *ip = (olwais_SourceSelectPopup_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	

	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	set_sources(item, event);
	
	// gxv_end_connections

}

//
// User-defined action for `AutopickSourcesButton'.
//
void
set_sources(Panel_item item, Event *event)
{
}

//
// User-defined action for `SelectSourcesButton'.
//
void
PrepareSources(void)
{
  
  source_list.delete_all();
  char buf[1024];
  sprintf(buf,"%s/wais-sources",home);
  directory sources(buf,1);
  
  dirlist* foo = sources.items();
  source_list.delete_all();
  int n=0;
  while(foo) {
    file_or_directory* item;
    item = foo->car();
    if(item->type == file_or_directory::is_file) {
      source_list.append(item->name);
      n++;
    }
    foo = foo->cdr();
  }
  source_list.set_sorted(PANEL_FORWARD);
}

//
// Menu handler for `FileMenu (Quit)'.
//
Menu_item
olwais_FileMenu_item2_callback(Menu_item item, Menu_generate op)
{
	olwais_olw_objects * ip = (olwais_olw_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		// gxv_start_connections DO NOT EDIT THIS SECTION

		{
			exit(0);
		}
		
		// gxv_end_connections

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

//
// Notify callback function for `Dismiss'.
//
void
olwais_Alert_Dismiss_notify_callback(Panel_item item, Event *event)
{
	olwais_Alert_objects *ip = (olwais_Alert_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	// gxv_start_connections DO NOT EDIT THIS SECTION

	xv_set(Olwais_Alert.Alert, XV_SHOW, FALSE, NULL);
	
	// gxv_end_connections

}
int 	doDoc(Panel_item item,  char* name, Xv_opaque client_data,
	      Panel_list_op the_op, Event* the_event, int row) 

{
  struct timeval when;
  static timeval last_when;
  static int last_x,last_y;

  when = event_time(the_event);
  switch(the_op) {
  case PANEL_LIST_OP_DESELECT: {
    long delta = (when.tv_sec*1000000 + when.tv_usec) -
      (last_when.tv_sec*1000000 + last_when.tv_usec);
    int dx = last_x - the_event->ie_locx;
    int dy = last_y - the_event->ie_locy;
    int ds = dx*dx + dy*dy;

    if(delta < DCLICK && ds <5) {
      long fred=0;
      FILE* f;
      
      char* nam = tmpnam(NULL);
      f = fopen(nam,"w");
      if(!f) {
	char mess[1025];
	sprintf(mess,"couldn't open temporary file %s\n",nam);
	display_alert(mess);
      } else {
	DocumentID doc = (DocumentID)client_data;
	char command_line[2048];
	char* type =  show->best_match(doc->doc->type,command_line,nam);
	if(type == 0) {
	  char buf[1025];
	  sprintf(buf,"No Handler for documents of type <%s>",*doc->doc->type);
	  display_alert(buf);
	} else {
	  char mess[1025];
	  sprintf(mess, "fetching %s",doc->doc->headline);
	  results_frame.set_left_footer(strdup(mess));
	  results_frame.show_footer();
	  fred =0;
	  GetWaisDocument(q,doc,type,f,&fred);
	  fclose(f);

	  if(!fork()) {
	    system(command_line);
	    unlink(nam);
	    exit(0);
	  } else {
	    fclose(f);
	  }
	}
      }
    }
    
    break;
  }
  case PANEL_LIST_OP_SELECT:
    last_when = when;
    last_x = the_event->ie_locx;
    last_y = the_event->ie_locy;
    break;
  case PANEL_LIST_OP_VALIDATE:
    break;
  case PANEL_LIST_OP_DELETE:
    return XV_OK;
  default:
    printf("should not happen\n");
  }

  
}

