/*****************************************************************************
 * concat.c: utility function to concatenate 
 *           command-line arguments into a string.   
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>

String
xs_concat_words(n, words)
  int   n;
  char *words[];
{
  int i, len;
  String s;
  /*
   * If there are no arguments other than the program
   * name, just return an empty string.
   */
  if (n <= 0)
    return ((String)NULL);

  len = 0;
  for (i = 0; i < n; i++)
    len += strlen(words[i])+1;
  s = XtMalloc(len);
  s[0] = '\0';
  for (i = 0; i < n; i++)  {
    if(i > 0)
      strcat(s, " ");
    strcat(s, words[i]);
  }
  return(s);
}
