/*****************************************************************************
 * raster.c : Display some tiling patterns
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h> 
#include <Xol/OpenLook.h>
#include "xs_bitmaps.h"
#include "libXs.h"

xs_bitmap_struct bitmaps[] = {
  solid_bits,       solid_width,       solid_height,
  clear_bits,       clear_width,       clear_height,
  vertical_bits,    vertical_width,    vertical_height,
  horizontal_bits,  horizontal_width,  horizontal_height,
  slant_right_bits, slant_right_width, slant_right_height,
  slant_left_bits,  slant_left_width,  slant_left_height,
  fg50_bits,        fg50_width,        fg50_height,
  fg25_bits,        fg25_width,        fg25_height,
  cross_bits,       cross_width,       cross_height,
};

main(argc, argv)
  int   argc;
  char *argv[];
{
  Widget toplevel, browser;
   
  toplevel = OlInitialize(argv[0], "Browser", NULL, 0, 
                          &argc, argv);
  /*
   * Create the browser.
   */
  browser = xs_create_pixmap_browser(toplevel,bitmaps, 
                                     XtNumber(bitmaps), 
                                     NULL, NULL, NULL);
  XtManageChild(browser);
  XtRealizeWidget(toplevel);
  XtMainLoop();
}
