/*****************************************************************************
 * draw.c: just makes a widget tree used for resource manager discussion 
 *         in chapter three.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h> 
#include <Xol/OpenLook.h>
#include <Xol/Stub.h>
#include <Xol/Nonexclusi.h>
#include <Xol/RectButton.h>
#include <Xol/BulletinBo.h>
#include <Xol/ControlAre.h>
#include <Xol/Form.h>

main(argc, argv)
  int argc;
  char **argv;
{
  Widget toplevel, canvas, panel, commands,  options;
  
  toplevel = OlInitialize(argv[0], "Draw", NULL, 0, &argc, argv);
  
  panel = XtCreateManagedWidget("panel", formWidgetClass, 
                                toplevel, NULL, 0);

  commands = XtCreateManagedWidget("commands", nonexclusivesWidgetClass, 
                                   panel, NULL, 0);

  canvas = XtCreateManagedWidget("canvas", stubWidgetClass, 
				 panel, NULL, 0);

  options = XtCreateManagedWidget("options", nonexclusivesWidgetClass, 
                                  panel, NULL, 0);

  XtCreateManagedWidget("command1", rectButtonWidgetClass, 
                        commands, NULL, 0);
  XtCreateManagedWidget("command2", rectButtonWidgetClass, 
                        commands, NULL, 0);
  XtCreateManagedWidget("command3", rectButtonWidgetClass, 
                        commands, NULL, 0);
  XtCreateManagedWidget("button1", rectButtonWidgetClass, 
                        options, NULL, 0);
  XtCreateManagedWidget("button2", rectButtonWidgetClass, 
                        options, NULL, 0);
  XtCreateManagedWidget("button3", rectButtonWidgetClass, 
                        options, NULL, 0);
  
  XtRealizeWidget(toplevel);
  
  XtMainLoop();
}
