/*****************************************************************************
 * memo2.c: Demonstrate a callback function
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>
#include "libXs.h"

main(argc, argv)
  int   argc;
  char *argv[];
{
  Widget     toplevel, msg_widget;
  Arg        wargs[1];
  int        n;
  String     message;
  void       quit();

  /*
   * Initialize the Intrinsics
   */
  toplevel = OlInitialize(argv[0], "Memo", NULL, 0, &argc, argv);
  /*
   * If a message is given on the command line,
   * use it as the XtNlabel argument for the widget
   */  
  n = 0;
  if ((message = xs_concat_words(argc-1, &argv[1])) != NULL) {
    XtSetArg(wargs[n], XtNlabel, message); n++;
  }
  /*
   * Create the OblongButton widget.
   */
  msg_widget = XtCreateManagedWidget("msg", oblongButtonWidgetClass,
                                     toplevel, wargs, n);
  /*
   * Register the callback to be called when 
   * a button is pressed
   */
  XtAddCallback(msg_widget, XtNselect, quit, NULL);
  /*
   * Realize the widgets and enter the event loop.
   */
  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
quit(w, client_data, call_data)
  Widget     w;
  XtPointer  client_data;
  XtPointer  call_data;
{
  XtCloseDisplay(XtDisplay(w));
  exit(0);  
} 
