.\" Copyright (c) 1989 O'Reilly and Associates, Inc.

     The X Consortium, and any party obtaining a copy of these files from
     the X Consortium, directly or indirectly, is granted, free of charge, a
     full and unrestricted irrevocable, world-wide, paid up, royalty-free,
     nonexclusive right and license to deal in this software and
     documentation files (the "Software"), including without limitation the
     rights to use, copy, modify, merge, publish, distribute, sublicense,
     and/or sell copies of the Software, and to permit persons who receive
     copies from any such party to do so.  This license includes without
     limitation a license to do the foregoing actions under any patents of
     the party supplying this software to the X Consortium.
.\"
.TH BASECALC 1 "August 15, 1989"
.UC 5
.SH NAME
basecalc \- programmer's calculator
.SH SYNOPSIS
basecalc
[-s]
[ -x | -h | -d | -o | -b]
[-background \fIcolorname\fR]
[-bg \fIcolorname\fR]
[-display \fIservername\fR]
[-fg \fIcolorname\fR]
[-foreground \fIcolorname\fR]
.SH OPTIONS
.IP "-s" 11n
Begin in unsigned mode.
.IP "-x" 11n
Begin in hexadecimal mode.
.IP "-h" 11n
Begin in hexadecimal mode.
.IP "-d" 11n
Begin in decimal mode (the default).
.IP "-o" 11n
Begin in octal mode.
.IP "-b" 11n
Begin in binary mode.
.SH DESCRIPTION
.I basecalc 
is a simple programmer's calculator written using Xlib that is 
especially useful for binary math and for converting between binary, 
decimal, octal, and hexadecimal.
.LP
The long horizontal window along the top of the calculator is the
display, in which the values punched on the calculator and results
are displayed.  The digits (0-9) and letters (A-F) in the
left-hand portion of the calculator keypad are for entering
values.  The top row of the right-hand portion
of the keypad is for base selection.  These can be used either to
set the current base of calculations, or to
convert a value between bases.  Only
one of the base indicators is highlighted at a time.
.LP
.XX "basecalc, how to use"
Only valid numbers in the current base are
allowed to be entered.  Valid pads
are black while invalid ones are light gray (by default).
When a pad is triggered by pressing a pointer button, it flashes 
white, and the operation or value indicated by the pad
is executed if the pointer button
is released in the same pad.  The pad
also responds to the pointer entering
or leaving the window while a pointer button is pressed.
.LP
The calculator also operates from the keyboard.  Numbers, letters, 
and special characters can be typed in to represent all the functions.
The Backspace key performs the Clear Entry (CE) function.
.LP
This calculator does not have a Reverse Polish Notation (RPN) mode.
.LP
Here is the list of available functions and how they are used.
.LP
All operations work in all bases.  You may shift bases at any
point in any calculation.  The last of any series of consecutive
operators pressed will be acted upon.
.IP "+\^,\ -\^,\ *\^,\ /" 11n
Normal addition, subtraction, multiplication, and division.  A number is
entered, then one of these operators, then another number, and finally the
equals sign, Enter key, or any operator.  The result will then be displayed in
the window.  If the last character entered was an operator, you can continue
specifying numbers and operators in alternation.
.IP "| , &"
AND and OR.  Used just like the addition operator.  The "|" and "&" 
symbols on the keyboard trigger this function.
.IP "<<\ ,\ >>"
Shift Left and Shift Right.  Used just like the addition operator.  
Enter the
number to be shifted, then the ">>" or "<<" pad (or the "\fB>\fR" or
"\fB<\fR" keys), and then the number of bits to shift the number, followed by
the "\fB=\fR" or Enter key.
.IP "^"
Exclusive OR.  Used just like the addition operator.  Sets all bits 
that are in either number but not both.  Available from the ^ (caret) 
key.
.IP "%"
Mod  (remainder after division).  Used like the addition operator.
Available on the % (percent) key.
.IP "`"
Change sign.  This is a unary operator, since it performs its 
function immediately on the current contents of the display.  Its 
results depend on whether the calculator is in signed or
unsigned mode.  If in unsigned mode, the result is the unsigned 
equivalent of a negative number.
This function is available from the left single-quote key.
.IP "~"
Two's complement.  This is a unary operator.  It changes all the bits 
in the value.
.IP "CE"
Clear Entry.  Erases the last value entered.  The Backspace key also performs this function.
.IP "CD"
Clear Digit.  Erases the last digit entered.
.IP "CA"
Clear All.  Clears all operator and value registers.
.IP "U\ or\ S"
Unsigned or Signed.  Specifies whether all other operations should be 
performed in signed or unsigned mode.
.IP "="
Compute.  The Return key also performs this function.
.SH AUTHOR
Alan Greenspan of Stellar Computer.  Modified for
publication as an Xlib programming example by Adrian Nye of O'Reilly 
and Associates, Inc.
.SH BUGS
One font, one size.
