/*-------------------------------------------------------------*/
/*  File:  slider.c 
 *
 *  Demonstrates the use of the Slider widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Slider.h>

/* Callback */
static void slider_moved();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w;
    int    min_value = 20, max_value = 80, step_size = 5,
           current_value = 50;

/* Create the Slider widget */    
    w = XtVaCreateManagedWidget("Slider1",
                      sliderWidgetClass, parent,
                      XtNwidth,         200,
                      XtNorientation,   OL_HORIZONTAL,
                      XtNsliderMin,     min_value,
                      XtNsliderMax,     max_value,
                      XtNsliderValue,   current_value,
                      XtNgranularity,   step_size,
                      NULL);

/* Add callback for the XtNsliderMoved resource. */
   XtAddCallback(w, XtNsliderMoved, slider_moved,
                        (XtPointer)&current_value);
    return w;
}
/*-------------------------------------------------------------*/
static void slider_moved(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
/* Current slider value is *call_data and in client_data we 
 * have passed the address of the value being maintained 
 * through this slider. Here we copy *call_data into 
 * *client_data.
 */
    printf("Old value = %d\n", *(int *)client_data);

    *(int *)client_data = *(int *)call_data;

    printf("New value = %d\n", *(int *)client_data);
}


