/*-------------------------------------------------------------*/
/*  File:  scroll.c 
 *
 *  Demonstrates the use of the Scrollbar widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Scrollbar.h>

/* Callback */
static void slider_moved();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w;
    int    min_value = 0, max_value = 500, step_size = 25,
           current_value = 0, proportion = 300;

/* Create the Scrollbar widget */    
    w = XtVaCreateManagedWidget("Scrollbar1",
                      scrollbarWidgetClass, parent,
                      XtNwidth,            200,
                      XtNorientation,      OL_HORIZONTAL,
                      XtNsliderMin,        min_value,
                      XtNsliderMax,        max_value,
                      XtNsliderValue,      current_value,
                      XtNgranularity,      step_size,
                      XtNproportionLength, proportion,
                      NULL);

/* Add callback for the XtNsliderMoved resource. */
   XtAddCallback(w, XtNsliderMoved, slider_moved,
                        (XtPointer)&current_value);
    return w;
}
/*-------------------------------------------------------------*/
static void slider_moved(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
/* Here call_data is a pointer to an OlScrollbarVerify 
 * structure which has the new value in the member
 * named new_location. In client_data we have have passed 
 * the address of a value being maintained through this 
 * scrollbar. So we simply copy the new value 
 * into *client_data.
 */
    OlScrollbarVerify *p_sb = (OlScrollbarVerify *)call_data;

    printf("Old value = %d\n", *(int *)client_data);

    if(p_sb->ok)
    {
        *(int *)client_data = p_sb->new_location;
        printf("New value = %d\n", *(int *)client_data);
    }
}


