/*-------------------------------------------------------------*/
/*  File:  notice.c 
 *
 *  Demonstrates the NoticeShell widget
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/OblongButt.h>
#include <Xol/Notice.h>

/* ID of the NoticeShell widget */
static Widget notice_shell;

/* Callback that displays the Notice */
static void pop_notice();

/* Callback for the "Exit" button in the NoticeShell */
static void do_exit();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, n_text, n_control, n_exit, n_cancel;

/* Create a button and provide a callback to pop up a Notice */
    w = XtVaCreateManagedWidget("QuitButton", 
                      oblongButtonWidgetClass, parent,
                      XtNlabel,    "Exit...",
                      NULL);
    XtAddCallback(w, XtNselect, pop_notice, NULL);
    
/* Create the NoticeShell widget. Note that you have to use
 * XtVaCreatePopupShell instead of the usual 
 * XtVaCreateManagedWidget.
 */
    notice_shell = XtVaCreatePopupShell("QuitNotice", 
                      noticeShellWidgetClass, w,
                      NULL);

/* Get the ID of the text and control area widgets of the
 * NoticeShell.
 */
    XtVaGetValues(notice_shell, 
                  XtNtextArea,        &n_text,
                  XtNcontrolArea,     &n_control,
                  NULL);

/* Place a message in the text area of the NoticeShell */
    XtVaSetValues(n_text, 
            XtNstring, "Please confirm exit from program.",
            NULL);

/* Add buttons to the control area of the NoticeShell.
 * Each button has an appropriate callback.
 */
    n_exit = XtVaCreateManagedWidget("NoticeExit", 
                      oblongButtonWidgetClass, n_control,
                      XtNlabel,    "Exit",
                      NULL);

    XtAddCallback(n_exit, XtNselect, do_exit, NULL);

    n_cancel = XtVaCreateManagedWidget("NoticeCancel", 
                      oblongButtonWidgetClass, n_control,
                      XtNlabel,    "Cancel",
                      XtNdefault,  True,
                      NULL);
    return w;
}
/*-------------------------------------------------------------*/
static void pop_notice(w, call_data, client_data) 
Widget    w; 
XtPointer call_data, client_data;
{
/* Here, w is the "emanating button," the button that caused
 * the notice to pop up.
 */
    XtVaSetValues(notice_shell, XtNemanateWidget, w, NULL);

/* Pop up the NoticeShell widget. The NoticeShell widget makes
 * sure that the aplication waits until the user selects from 
 * one of the buttons in the NoticeShell's control area.
 */
    XtPopup(notice_shell, XtGrabExclusive); 
}
/*-------------------------------------------------------------*/
static void do_exit(w, call_data, client_data) 
Widget    w; 
XtPointer call_data, client_data;
{
    XCloseDisplay(XtDisplay(w));
    exit(0);
}

