.TH TOUCHUP 1 "27 July 1988"
.SH NAME
touchup \- a bitmap graphics editor for Sun raster files
.SH SYNOPSIS
.B touchup
[
.BI \-x " width"
] [
.BI \-y " height"
] [
.B \-n
] [
.B \-p
] [
.B \-f
] [
.B \-b
]
.SH DESCRIPTION
.IX "touchup command"  ""  "\fLtouchup\fP \(em bitmap editor"
.IX edit  bitmaps
.IX "screen bitmaps"  edit
.LP
.I Touchup
is an editor for bitmap raster files in Sun 
.IR rasterfile (5)
format
.SH OPTIONS
.TP
.BI \-x " width"
Use
.I width
as the width of the drawing area (default: 1152 pixels).
.TP
.BI \-y " height"
Use
.I height
as the height of the drawing area (default: 900 pixels).
.TP
.B \-n
Disable the
.I undo
command so that
.I touchup
requires less memory.
The use of this option will make the color version much more usable for
machines with only 4 megabytes of main memory.
.TP
.B \-p
Start \fItouchup\fP with a drawing area of 900x1152.
These dimensions are more suitable for printing images,
as the drawing area is in proportion to the standard American 8.5 by 11 inch
paper size.
.TP
.B \-f
This option will force \fItouchup\fP to use the default foreground
and background colors instead of the foreground and background
color of the image the is load from a file.
.TP
.B \-b
Run \fItouchup\fP in Black & White mode. This option is useful when you
want to use a color Sun to edit monochrome bitmaps. The use of this
option will also make the color version much more usable for
machines with only 4 megabytes of main memory.
.SH COMMANDS
.LP
To edit a bitmap, type `\fBtouchup\fP'.  
A \fIraster file\fP (5)
file name may be typed into the file name field once the program has started.
If it exists, the \fIraster file\fP must be in \fISun Rasterfile\fP\^(5) format.
When the program starts, it displays a single large window containing
five subwindows.  From top to bottom, the five subwindows are:
.SS "OPTION SUBWINDOW"
.LP
The option subwindow presents global parameters for the
entire drawing area operations for loading and saving files.
The bottom line of this window is a message subwindow, which displays
messages, prompts, and warnings.  The selectable options are:
.RS
.IP "\fBFile name:\fP" 10
The file name of the current bitmap.  The ESC key can be used to do
standard
.IR csh (1)
file name completion.
.IP "\fB(Load)\fP" 10
Load the raster file specified in the file name field.
.RS
.IP "\fBLoad:Cut/Paste buffer\fP" 10
Load a raster file into the Cut/Paste buffer, where it can be previewed
with the
.B view
feature.  When a color image is loaded in the Cut/Paste buffer the color map for
that image is lost. The color map is only loaded in when a color image is
loaded into the drawing area, with option
.BR Load:entire image .
.IP "\fBLoad:entire image\fP" 10
Load a raster file into the drawing area and restrict the size of the drawing
area to the size of the raster file.  If the image has depth greater than
one then load the color map.
.RE
.IP "\fB(Save)\fP"
Save the current raster image in the file specified in the file name field:
.RS
.IP "\fBSave:Cut/Paste buffer\fP" 10
Save only the current Cut/Paste buffer.
.IP "\fBSave:entire image\fP" 10
Save the image in the drawing area.
.IP "\fBSave:standard format\fP" 10
Save the drawing area image in standard Sun
.IR rasterfile (5)
format.
.IP "\fBSave:standard format\fP" 10
When the save cycle is set to this mode the current image
will be saved out in the standard Sun raster file format.
.IP "\fBSave:Byte_Encoded\fP" 10
Save the drawing area image in Sun
.IR rasterfile (5)
BYTE_ENCODED format.  This can compress the file by as much as one half,
but such a file is not readable by the
.B screenload
command.
.RE
.IP "\fB(Quit)\fP"
Quit the program.
.IP "\fBGrid: (none 5 10 15 20 25 30)\fP"
Force every bitmap operation to the closest grid point
(when grid value is greater than zero).  The number following
.B Grid
is the number of pixels between each grid point (the actual grid is not
visible).
.IP "\fBBitmap OP: default\fP"
The BITMAP OP setting determines what boolean operation is to be performed
between the drawing primitive and the destination bitmap. The possible
boolean operations are default, which uses default settings for each
command, XOR which does a exclusive-or (invert), AND which will do
a AND between the bits in the drawing area and the ones you are drawing,
OR which will just set bits in the drawing area but not rest any bits,
and SRC, which will just copy the source drawing directly on to the
drawing area.
For example,
if you wanted to place white text in to a black region of the drawing area.
You would first set BITMAP OP to XOR (exclusive or) and do the normal
commands to place text in the drawing area.
.IP "\fB(undo)\fP"
When this button is pressed the last operation effecting the drawing
area will be removed. If this button is pressed again, the last
operation effecting the drawing area will be redisplayed.
Also if you hold down the "shift" key and press the middle mouse
button it will have the same effect as pressing the "undo" button.
.IP "\fB(view)\fP"
When this button is pressed a window will be displayed containing
one of three possible images, depending on the "view" cycle.
.IP "\fBview:man page\fP"
This will set the view to the manual page entry for
.IR Touchup ,
so that when
the "view" button is pressed, a window containing the manual page
will be displayed.
.IP "\fBview:Cut/Paste\fP"
This will set the view to the current Cut/Paste buffer, so that when
the "view" button is pressed, a window with current Cut/Paste buffer
will be displayed.
.IP "\fBview:Touchup info\fP"
This will set the view to the copyright notice for
.IR Touchup ,
so that when
the "view" button is pressed, a window with the copyright notice
will appear.
.IP "\fB(resize)\fP"
When this button is pressed the current value of the "height" and "width"
fields will be used to resize the drawing area.  For example if you want to
change the drawing area to a space of 512 by 512 pixels, you would simple
select the "height" field and type in 512 and then select the "width" field
and type 512 then press the "resize" button.
.IP "\fBHeight: xxx\fP"
This field displays the current height of the drawing area in pixels.
If you press the LEFT mouse button while on top of this field, you
can type in a new value for this field.
.IP "\fBWidth: xxx\fP"
This field displays the current width of the drawing area in pixels.
.IP "\fBBorders:Yes\fP"
This cycle determines is borders are drawn on filled rectangles
and filled polygons.
.IP "\fBDraw color:Black\fP"
This cycle determines the color for DRAWing points, the border of
filled reactangles, the border of filled polygons, and lines.
This option is ONLY available when you are running in on a mono Sun or
when you are in Black & White mode.
.IP "\fB(color)\fP"
When \fBtouchup\fP is run on a color Sun this button will become visible.
When the "color" button is pressed the current colormap will be displayed,
along will the colormap editor.  At the top of this window is the number of
the currently selected color and the RGB values for that color. When
you change the RGB values, by moving the sliders, the current color will
dynamicly be changed.
.IP "\fB(color) (Load)\fP"
Once the Color Palette is displayed you can
load a colormap from a file by pressing the "Load" button on the 
Color Palette window. The colormap will be loaded from the filename that
displayed just under the "Load" button.
.IP "\fB(color) (Save)\fP"
Once the Color Palette is displayed you can
save just the colormap to a file by pressing the "Save" button on the 
Color Palette window. The colormap will be saved to the filename that
displayed just under the "Save" button.
.IP "\fB(color) Filename:\fP"
The filename that colormaps are loaded from and saved to.
.IP "\fBlasso clear:X\fP"
If this option is turned on (it is turned on by default),
then when a region is selected
with the LASSO it will first copy the region to the Cut/Paste
buffer and then it will clear the selected region.  If you place the
mouse on top of the box after "lasso clear" and press the LEFT mouse
button you can toggle this
option on and off.  When this option is turned off the region that
selected by LASSO is not cleared.
.IP "\fBMessages\fP"
The bottom line of this window is a message subwindow, which displays
messages, prompts, and warnings.
.RE
.RE
.SS "PATTERN SUBWINDOW"
.LP
The pattern subwindow, the subwindow on the lefthand edge of the main window,
is the pattern subwindow.  This subwindow contains all of the paint
and fill patterns that can be used to draw pictures.
The current pattern is selected by placing the mouse cursor on top of
the pattern that you want and pressing the LEFT mouse button.
.IP "\fB(Define pattern)\fP"
To select a region on the drawing area as a new paint pattern: 1) select
the point at the center of the region, with the SELECT POINT command; 2) press
.BR "Define pattern" .
.SS "COMMAND SUBWINDOW"
.LP
The command subwindow is the one that
is on the right hand side of the main window. To select a command place the
the mouse cursor on top of the command that you want and press the LEFT
mouse button.
.IP "\fBTEXT\fP" 10
After you have selected the TEXT command, the ABC icon,
move to the drawing area and press the LEFT mouse button where
you want to place the text, then type your text string.
Once you enter TEXT mode, the TEXT options will be displayed in the
EXTRA COMMAND SUBWINDOW in lower righthand corner.
The icons in this window will allow you to choose either CENTERED,
LEFT JUSTIFIED, or RIGHT JUSTIFIED text. By clicking the LEFT mouse button
on the different page images, the page formatting for text input will be set.
Under the page images are the "fonts" button
and the "pt size" button.  When the "fonts" button is pressed a list
of the current fonts will be displayed and the selected item will
become the current font.  Each font has a list of the possible point sizes
which can be accessed from the "pt size" or point size button.  When this
button is pressed the list of the point sizes for the current font will
be displayed and you can pick one size from the list.
.IP "\fBMAGNIFY\fP" 10
First use the SELECT POINT command to select a point within the drawing area that
you wish to look at in detail.  Then press the command icon for MAGNIFY
and a new subwindow with a magnified view of the selected area will be displayed.
In the top line of the MAGNIFY subwindow you can set the magnification to any
value between one and twenty.  When the mouse cursor is within the magnified
drawing area, there are three possible commands.  The LEFT mouse button will
change the current bit to the opposite color and then continue to draw in
that color.  When the MIDDLE mouse button is held down and moved, it will change
the area of the bitmap that is magnified.  When you are editing color images
the RIGHT mouse button will change the current drawing color to the color of
the pixel the mouse cursor is on top of.
.IP "\fBSELECT REGION\fP" 10
First click the picture of the box made of dotted lines.
Then move to the drawing area and press the LEFT button when
the cursor is at the desired position and continue to hold the
LEFT button down while you drag the box to the opposite corner of the
region you wish to select.
If you double click SELECT REGION then the entire drawing area will be
selected.
If you need to select an area bigger than the drawing window,
first select one of the corners of the region with the LEFT mouse
button.  Then scroll the window so that the other corner of the
region you want is now visible.  Place the cursor on top of the
other corner of the region you want and press the the MIDDLE
mouse button.
.IP "\fBSELECT POINT\fP" 10
First click the picture of the cross hairs.
Then press the LEFT mouse button down and a cross hair
will appear; move the mouse while holding the LEFT mouse button down and the
cross hair will follow it. Releasing the
the button will leave the cross hair.
.IP "\fBLASSO\fP"
First select the picture of the LASSO, (right above the paint brush), then
move the mouse to the drawing area.  To LASSO a object hold down the LEFT mouse
button and encircle the object that you wish to capture while the LEFT
button is pressed.  When you let go of the LEFT mouse button the selected
object will first be highlighted and then it will be copied into the Cut/Paste
buffer. Then you will be placed into MOVE mode, this function is documented
in the Cut/Paste buffer operations section.
.IP "FLOOD FILL\fP"
First select a point on the drawing area that is inside a closed polygon region.
When the FLOOD FILL
icon is pressed, it will start at the selected point and
fill outward until it hits a border with the currently selected pattern.
.IP "\fBPAINT\fP"
Once the PAINT command is selected, whenever the LEFT mouse button is pressed,
a region of the drawing area will be painted with the current pattern and
the size of this region will be determined by the current brush size.
Whenever the paint command is selected a brush menu will appear in the window
below the command subwindow. The current brush size can be set by placing the
cursor on top of a brush size within the brush menu and pressing the LEFT
mouse button.
.IP "\fBDRAW\fP"
Once this command is selected, whenever the LEFT mouse button is pressed within the
drawing area a single pixel of the current DRAW COLOR will be placed at
the location of the mouse cursor.
.IP "\fBLINE\fP"
When this command is selected, a line thickness menu will appear in the
lower righthand window. First select the thickness of the line, then
select the pattern, from the pattern menu, that the thick line will
be filled with.
Then the left button down marks the end point of a
line; moving with the button down
rubber bands a line; releasing button
draws the line with the current thickness and current fill pattern.
.IP "\fBERASE\fP"
Pressing the LEFT button down will ERASE a small square region and
moving with the button down will 
continue ERASing until the LEFT button
is released. If a region is already selected when the ERASE icon is pressed
the specified region will be erased. If you double click the ERASE icon the
entire drawing area will be erased.
.IP "\fBRECTANGLE\fP"
When this command is selected, a border thickness menu will appear in the
lower righthand window. First select the thickness of the border, then
select the pattern, from the pattern menu, that the borders will
be filled with.
The left button down marks one corner of the rectangle
; moving with the button down
rubber bands a rectangle; releasing button
draws the rectangle with the current thickness and current fill pattern.
.IP "\fBRECTANGLE Filled\fP"
Like \fBLINE\fP except draws a rectangle that is filled with the currently
selected pattern, from the pattern menu.
.IP "\fBCIRCLE\fP"
Move the mouse cursor to the center of the circle that you with to draw
and hold down the LEFT mouse button, then while continuing to hold the LEFT
mouse button down extend the cursor to the radius of the circle that you want
and then release the LEFT mouse button.
.IP "\fBOVAL\fP"
Like \fBCIRCLE\fP except draws a oval.
.IP "\fBPOLYGON\fP"
Once this command is selected, move to the drawing area and press the LEFT mouse
button when the cursor is at the first vertex of the polygon that
you wish to draw.  Then continue to use the LEFT mouse button to select vertices
of the polygon.  When you have selected all of the vertice that you want, press
the RIGHT button to close the polygon.
.IP "\POLYGON FILLED\fP"
Like \fBPOLYGON\fP except it fills the polygon with the currently selected
pattern from the pattern subwindow.
.SS "EXTRA COMMAND SUBWINDOW"
.LP
The subwindow below the command subwindow, is the extra command subwindow.  There are two possible
windows that will appear within this subwindow, the first is the brush size,
line size, rectangle size menu
which is described in the commands above documentation.  The other menu that
will appear in this subwindow is the Cut/Paste buffer command menu.
This subwindow will only be visible when the
.B SELECT REGION
command is pressed.
This menu has the following commands.
.IP "\fBMIRROR\fP"
This command will create a mirror image of the currently
selected region.
.IP "\fBFLIP\fP"
This command will FLIP the currently selected region upside down.
.IP "\fBINVERSE\fP"
This command will INVERSE the currently selected region.
.IP "\fBROTATE\fP"
This command will ROTATE the currently selected region ninity degree
clockwise.
.IP "\fBCOPY\fP"
This command will place a copy of the currently selected region into the
Cut/Paste buffer.
.IP "\fBSCALE\fP"
First use either COPY, CUT, or Load:Cut/Paste buffer to put an image into
the current Cut/Paste buffer.  Then press SELECT REGION so that you will
in the correct mode.  Now hold down the LEFT mouse button and select
the destination region for the Cut/Paste buffer.  If the size of the
destination region is different from the size of the original image
then the image will be SCALED to the fix into the destination area.
In this way the SCALE command can be used to enlarge, shrink, and stretch
images.
.IP "\fBMOVE\fP"
First use either COPY, CUT, or Load:Cut/Paste buffer to put an image into
the current Cut/Paste buffer.  Once the MOVE command has been selected,
move the mouse to the drawing area and hold down the RIGHT mouse button.
As long as the RIGHT mouse button is held down, you can position the image
where you like.  Then let go of the RIGHT mouse button to place a copy of
the image on the drawing area.
NOTE: If you are using the MOVE command with a color image you will
probably want to set the "Bitmap OP" to "SRC" so that the colors are
not messed up when the Cut/Paste buffer is copied onto the bitmap.
.IP "\fBCUT\fP"
This command will place a copy of the currently selected region into the
Cut/Paste buffer and then it will fill the selected region with the
currently selected pattern.
.IP "\fBPASTE\fP"
First use the SELECT POINT command to select the upper right hand corner
of where you wish to place the Cut/Paste buffer.  Then press the PASTE
command icon and the contents of the current Cut/Paste buffer will be copied
to the drawing area.
NOTE: If you are using the PASTE command with a color image you will
probabilly want to set the "Bitmap OP" to "SRC" so that the colors are
not messed up when the Cut/Paste buffer is copied onto the bitmap.
.IP "5)" 5
The last subwindow is the drawing area, which is in the center of the main
window.
.RE
.SH "PRINTING FILES:"
.LP
Save a image out to a file and use the following Unix command to
dump the image to a full page picture on an Apple Laser Writer or any
other PostScript laser printer, where
\fItfile\fP is the file name of an image created in
.IR Touchup .
The program 
.IR pssun(1) ,
from Adobe Systems, Inc. will read in a Sun rasterfile and convert it
to PostScript.  There is a similar public domain program call
.IR suntops(1) ,
that will convert Sun rasterfiles to PostScript.

.LP
When the picture is wider than it is high use the following command:
.br
.ti 1.0i
% pssun -s 8 10.5 -r tfile | lpr -Plw 
.LP
When the picture is higher than it is wide use this command:
.br
.ti 1.0i
% pssun -s 8 10.5 tfile | lpr -Plw 
.LP
When the picture is part of a document use this command:
.br
.ti 1.0i
% pssun -S 6 -l 1.5 3 tfile | lpr -Plw 
.LP
Images can also to sent to a IMPRESS laser printers with a command
similar to the following, where "/u5/sr/local/bin/imPf2" is the location
of the INPRINT program and "newcanon" is the name of the IMPRESS laser printer.
.br
.ti 1.0i   
% cat file_name | /u5/sr/local/bin/imPf2 | lpr -Pnewcanon
.SH "TYPICAL QUESTIONS:"
.IP "\fBHow do I select an area bigger than the drawing window ???\fP" 5
.LP
First go to SELECT REGION mode then select one of the corners of the region with the LEFT mouse
button.  Then scroll the drawing area subwindow so that the other corner of the
region you want is now visible.  Place the cursor on top of the
other corner of the region you want and press the the MIDDLE
mouse button.
.IP "\fBHow do I merge two different pictures in to one picture ???\fP" 5
.LP
When booting up
.IR Touchup ,
the default drawing area is 1152 x 900,
which is the full screen size of the Sun graphics screen.  When
you load a new picture
the drawing area is restricted to the size of the picture that you loaded.
What you need to do is start up
.I Touchup
and load the first picture
into the Cut/Paste buffer by changing the cycle next to the load
button from "Load: Entire image" to "Load: Cut/Paste buffer" and then
press the load button.  The file will then be in the cut/paste
buffer and you can PASTE it or MOVE it to where ever you like.
Then load the second picture into the Cut/Paste buffer and PASTE that
picture whereever you like.
.IP "\fBHow do I make part of a picture into an icon ???\fP" 5
.IP "\fBHow do I convert other image format to Sun rasterfile format ???\fP" 5
.IP "\fBHow do I convert Sun rasterfile format to other image formats ???\fP" 5
.LP
Use a program such as the \fIThe Portable Bitmap Toolkit\fP by Jef
Poskanzer(jef@lbl-rtsg.arpa)
This can be obtained by an
.IR ftp (1)
to expo.lcs.mit.edu (18.30.0.212) for the file contrib/pbm.tar.Z,
I also have a copy rolled out on tape if you do not have
access to the internet.  There is also a large collection of bitmaps
at expo.lcs.mit.edu in contrib/poskbitmaptars which can be converted
to Sun rasterfile format with the \fIThe Portable Bitmap Toolkit\fP
for use in
.IR Touchup.
.IP "\fBWhat does SAVE Byte_Encoded mean ???\fP" 5
.LP
This means that the image will be saved out in the Sun
.IR rasterfile (5)
BYTE_ENCODED format.  This will often compress the file to one half
of the normal size. One of the problems with saving a file in compressed
format is that 
.IR screenload (1)
command will then not be able to read the file.
.IP "\fBHow do I edit bit maps that are 1 bit deep on a color Sun ???\fP" 5
.LP
Use the -b commandline option, this option is described at the beginning of
this manual page.
.SH FILES
.TP
.I /usr/include/rasterfile.h\fP
Sun rasterfile format
.SH SEE ALSO
iconedit(1),
pssun(1),
rasterfile(5),
rastps(1),
screendump(1),
sceeenload(1),
suntops(1),
suntools(1)
.SH BUGS
.LP
If you try to 
.B "FLOOD FILL"
an area that has a VERY complex pattern and covers
a large area it is possible to overflow the stack and cause a core dump.
.LP
Touchup runs very slowly in color mode on Suns with less then 16 megabytes
of main memory.
.LP
When the SELECT REGION command is used on a Sun 3/160 with a Graphic processor
board there is some garbage left on the display, but it is not actually
left in the drawing area. If you press the RIGHT mouse button while on
the frame of the window and select "refresh" the display will be corrected.
.SH Author
 Ray Kreisel
 Computer Science Department
 SUNY at Stony Brook
 Stony Brook NY 11794
.LP
 PLEASE send comments and bug reports to one of the following addresses:

 UUCP: {allegra, philabs, pyramid, research}!sbcs!rayk   
 ARPA-Internet: rayk@sbcs.sunysb.edu
 CSnet: rayk@suny-sb
 (If nobody is home at any of the above addresses try:
	S72QKRE@TOWSONVX.BITNET       )
.fi
.LP
"If I get home before daylight, I just might get some sleep tonight...."
.LP
Manual page revised by R. P. C. Rodgers, UCSF School of Pharmacy,
San Francisco, CA 94143 (rodgers@maxwell.mmwb.ucsf.edu)


