/*****************************************************************************
 * abbrev.c: Demonstrate the AbbrevMenuButton widget.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/AbbrevMenu.h>
#include <Xol/OblongButt.h>
#include <Xol/StaticText.h>
#include "libXs.h"

static Widget preview;
static char *us[] = { "Eastern", "Central", "Mountain", "Pacific" };

main(argc, argv)
  int     argc;
  char   *argv[];
{
  Widget  toplevel, con, abbrevmb, main_mp,
          buttons[XtNumber(us)], label;
  int i, j, n;
  Arg wargs[2];
  void menu_callback();

  toplevel = OlInitialize(argv[0], "Abbrev", NULL, 0, &argc, argv);
  con = XtCreateManagedWidget("control", controlAreaWidgetClass, 
                              toplevel, NULL, 0);
  /*
   * Create statictext widget.
   */
  n = 0;
  XtSetArg(wargs[n], XtNstring, "Time Zone:"); n++;
  label = XtCreateManagedWidget("TZ", staticTextWidgetClass,
                                con, wargs, n);
  /*
   * Create AbbrevMenuButton widget.
   */
  abbrevmb = XtCreateManagedWidget("abbrevmb", 
                                   abbrevMenuButtonWidgetClass,
                                   con, NULL, 0);
  n = 0;
  XtSetArg(wargs[n], XtNmenuPane, &main_mp); n++;
  XtGetValues(abbrevmb, wargs, n);
  /*
   * Create the statictext widget that will act as preview widget
   */
  n = 0;
  XtSetArg(wargs[n], XtNstring, "Eastern"); n++;
  preview = XtCreateManagedWidget("prev", staticTextWidgetClass,
                                  con, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XtNpreviewWidget, preview); n++;
  XtSetValues(abbrevmb, wargs, n);
  /*
   * Create menubutton widget.
   */
  for(i=0;i<XtNumber(us);i++) {
    buttons[i] = xs_create_button(main_mp, us[i], us[i]);
    XtAddCallback(buttons[i], XtNselect, menu_callback, us[i]);
  }

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
menu_callback(w, client_data, call_data)
  Widget w;
  XtPointer client_data, call_data;
{
  Arg warg[1];
 
  XtSetArg(warg[0], XtNstring, client_data);
  XtSetValues(preview, warg, 1);
}
