.ds xL AFUtillib \- C Language AF Utilities
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
.tm \\n%:\\$1:\\$2:\\$3
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de PN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH AF_comp_u 3 "Release 1" "AF Version 3" 
.SH NAME
\fBAF_comp_u, AF_comp_a\fP \- linear to ULAW and ALAW compression tables
.SH SYNTAX
\fB#include <AF/AFUtils.h>\fP
.LP
extern unsigned char \fBAF_comp_u\fP[];
.LP
extern unsigned char \fBAF_comp_a\fP[];
.SH DESCRIPTION
.PN AF_comp_u
and
.PN AF_comp_a
are precomputed tables you can link with your application.
Each
is indexed by the low 14 bits of a linear twos-complement
value in the range between -8192 and +8191.
.PN AF_comp_u
contains the corresponding U255 law encoding while
.PN AF_comp_a
contains the corresponding ALAW encoding.
.SH EXAMPLES
Typical usage is:
.LP
.Ds 0
.TA .5i 3i
.ta .5i 3i
unsigned char ulaw;
int input;
/* first limit the signal to the proper range */
if (input > 8191) input = 8191;
else if (input < -8181) input = -8191;
/* then translate */
ulaw = AF_comp_u[ input & 0x3fff ];
.De
.SH DIAGNOSTICS
If you index the table with an out-of-range linear value you
may cause a protection fault and crash your application.
.SH "SEE ALSO"
AF_exp_u(3), AF_exp_a(3), AF_cvt_u2s(3), AF_cvt_a2s(3),
AF_cvt_u2f(3), AF_cvt_a2f(3)
.br
AF(1)
.SH BUGS
If you encounter a \fBreproducible\fP bug, please 
submit a problem report to (af-bugs@crl.dec.com).
.SH COPYRIGHT
Copyright 1990-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Tom Levergood and Larry Stewart, 
Digital Cambridge Research Lab
