.TH AHOST 1 "AF"
.SH NAME
ahost - server access control program for AF
.SH SYNOPSIS
.B ahost
[[+-]hostname ...]
.SH DESCRIPTION
The \fIahost\fP program 
is used to add and delete hosts to the list of machines that are allowed
to make connections to the AF server.
This provides a rudimentary form of
privacy control and security.  It is only sufficient for a workstation 
(single user) environment, although it does limit the worst abuses.
.PP
The server initially allows network connections 
only from programs running on the same machine or from machines listed in
the file \fI/etc/AF*.hosts\fP (where * is the device number of the server).
The \fIahost\fP program is usually run either from a startup file
or interactively to give access to other users.
.PP
Hostnames that are followed by two colons (::) are used in checking DECnet
connections; all other hostnames are used for TCP/IP connections.
.SH OPTIONS
\fIAhost\fP accepts the following command line options described below.  For
security, the options that effect access control may only be run from the
same machine as the server.
.TP 8
.BI "\[\+\]" "hostname"
The given \fIhostname\fP (the plus sign is optional)
is added to the list of machines that are allowed to
connect to the AF server.
.TP 8
.BI \- "hostname"
The given \fIhostname\fP is removed from the list of machines that are allowed
to connect to the server.  Existing connections are not broken, but new
connection attempts will be denied.
Note that the current machine is allowed to be removed; however, further
connections (including attempts to add it back) will not be permitted.
There is currently no way to break all existing connections.
.TP 8
.B \+
Access is granted to everyone, even if they aren't on the list of allowed hosts
(i.e. access control is turned off).
.TP 8
.B \-
Access is restricted to only those machines on the list of allowed hosts
(i.e. access control is turned on).
.TP 8
.I nothing
If no command line arguments are given, the list of hosts that are allowed
to connect is printed on the standard output along with a message indicating
whether or not access control is currently enabled.  This is the only
option that
may be used from machines other than the one on which the server is
running.
.SH FILES
/etc/AF*.hosts
.SH "SEE ALSO"
AF(1)
.SH ENVIRONMENT
.TP 8
.B AUDIOFILE
to get the default host and server to use.
.SH BUGS
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
Copyright 1991-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Bob Scheifler, MIT Laboratory for Computer Science,
.br
Jim Gettys, MIT Project Athena (DEC),
.br
Win Treese, Cambridge Research Lab, Digital Equipment Corporation.
