char hypxver[] = "@(#)hypho.c	1.1";		/* SCCS */

#include <stdio.h>
#include "define.h"
#include "extern.h"
 
/* Hyphenation routines and tables */
 
Hypho(LNc1,LNe1,LNs)
short *LNc1,*LNe1,*LNs;
{
	short i,j,k,c,s;
	short Nc1,Ne1,Pad,Ohcflg,Fudgeit;

	if( Hy<=0 ) return;
	Nc1 = *LNc1;
	Ne1 = *LNe1;
	Pad = Ll-Un-Ne1;
	if( Pad<0 ) { Pad=Ll-Un; Nc1=Ne1=0; } /* one-word line */
	for(i=Nc1+1;;i++) { c = Char[i];          /* find beginning of word */
		if( !Lquote(c) && !SpTab(c) ) break;
		Pad--; 
	}
	if( Pad < 3 ) return;
 
	Ohcflg = false;
	for(j=i;;j++) { c = Char[j]&Ulmask;   /* find end of word */
		if( c==Ohc||c=='-' ) Ohcflg = true;
		else if(!Alpha(c)) break;
	}
	for(k=j;;k++) { c = Char[k]&Ulmask;
		if( c==Ohc||c=='-' ) Ohcflg = true;
		else if( SpTab(c) ) break;
		else if( Width[c] <= 0 ) return;
	}
	if( Ohcflg ) j = k;
	if( j-i < 4 ) return;
 
	Fudgeit = 0;
	s = (Hy==1||Ohcflg)?
		Hyph1(Char+i-1,j-i,Pad-1,&Fudgeit): 
		Hyph2(Char+i-1,j-i,Pad-1);
	if( s < 2 ) return;
	if( (Char[i+s]&Ulmask) != '-' ) {
		for( j = Nc; j>=i+s; j-- ) Char[j+1] = Char[j];
		Nc++; Char[i+s] = '-';
	}
	if( (Char[Nc1+1]&Ulmask)==' ' ) *LNs = *LNs+1;
	*LNe1 = Ne1+(i+s-Nc1-Fudgeit);
	*LNc1 = i+s;
}
 
Hyph1(Word,Len,Room,Lfudge)
short *Word,*Lfudge;
short Len,Room;
{
	short i = 1, j = 0, s = 0, t = 0, c;

	while( j<=Room && i<=Len ) {
		c = Word[i]&Ulmask;
		if( c==Ohc || c=='-'&&Syllables(Word+i) )
			{ s=i-1; t=j; }
		i++; j = j+(c==Ohc?0:1);
	}
	if( Word[s+1]==Ohc && (Word[s]&Ulmask)=='-' ) { s--; t--; }
	if( t<=0 ) return(0);
	Word[s+1] = '-';
	*Lfudge = s-t;
	return(s);
}
 
Syllables(Word)
short *Word;
{
	short c,d,i;

	for( d = -1; d<=1; d += 2 ) {
		i = d;
		while( d<0 && (Word[i]&Ulmask)=='-' ) i = i-1;   /* skip over dash (--) */
		for(;;) { c = Word[i];
			if( Vowel(c) ) break;
			if(!Alpha(c)) return(false);
			i = i+d;
		}
	}
	return(true);
}
 
char Digram[28][28] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,
	0,0,1,1,1,0,1,1,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,0,0,1,0,0,1,1,0,1,1,0,1,1,0,1,1,1,0,0,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,0,1,1,0,1,1,1,0,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,
	0,0,1,1,1,0,1,1,1,0,1,1,0,1,1,0,1,1,0,1,0,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,0,1,0,0,1,1,1,0,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,0,0,1,1,1,0,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,1,0,1,0,1,1,1,0,1,1,1,0,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,0,1,0,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,
	0,0,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,1,1,0,1,1,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,
	0,0,1,1,0,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,
	0,0,1,0,1,0,1,1,0,0,1,0,1,1,0,0,0,0,1,1,0,0,1,0,1,0,1,1,
	0,0,1,1,1,0,1,1,0,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,0,1,1,
	0,0,0,0,0,0,0,0,1,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,
	0,0,1,1,1,0,1,1,0,0,1,1,1,1,1,0,1,1,0,0,1,0,1,1,1,1,1,1,
	0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
	0,0,1,1,1,0,1,1,1,0,1,1,0,0,0,0,0,1,0,0,0,0,1,1,1,1,1,1,
	0,0,1,1,1,0,1,1,1,0,1,1,1,1,1,0,1,1,1,1,1,0,1,1,1,0,1,1,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1 };
 
Hyph2(Word,Len,Room)
short *Word;
short Len,Room;
{
	short i,s,Smax,c,d;

	i = Len;
	s = Suffix(Word,&i,Room);
	Smax = Min(Len-1,Room);
	if( (Word[s]&Ulmask)=='-' ) s=s-1;
	if( s<=Smax && Syllables(Word+s+1) ) return(s);
	do { while( i>2 && !Vowel(Word[i]) ) i = i-1;
		d = Word[i]&Ulmask;
		if( Hp ) d = Lcase[d];
		while( i>2 ) {
			c = Word[i-1]&Ulmask;
			if( Hp ) c = Lcase[c];
			if( Digram[Indx[c]][Indx[d]] ) break;
			d = c;
			i--;
		}
		i--;
		if( i<=Smax&&(Hy>=3||Indx[d]==27)&&Syllables(Word+i+1) ) return(i);
	} while( i>2 );
	return(0);
}
 
char Suftab[64][4] = {
	000, 000, 000, 000,
	'b', 002, 004, 000,   /* 1: -b 2 4 */
	'a', 001, 003, 001,   /* 2: -ab(le) 1 3 x */
	'i', 001, 000, 001,   /* 3: -ib(le) 1 0 x */
	'd', 005, 006, 000,   /* 4: -d 5 6 */
	'e', 070, 000, 001,   /* 5: -e(d,r,st) 70 0 x */
	'e', 007, 023, 001,   /* 6: -e 7 23 x */
	'l', 010, 011, 000,   /* 7: -le 10 11 */
	'b', 002, 000, 000,   /* 10: -ble 2 0 */
	'r', 012, 014, 000,   /* 11: -re 12 14 */
	'u', 013, 000, 000,   /* 12: -ure 13 0 */
	't', 000, 000, 000,   /* 13: -ture 0 0 */
	'u', 015, 017, 000,   /* 14: -ue 15 17 */
	'g', 070, 016, 001,   /* 15: -gue 70 16 x */
	'q', 070, 000, 001,   /* 16: -que 70 0 x */
	'v', 020, 000, 000,   /* 17: -ve 20 0 */
	'i', 071, 000, 000,   /* 20: -i(ve,ian,ion,ious) 71 0 */
	's', 000, 022, 000,   /* 21: -s(ive,ian,ion,ious) 0 22 */
	't', 000, 000, 000,   /* 22: -t(ive,ian,ion,ious) 0 0 */
	'g', 024, 026, 000,   /* 23: -g 24 26 */
	'n', 025, 000, 000,   /* 24: -ng 25 0 */
	'i', 070, 000, 001,   /* 25: -ing 70 0 x */
	'l', 027, 033, 000,   /* 26: -l 27 33 */
	'a', 030, 031, 000,   /* 27: -al 30 31 */
	'i', 073, 000, 000,   /* 30: -ial 73 0 */
	'u', 032, 000, 000,   /* 31: -ul 32 0 */
	'f', 000, 000, 000,   /* 32: -ful 0 0 */
	'n', 034, 036, 000,   /* 33: -n 34 36 */
	'a', 020, 035, 000,   /* 34: -an 20 35 */
	'o', 020, 000, 000,   /* 35: -on 20 0 */
	'p', 037, 042, 000,   /* 36: -p 37 42 */
	'i', 040, 000, 000,   /* 37: -ip 40 0 */
	'h', 041, 000, 000,   /* 40: -hip 41 0 */
	's', 000, 000, 000,   /* 41: -ship 0 0 */
	'r', 005, 043, 000,   /* 42: -r 5 43 */
	's', 044, 052, 000,   /* 43: -s 44 52 */
	's', 045, 050, 000,   /* 44: -ss 45 50 */
	'e', 046, 000, 000,   /* 45: -ess 46 0 */
	'l', 000, 047, 000,   /* 46: -less 0 47 */
	'n', 000, 000, 000,   /* 47: -ness 0 0 */
	'u', 051, 000, 000,   /* 50: -us 51 0 */
	'o', 020, 000, 000,   /* 51: -ous 20 0 */
	't', 053, 066, 000,   /* 52: -t 53 66 */
	'n', 054, 065, 000,   /* 53: -nt 54 65 */
	'e', 055, 000, 000,   /* 54: -ent 55 0 */
	'c', 000, 056, 000,   /* 55: -cent 0 56 */
	'd', 000, 057, 000,   /* 56: -dent 0 57 */
	'g', 000, 060, 000,   /* 57: -gent 0 60 */
	'l', 000, 061, 000,   /* 60: -lent 0 61 */
	'm', 000, 062, 000,   /* 61: -ment 0 62 */
	'n', 000, 063, 000,   /* 62: -nent 0 63 */
	't', 000, 064, 000,   /* 63: -tent 0 64 */
	'v', 000, 000, 000,   /* 64: -vent 0 0 */
	's', 005, 000, 000,   /* 65: -st 5 0 */
	'y', 067, 000, 000,   /* 66: -y 67 0 */
	'l', 001, 000, 001,   /* 67: -ly 1 0 x */
	000, 000, 000, 000,   /* 70: 0 0 0 */
	'c', 000, 072, 000,   /* 71: -c(ive,ian,ion,ious) 0 72 */
	'g', 000, 021, 000,   /* 72: -g(ive,ian,ion,ious) 0 21 */
	'c', 000, 074, 000,   /* 73: -cial 0 74 */
	'd', 000, 075, 000,   /* 74: -dial 0 75 */
	'm', 000, 076, 000,   /* 75: -mial 0 76 */
	'n', 000, 077, 000,   /* 76: -nial 0 77 */
	't', 000, 000, 000 }; /* 77: -tial 0 0 */
 
Suffix(Word,LvLen,Room)
short *Word,*LvLen;
short Room;
{
	short Index=1,s,t,Bfield,c;

	s = t = *LvLen;
	if( Lcase[Word[t]&Ulmask]=='s'
	 && Lcase[Word[t-1]&Ulmask]!='s'
	 && Lcase[Word[t-1]&Ulmask]!='u' ) t = t-1;
	while( t > 2 ) {
		c = Word[t]&Ulmask;
		if( Hp ) c = Lcase[c];
		while( Index>0 && c>Suftab[Index][0] )
			Index = Suftab[Index][2];
		if( c!= Suftab[Index][0] ) break;
		Bfield = Suftab[Index][1];
		t = t-1;
		if( Bfield==0 ) {
			Index=1; *LvLen = s = t;
			if( s<=Room ) break;
		}
		else {
			if( Suftab[Index][3] ) *LvLen = t;
			Index = Bfield;
		}
	}
	return(s);
}
