/* Define constants and macros */
/* SCCS @(#)define.h	1.1 */
 
/* Start of system dependent definitions */
 

#ifdef unix
#define MACROPATH "/usr/lib/macros/sroff."
#define BYTE 8
#define fputr(ARG1,ARG2,ARG3)	fputs(ARG1,ARG3); putc('\n',ARG3)
#define strbrk	strcspn
#define memset(ARG1,ARG2,ARG3)	 \
 for(scr1=0;scr1<ARG3;scr1++)*(ARG1+scr1)=ARG2;
#define memcpy(ARG1,ARG2,ARG3) \
 for(scr1=0;scr1<ARG3;scr1++)*(ARG1+scr1) = *(ARG2+scr1);
#endif
#ifdef gcos			/* running on GCOS */
#define LinePr 1	/* There is a printer on this system */
#define MACROPATH "CC/SROFF/"
#define BYTE 9 /*GCOS*/
#endif

/* End of system dependent definitions */
 
#define Bfbit 01000
#define Bfbsize 80
#define Bfmask 0777
#define Divsize 4000
#define Eof 000
#define Form 0014
#define Fsize 4000
#define Maxdef 2000	/* Longest macro */
#define Maxline 180
#define Mcsize 12000
#define Moreregs 20	/* growth rate for reglist */
#define Namewidth 8	/* max width of register names */
#define Nhead 10	/* max no. of heads and feet */
#define Nmerge 10	/* max no. of merge patterns */
#define Nwidth 36	/* width of widest number */
#define Ohc 0375
#define Pagemark 0374
#define Param 0376	/* macro argument escape character */
#define Prefix 033	/* 033 for ASCII, 047 for EBCDIC */
#define Printer 202
#define Quotemark 0373
#define Rqmax 30	/* request buffer size */
#define Skip 0372
#define Slop 10
#define Tabpad (' '+128)	/* Pad char to replace tabs */
#define Terminal 37
#define Ulbit 00400
#define Ulbsize 80
#define Ulmask 0377
#define Wbufsize 256
#define false 0
#define true 1
#define infile Callstack->Infile
#define lit(a,b) ('a'<<BYTE|'b')
#define scr0 scr[0]
#define scr1 scr[1]
#define scr2 scr[2]
#define scr3 scr[3]
#define scr4 scr[4]
#define scr5 scr[5]
 
struct header {
	short Hi;	/* Heading indent */
	short Hl;	/* Heading line length */
	short Hc;	/* Heading char count */
	char Ht[Maxline+1];	/* Heading text */
	};
 
struct macrodef {
	short Dsize;	/* size of this vector */
	short Ucount;	/* use count */
	char Dstring[1]; /* definition string */
	};
 
struct regvec {	/* register definition */
	/* struct regvec *Nextreg; */
	char Name[Namewidth];
	short Value;	/* value for numeric register */
	struct macrodef *Rdef;	/* Text register definition pointer */
	char Style;	/* '1','i','I','a','A' for numeric, 0 for text */
	char Minwidth;	/* minimum width for style '1' */
	};

struct diversion {
	struct diversion *Nextdiv;
	char Lab[Namewidth];
	short Nca;
	short Nla;
	short Ncol;
	char *Fna;
	char Dstring[Divsize+1];
	};
 
struct inputsource {	/* Macro expansion or source file input */
	FILE *Infile;	/* input file; 0 for input from macro */
	struct inputsource *Nextsrc;
	struct macrodef *Mdef;	/* Macro definition pointer */
	short Curch;	/* Current character no. */
	short Argch;	/* Nonzero if expanding arg */
	char String;	/* true if invoked by insertion char */
	char Quoted;	/* true if arg was quoted */
	char Argq;	/* arg. quote char. in effect at call */
	char *Call;	/* Text of call */
	};

struct reglist {	/* Chain of registers */
	short namehash;
	struct regvec *regptr;
	};
 
#define NUM 001
#define LALPHA 002
#define UALPHA 004
#define ALPHA 006
#define VOWEL 010
#define LQUOTE 020
#define RQUOTE 040
#define QUOTE 060
#define BLANK 0100
#define SPEC 0200
#define Numeric(c) ( Attrib[(c)&Ulmask]&NUM )
#define Lalpha(c) ( Attrib[(c)&Ulmask]&LALPHA )
#define Ualpha(c) ( Attrib[(c)&Ulmask]&UALPHA )
#define Alpha(c) ( Attrib[(c)&Ulmask]&ALPHA )
#define Vowel(c) ( Attrib[(c)&Ulmask]&VOWEL )
#define Lquote(c) ( Attrib[(c)&Ulmask]&LQUOTE )
#define Rquote(c) ( Attrib[(c)&Ulmask]&RQUOTE )
#define Quote(c) ( Attrib[(c)&Ulmask]&QUOTE )
#define SpTab(c) (Attrib[(c)&Ulmask]&BLANK)
#define Special(c) (Attrib[(c)&Ulmask]&SPEC)

#define Break() SpReq(-1)
#define Labmatch(a,b) (!strncmp(a,b,Namewidth))
#define Labclear(a) memset(a,0,Namewidth)
#define Nextch(c)(Callstack==0?Eof:Callstack->Mdef==0?Readch(c):Expand())
#define Readch(c)((c=getc(infile))==EOF?Testchar(c):\
 c=='\n'?(++InLno,c):c)
#define Writeraw(c){if((scr2=c)<0372)if(Fn_Dv_Mc)Divert(scr2);\
 else if(Print){Writech(scr2);}}
#define Wwrite(c) Wbuf[Wcount++] = c
#define Write(c) {Pp += Width[(scr4=c)&Ulmask];\
 if((Wbuf[Wcount++]=scr4)=='\n' || Wcount>=Wbufsize) Wflush();}
#ifdef LinePr
#define LPLENGTH 132	/* line printer line length */
#define Writech(c) (*wrfn)(c, otfile) 
#else
#define Writech(c) putc(c, otfile) 
#define Fudge 0
#endif


	/* quantities that are replicated for footnotes */
struct Replicate {
	short _NRq;	/* no. of requests in Rqbuf */
	short *_Rqbuf;	/* Request buffer */
	short _Ad;	/* true means adjust right margin */
	short _Ce;	/* Center count */
	short *_Char;	/* Working text buffer */
	short _Fi;	/* true means fill output lines */
	char *_Fn;	/* End label for footnote */
	short _Un;	/* Undent to here */
	short _In;	/* Indent */
	short _Ll;	/* Line length */
	short _El;	/* Ll:El::Un:In */
	short _Ls;	/* Line spacing */
	short _Mc;	/* Count of unioned merge pattern */
	char **_Mg;	/* Vector of merge patterns */
	short _MgAll;	/* Flag for merging into empty lines */
	short _Nc;	/* Number of characters in Char */
	short _Seqno;	/* Input sequence number for current output line */
	char *_Tab;	/* string of tab settings */
	short _Dir;	/* direction of pad for right margin adjustment */
};

/* for replicated data: */
#define NRq Xtab._NRq
#define Rqbuf Xtab._Rqbuf
#define Ad Xtab._Ad
#define Ce Xtab._Ce
#define Char Xtab._Char
#define Fi Xtab._Fi
#define Fn Xtab._Fn
#define Un Xtab._Un
#define In Xtab._In
#define Ll Xtab._Ll
#define El Xtab._El
#define Ls Xtab._Ls
#define Mc Xtab._Mc
#define Mg Xtab._Mg
#define MgAll Xtab._MgAll
#define Nc Xtab._Nc
#define Seqno Xtab._Seqno
#define Tab Xtab._Tab
#define Dir Xtab._Dir

#define Bch Spch[0]	/* Backspace char */
#define Cc Spch[1]	/* Control char */
#define Hych Spch[2]	/* Hyphen char */
#define Ich Spch[3]	/* Insertion char */
#define Osch Spch[4]	/* Overstrike toggle */
#define Pc Spch[5]	/* Parameter char */
#define Qch Spch[6]	/* Quote char */
#define Tch Spch[7]	/* Tab char */
#define Ulch Spch[8]	/* Underline toggle */
#define NSpch 9
