	.even
/ "convert date from internal to ASCII" subroutine
/ input in r0
/ output in 8 bytes starting at address pointed to by
/    address after subroutine jump to "edate"
/
edate:
	mov	r1,-(sp)		/save regs
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
	mov	(r5)+,r4		/inc r5 over address arg. also
	mov	r0,r2
	mov	r0,r3
	tst	r0
	beq	7f			/branch if null date
	bic	$177000,r3		/r3 now contains Julian day
	asr	r2
	swab	r2
	bic	$177600,r2		/r2 now contains year
	cmp	$99.,r2
	blo	9f			/branch if year range error
	bit	$3,r2			/test for leap year
	bne	1f			/branch if not leap year
	cmp	$366.,r3
	blo	9f			/branch if Julian day too large
	mov	$1,months+12.		/set flag to indicate leap year
	br	2f
1:
	cmp	$365.,r3
	blo	9f			/branch if Julian day too large
	clr	months+12.		/set flag to indicate non-leap yr
2:
	clr	r1
2:
	movb	months(r1),r0
	cmp	r1,$1			/is month Feb.?
	bne	4f			/branch if not
	add	months+12.,r0		/add 0 or 1 to Feb. day count
4:
	cmp	r0,r3
	bge	3f
	sub	r0,r3
	inc	r1
	br	2b
3:					/at this pt.
					/r1 = month - 1
					/r2 = year
					/r3 = day of month
	inc	r1
	clr	r0
	mov	r1,mq
	mov	$10.,div
	mov	ac,r1
	mov	mq,r0
	add	$60,r0
	add	$60,r1
	swab	r1
	bis	r1,r0
	mov	r0,(r4)+		/move 2 month digits to output
	mov	r3,r1
	clr	r0
	mov	r1,mq
	mov	$10.,div
	mov	ac,r1
	mov	mq,r0
	add	$60,r0
	add	$60,r1
	swab	r0
	bis	$"/\0,r0
	mov	r0,(r4)+		/move "/d" to output
					/where "d" = 1st month digit
	bis	$"\0/,r1
	mov	r1,(r4)+		/move "d/" to output
					/where "d" is 2nd month digit
	mov	r2,r1
	clr	r0
	mov	r1,mq
	mov	$10.,div
	mov	ac,r1
	mov	mq,r0
	add	$60,r0
	add	$60,r1
	swab	r1
	bis	r1,r0
	mov	r0,(r4)			/move 2 yr digits to output
	br	8f
7:
	clr	(r4)+
	clr	(r4)+
	clr	(r4)+
	clr	(r4)
8:
	mov	(sp)+,r4
	mov	(sp)+,r3		/restore regs
	mov	(sp)+,r2
	mov	(sp)+,r1
	rts	r5			/return
9:					/error leg
	mov	$"BA,(r4)+
	mov	$"D ,(r4)+
	mov	$"DA,(r4)+
	mov	$"TE,(r4)
	br	8b
months:
	.byte	31.,28.,31.,30.,31.,30.,31.,31.,30.,31.,30.,31.
	.=.+2				/reserved for leap year flag
