/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetPrint.c	1.1 84/06/12
*/

/*
**	Control the output of the Print routines.
*/

#include	<setjmp.h>

#include	"global.h"
#include	"state.h"

#include	"node.h"
#include	"route.h"


/*
**	Structure for remembering restricted print items.
*/

typedef struct PrintEl *	PE_p;
typedef struct PrintEl
{
	PE_p	p_next;
	char	p_name[NODE_NAME_SIZE+1];
}
		PrintEl;

PE_p		PrintList;

extern jmp_buf	NameErrJmp;


void
PrintOnly(namep)
	char *		namep;
{
	register PE_p	pp;

	pp = Talloc(PrintEl);

	pp->p_next = PrintList;
	PrintList = pp;

	(void)strncpy(pp->p_name, namep, NODE_NAME_SIZE);
}



States
SetPrint()
{
	register PE_p	pp;
	register Entry*	np;
	register char *	cp;
	register bool	found = false;

	if ( (pp = PrintList) == (PE_p)0 )
		return S_FOUND;			/* Match all nodes */

	if ( setjmp(NameErrJmp) == 0 )
	do
	{
		/*
		**	Convolutions are to avoid calculating routefile
		**	if possible.
		*/

		if
		(
			(np = Lookup(pp->p_name, NodeHash)) != (Entry *)0
			||
			(
				(RouteBase != NULLSTR || (MakeRoute(), 1))
				&&
				(cp = FindAlias(pp->p_name)) != NULLSTR
				&&
				(np = Lookup(cp, NodeHash)) != (Entry *)0
			)
		)
		{
			found = true;
			np->e_states |= S_PRINT;
		}
	}
	while
		( (pp = pp->p_next) != (PE_p)0 );

	return found ? S_PRINT : (States)0;
}
