/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)PrintDomains.c	1.4 84/10/02
*/

/*
**	Print domain tables in readable format.
*/

#include	<stdio.h>

#include	"global.h"
#include	"state.h"

#include	"route.h"


#define	Fprintf	(void)fprintf



void
PrintDomains(fd)
	register FILE *	fd;
{
	register int	i;
	register int	j;
	register int	k;
	register char *	cp;
	static char *	na = "* N/A *";

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
			return;

	Fprintf
	(
		fd,
		"Domain tables for node \"%s\":-\n",
		RT_NODE(NodeCount-1)->ne_name
	);

	i = fprintf
	    (
		fd,
		"\n%-*s%-*s%s\n",
		NODE_NAME_SIZE+9, "Domain       Hierarchy",
		2*NODE_NAME_SIZE+1, "Reached via",
		"[Handler]"
	    ) - 1;

#	if	SPRF_SIZE != 1
	i = 79;
#	endif	SPRF_SIZE != 1

	while ( --i > 0 )
		putc('_', fd);

	for ( i = 0, k = 0 ; i < DomainCount ; i++ )
	{
		register int	shortest;
		char		hier[12];

		if ( (shortest = RT_DOMAIN(i)->de_shortest) == LINK_N_A )
			cp = na;
		else
		{
			if ( shortest >= LinkCount )
				cp = RT_NODE(shortest)->ne_name;
			else
				cp = RT_NODE(RT_LINK(shortest)->le_index)->ne_name;
		}

		if ( (j = RT_DOMAIN(i)->de_hierarchy) == LINK_N_A )
			hier[0] = '\0';
		else
			(void)sprintf(hier, "%d", j);

		Fprintf
		(
			fd,
			"\n%-*s %-7s%s",
			NODE_NAME_SIZE+1, RT_DOMAIN(i)->de_name,
			hier,
			cp
		);

		for ( j = 0 ; j < LinkCount ; j++, k++ )
			if
			(
				j != shortest
				&&
				(DomForwTable[k/8] & (1<<(k%8)))
			)
				Fprintf(fd, ",%s", RT_NODE(RT_LINK(j)->le_index)->ne_name);

		if ( (j = RT_DOMAIN(i)->de_handler) != 0 )
			Fprintf(fd, "  [%s]", &Strings[j]);
	}

	i = fprintf
	    (
		fd,
		"\n\n%-*s%-*s%s\n",
		NODE_NAME_SIZE+1, "Node",
		NODE_NAME_SIZE+1, "Primary Domain",
		"Other Domains"
	    ) - 2;

#	if	SPRF_SIZE != 1
	i = 79;
#	endif	SPRF_SIZE != 1

	while ( --i > 0 )
		putc('_', fd);

	for ( i = 0, j = 0 ; i < NodeCount ; i++ )
	{
		register int	primary;
		bool		first = true;

		if ( (primary = RT_NODE(i)->ne_primary) == LINK_N_A )
			cp = na;
		else
			cp = RT_DOMAIN(primary)->de_name;

		Fprintf
		(
			fd,
			"\n%-*s%-*s",
			NODE_NAME_SIZE+1, RT_NODE(i)->ne_name,
			NODE_NAME_SIZE+1, cp
		);

		for ( k = 0 ; k < DomainCount ; k++, j++ )
			if ( k != primary && (MemberTable[j/8] & (1<<(j%8))) )
			{
				if ( !first )
					putc(',', fd);
				else
					first = false;

				Fprintf(fd, "%s", RT_DOMAIN(k)->de_name);
			}
	}

	putc('\n', fd);
}
