/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)PrintAlias.c	1.1 84/06/12
*/

/*
**	Print aliases in readable format.
*/

#include	<stdio.h>

#include	"global.h"
#include	"state.h"

#include	"route.h"


#define	Fprintf	(void)fprintf



void
PrintAlias(fd)
	register FILE *	fd;
{
	register int	i;

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
			return;

	Fprintf
	(
		fd,
		"Aliases at node \"%s\"\n",
		RT_NODE(NodeCount-1)->ne_name
	);

	i = fprintf(fd, "\n%-*s%-*s\n", NODE_NAME_SIZE+1, "Alias", NODE_NAME_SIZE+1, "Value") - 1;

#	if	SPRF_SIZE != 1
	i = 79;
#	endif	SPRF_SIZE != 1

	while ( --i > 0 )
		putc('_', fd);

	for ( i = 0 ; i < AliasCount ; i++ )
		Fprintf
		(
			fd,
			"\n%-*s%s",
			NODE_NAME_SIZE+1,
			RT_ALIAS(i)->ae_name,
			&Strings[RT_ALIAS(i)->ae_value]
		);

	putc('\n', fd);
}
