/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)NodeinPrim.c	1.2 84/06/22
*/

/*
**	Given node index, return true if node is in our primary domain,
**	(or there is no primary domain).
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


bool
NodeinPrim(index)
	int		index;
{
	register int	i;

	if ( index >= (NodeCount-1) )
		return true;
	
	if
	(
		RT_NODE(index)->ne_primary == LINK_N_A
		||
		(i = RT_NODE(NodeCount-1)->ne_primary) == LINK_N_A
	)
		return true;

	i += index * DomainCount;

	if ( MemberTable[i/8] & (1<<(i%8)) )
		return true;

	return false;
}
