/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)DomInPrim.c	1.1 84/06/20
*/

/*
**	Given domain index, return name of domain if index is of a domain
**	that is inside our primary domain.
**
**	Return NULLSTR otherwise.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


char *
DomInPrim(index)
	int		index;
{
	register int	prim;

	if ( index >= DomainCount )
		return NULLSTR;
	
	if ( (prim = RT_NODE(NodeCount-1)->ne_primary) == LINK_N_A )
		return NULLSTR;

	if ( RT_DOMAIN(index)->de_hierarchy >= RT_DOMAIN(prim)->de_hierarchy )
		return NULLSTR;

	return RT_DOMAIN(index)->de_name;
}
