/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "%W% %E%";

/*
**	Startup for node-node daemon
*/

#define	FILE_CONTROL
#define	STDIO
#define	TIMES
#define	NEED_HZ

#include	"global.h"
#include	"command.h"
#include	"debug.h"

#include	"Passwd.h"
#include	"spool.h"

#include	<signal.h>
#include	<errno.h>

#include	"Stream.h"
#include	"driver.h"
#undef	Extern
#define	Extern
#include	"daemon.h"


#if	DEBUG >= 1
char *	Usage	= "[-[B][C][F][I][N][P[<level>]][R][T[<level>]][U][X]]\n\
	[-b<buffers>] [-c<channels>] [-d<device>] [-e<tracefile>]\n\
	[-f<first channel>] [-h<homenode>] [-i<intra-packet delay>]\n\
	[-m<multipath>] [-p<devspeed>] [-q<min speed>] [-s<speed>]\n\
	[-t<directory>] [-z<packet size>] linkdir";
#endif

/*
**	Filenames that must be set up
*/

char *	BadHandler	= BADHANDLER;		/* Name of bad message handler process */
char *	Console		= CONSOLE;		/* Network error device */
char *	Daemondir;				/* Directory in Spooldir for daemon command files */
char *	Device;					/* Device special file for link */
char *	Logfile		= LOGFILE;		/* Name of logfile */
char *	MessageHandler	= RECEIVER;		/* Name of message handler process */
char *	NewstateHandler	= NEWSTATEHANDLER;	/* Name of state change process */
char *	Spooldir	= SPOOLDIR();		/* Name of spool directory where network directories are kept */
char *	Statusfile	= STATUSFILE;		/* File name for state info. */
char	Template[STREAMIDZ+1];			/* Last component of node-node command file name */
char *	Workdir		= WORKDIR();		/* Directory for temporary files */

/*
**	Flags that can be set on invokation.
**
**	(Others declared in "daemon.h".)
*/

int	DevSpeed;				/* Magic number for device speed setting */
int	Fstream;				/* First channel in use */
bool	IgnoreOldPid;				/* Ignore any pid in old state file */
int	IntraPktDelay;				/* Maximum delay inside packets */
int	MinSpeed;				/* Minimum speed prepared to accept */
int	Nbufs		= 3;			/* Window size */
bool	NoFork;					/* Don't fork! (used by NNshell) */
int	Nstreams	= NSTREAMS;		/* Number of channels in use */
int	PktZ;					/* Max. size of packet on link */
int	Speed		= 960/4;		/* Minimum effective bytes per second for link */
int	Traceflag;				/* Global tracing control */
bool	UseCrc		= true;			/* Use CRC error detection */
bool	UseFd1;					/* Virtual circuit established on fd 1 */
bool	XonXoff;				/* Enable XON/XOFF flow control */

/*
**	Miscellaneous
*/

bool	Pausing;
bool	Starting	= true;
char *	CantOpen	= "cannot open \"%s\"";
char *	FinishReason	= "FINISHED";

#if	DEBUG >= 1
extern int	Ptraceflag;
extern FILE *	PtraceFd;
#endif	DEBUG

void	CpuStats(), Pprintstats(), Update(), args(), driver(), finish(),
	mesg(), stats(), usage();
int	changetrace(), terminate();
bool	open_remote();




int
main(argc, argv)
	int	argc;
	char *	argv[];
{
	int	pid;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	args(argc, argv);

	if ( LinkDir == NULLSTR )
	{
		usage("no target specified");
		return 1;
	}

	if ( HomeNode == NULLSTR )
		HomeNode = NodeName();

	(void)sprintf(Template, "%c%-*.*s", SMALL_ID, sizeof Template - 2, sizeof Template - 2, Name);

	if ( Daemondir == NULLSTR )
		Daemondir = LinkDir;

	if
	(
		chdir(Spooldir) == SYSERROR
		||
		chdir(Daemondir) == SYSERROR
	)
	{
		Syserror("%s%s inaccessible", Spooldir, Daemondir);
		return 1;
	}

	if ( (argv = (char **)ReadFile(NNDPARAMS)) != (char **)0 )
	{
		VarArgs	va;

		FIRSTARG(&va) = Name;
		SplitArg(&va, (char *)argv);
		args(NARGS(&va), &ARG(&va, 0));
		free((char *)argv);
	}

#	ifdef	MULTIPATH
	if ( MultiPath != NULLSTR && chdir(MultiPath) == SYSERROR )
	{
		Syserror("sub-dir \"%s\" inaccessible", MultiPath);
		return 1;
	}
#	endif	MULTIPATH

	if ( BatchMode )
		UseFd1 = true;
	else
	{
		if ( Device == NULLSTR )
			Device = concat(DEVNET(), LinkDir, MultiPath, NULLSTR);
		else
		if ( Device[0] == '\0' )
			UseFd1 = true;
	}

	(void)umask(022);

#	ifdef	NICEDAEMON
	/*
	**	This won't work if not root,
	**	so other programs that "setuid(ACSNETUID)" must nice up first.
	*/

	if ( geteuid() == 0 )
		(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	(void)setgid(ACSNETGID);
	(void)setuid(ACSNETUID);

	Pid = getpid();

	/*
	**	Call ReadState() to initialise the statefile.
	*/

	if ( (pid = ReadState()) > 0 && pid != Pid && !IgnoreOldPid )
	{
		if ( kill(pid, SIG0) != SYSERROR )
		{
			Error("daemon for %s already active", LinkDir);
			return 1;
		}
	}

	/*
	**	Close all the std open fds.
	*/

	(void)fclose(stdin);

	if ( !UseFd1 )
	{
		if ( access(Device, 06) == SYSERROR )
		{
			Syserror(CantOpen, Device);
			return 1;
		}

		(void)fclose(stdout);
	}

	if ( freopen(Logfile, "a", stderr) == NULL )
	{
		if ( freopen(Console, "w", stderr) != NULL )
			Syserror(CantOpen, Logfile);

		return 1;
	}

#	if	BSD4 >= 2
	setlinebuf(stderr);
#	endif	BSD4 >= 2

#	if	FCNTL == 1 && O_APPEND != 0
	(void)fcntl
	(
		fileno(stderr),
		F_SETFL,
		fcntl(fileno(stderr), F_GETFL, 0) | O_APPEND
	);
#	endif

	/*
	**	Fork, if necessary.
	*/

#	if	PGRP == 1
	if ( Pid != getpgrp() && !NoFork )
#	else	PGRP
	if ( !NoFork )
#	endif	PGRP
		switch ( fork() )
		{
		default:
			return 0;	/* Parent returns */
		
		case 0:
			Pid = getpid();	/* Child continues */
#			if	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
			(void)cleartty();
#			else	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
#			if	PGRP == 1
			(void)setpgrp();
#			endif	PGRP
#			endif	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
			break;

		case SYSERROR:
			Syserror("cannot fork");
			return 1;
		}

	NNstate.procid = Pid;
	LastTime = time((long *)0);
	NNstate.starttime = LastTime;
	NNstate.lasttime = LastTime;
	NNstate.activetime = 0;

#	if	KILL_0 != 1 && SIG0 != SIGINT
	(void)signal(SIG0, SIG_IGN);	/* To allow interrogation for existence */
#	endif	KILL_0 != 1 && SIG0 != SIGINT

	(void)signal(SIGHUP, BatchMode?terminate:SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);
	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGTERM, terminate);

#	if	DEBUG >= 1
	(void)signal(SIGTRCON, changetrace);
	(void)signal(SIGTRCOFF, changetrace);
#	else	DEBUG >= 1
	(void)signal(SIGTRCON, SIG_IGN);
	(void)signal(SIGTRCOFF, SIG_IGN);
#	endif	DEBUG >= 1

	mesg("STARTED");

	if ( UseFd1 )
		RemoteFd = 1;
	else
		RemoteFd = SYSERROR;

	if ( Cook )
		Write = RCwrite;
	else
		Write = write;

	Starting = false;

	driver();

	finish(0);

	return 0;
}



/*
**	Process arguments
*/

void
args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'B':
					BatchMode = true;
					continue;

				case 'C':
					Cook = true;
					continue;

				case 'F':
					NoFork = true;
					continue;

				case 'I':
					IgnoreOldPid = true;	
					continue;

				case 'N':
					NoAdjust = true;
					continue;

				case 'P':
#					if	DEBUG >= 1
					if ( (Ptraceflag = atoi(++*argv)) <= 0 )
						Ptraceflag = 1;
#					else	DEBUG
					++*argv;
#					endif	DEBUG
					break;

				case 'R':
					UseCrc = false;
					continue;

				case 'T':
					if ( (Traceflag = atoi(++*argv)) <= 0 )
						Traceflag = 1;
					break;

				case 'U':
					ContinuousUpdate = true;
					continue;

				case 'X':
					XonXoff = true;
					continue;

				case 'b':
					Nbufs = atoi(++*argv);
					break;

				case 'c':
					if
					(
						(Nstreams = atoi(++*argv)) <= 0
						||
						Nstreams > NSTREAMS
					)
					{
						usage("bad channel count %d", Nstreams);
						return;
					}
					break;

				case 'd':
					Device = ++*argv;
					goto break2;

				case 'e':
#					if	DEBUG >= 1
					if ( (TraceFd = fopen(++*argv, "w")) == NULL )
					{
						usage("can't open \"%s\" for trace output", *argv);
						return;
					}
					PtraceFd = TraceFd;
#					else	DEBUG
					++*argv;
#					endif	DEBUG
					break;

				case 'f':
					if
					(
						(Fstream = atoi(++*argv)) < 0
						||
						Fstream >= NSTREAMS
					)
					{
						usage("bad first channel request %d", Fstream);
						return;
					}
					break;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'i':
					if ( (IntraPktDelay = atoi(++*argv)) <= 0 )
					{
						usage("bad intra-packet delay %d", Nstreams);
						return;
					}
					break;

				case 'm':
#					ifdef	MULTIPATH
					MultiPath = ++*argv;
					goto break2;
#					else	MULTIPATH
					usage("multi-path option unavailable");
					return;
#					endif	MULTIPATH

				case 'p':
					if ( (DevSpeed = atoi(++*argv)) <= 0 )
					{
						usage("bad device speed %d", *argv);
						return;
					}
					break;

				case 'q':
					if ( (MinSpeed = atoi(++*argv)) <= 0 )
					{
						usage("bad minimum speed %d", *argv);
						return;
					}
					break;
					
				case 's':
					if ( (Speed = atoi(++*argv)) <= 0 )
					{
						usage("bad speed %d", *argv);
						return;
					}
					break;

				case 't':
					Daemondir = ++*argv;
					goto break2;

				case 'z':
					if ( (PktZ = atoi(++*argv)) <= 0 )
					{
						usage("bad packet size %d", *argv);
						return;
					}
					break;

				default:
					usage("unrecognised flag '%c'", c);
					return;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
			LinkDir = *argv;
	}

	if ( Fstream >= Nstreams )
		Nstreams += Fstream - Nstreams + 1;
}



/*
**	Open link to remote node
*/

bool
open_remote()
{
	register int	attempts = 0;

	Update(up_opening);

	if ( !UseFd1 && RemoteFd == SYSERROR )
		while ( (RemoteFd = open(Device, O_RDWR|O_EXCL)) == SYSERROR )
		{
			if ( ++attempts > 3 )
			{
				Syserror(CantOpen, Device);
				return false;
			}

			(void)sleep(10);
		}

	/*
	**	Put circuit in RAW mode.
	**	(For SYSTEM xx:- VMIN = max, VTIME = min.)
	*/

	DevSpeed = SetRaw(RemoteFd, DevSpeed, 0xff, 1, (bool)(XonXoff&&Cook));

	return true;
}



void
close_remote()
{
	if ( RemoteFd != SYSERROR )
	{
		(void)close(RemoteFd);
		RemoteFd = SYSERROR;
	}

#	if	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
	(void)cleartty();
#	endif	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
}




void
finish(error)
	int	error;
{
	static bool	finishing;

	(void)alarm(0);

	if ( finishing )
	{
		if ( !error )
			return;

		Fatal1("recursing in finish");
	}

	finishing = true;

	if ( !Starting && Pid == getpid() )
	{
		extern void	Pflush();

		Pflush();

		if ( error && !BatchMode )
		{
			register FILE *	fd;

			NewState(LINK_DOWN, true);

			close_remote();

			if ( (fd = fopen(Console, "w")) != NULL )
			{
				(void)fprintf
				(
					 fd
#					ifdef	MULTIPATH
					,"\r\n%s for \"%s\" %s%s%s/%s%s%s%s%d%s\r\n"
#					else	MULTIPATH
					,"\r\n%s for \"%s\" %s%s%s/%s%s%d%s\r\n"
#					endif	MULTIPATH
					,Name
					,LinkDir
					,"SYSTEM ERROR: please tail \""
					,Spooldir
					,Daemondir
#					ifdef	MULTIPATH
					,MultiPath!=NULLSTR?"/":""
					,MultiPath!=NULLSTR?MultiPath:""
#					endif	MULTIPATH
					,Logfile
					,"\" to find problem,\r\nfix it, then \"kill "
					,Pid
					,"\" to terminate the daemon"
				);

				(void)fclose(fd);
			}

			Update(up_error);
			stats("ERROR");

			Pausing = true;
			(void)pause();
		}
		else
		{
			Update(up_finish);
			stats(FinishReason);
		}

		DODEBUG(if(error)kill(Pid, SIGIOT));	/* Dump a core */
	}

	if ( Starting )
		(void)sleep(10);	/* Depress bad invokation loops */

	(void)exit(error);
}



/*
**	Print out statistics
*/

void
stats(string)
	char *	string;
{
	Time_t	elapsed;

	mesg(string);
#	if	NND_STATS
	if ( NNstate.starttime > 0 )
		elapsed = time((long *)0) - NNstate.starttime;
	else
		elapsed = 0;

	(void)fprintf
	(
		 stderr
		,"%ld bytes in %ld messages in %ld seconds,\naverage active transfer rate: %ld bytes/second,\noverall transfer rate: %ld bytes/second.\n"
		,NNstate.allbytes
		,NNstate.allmessages
		,elapsed
		,(NNstate.activetime>0)?NNstate.allbytes/NNstate.activetime:0L
		,(elapsed>0)?NNstate.allbytes/elapsed:0L
	);
#	if	PROTO_STATS
	Pprintstats(stderr);
#	endif	PROTO_STATS
	CpuStats();
	(void)fflush(stderr);
#	endif	NND_STATS
}



/*
**	Explain usage
*/

/*VARARGS1*/
void
usage(s, a1)
	char *	s;
	char *	a1;
{
	Mesg("bad arguments", s, a1);
#	if	DEBUG >= 1
	(void)fprintf(stderr, "\nUsage is \"%s %s\"\n", Name, Usage);
#	else	DEBUG
	putc('\n', stderr);
#	endif	DEBUG
	(void)sleep(10);	/* Depress bad invokation loops */
	exit(1);
}



/*
**	Start/Stop messages in logfile.
*/

void
mesg(s)
	char *	s;
{
	Mesg(LinkDir, "Vn=\"%s\" (pid=%d) %s\n", Version, Pid, s);
	(void)fflush(stderr);
}



/*
**	Catch system termination signal.
*/

int
terminate(sig)
	int	sig;
{
	(void)signal(sig, SIG_IGN);

	if ( !Pausing )
	{
		FinishReason = (sig==SIGHUP)?"HANGUP":"TERMINATED";
		finish(0);
	}

	Update(up_finish);
	exit(1);
}



/*
**	Close all files except 'stderr' for child process.
**
**	(Called from routines in "children.c".)
*/

void
closeall()
{
	register int	i;

	if ( Alarm )
	{
		ALARM_OFF();
		Warn("Alarm set at call to closeall()");
	}

	while ( fileno(stderr) != 2 )
	{
		(void)close(2);

		while ( (i = dup(fileno(stderr))) == SYSERROR )
			Syserror("Can't dup log file descriptor");

		fileno(stderr) = i;
	}

	(void)close(0);
	(void)open("/dev/null", O_RDWR);
	(void)close(1);
	(void)dup(0);

	for ( i = 3 ; close(i) != SYSERROR || i < 9 ; i++ );
		/* There can be up to 9 files open */

#	ifdef	NICEHANDLERS
#	ifdef	NICEDAEMON
	(void)nice(NICEHANDLERS-(NICEDAEMON));
#	else	NICEDAEMON
	(void)nice(NICEHANDLERS);
#	endif	NICEDAEMON
#	endif	NICEHANDLERS
}



/*
**	Print out system cpu stats.
*/

#if	BSD4 > 1 || (BSD4 == 1 && BSD4V == 'c')

#include <sys/time.h>
#include <sys/resource.h>

void
CpuStats()
{
	struct rusage dus;
	struct rusage cus;

	(void) getrusage(RUSAGE_SELF, &dus);
	(void) getrusage(RUSAGE_CHILDREN, &cus);

	(void)fprintf
	(
		stderr,
"Usages:    user + sys = tot  io(i+o)   pf(min+maj) nswp sigs cs(iv+v)\n"
/*
"Children: NNNNN NNNNN NNNNN NNNNN+NNNNN NNNNN+NNNNN NNN NNNN NNN+NNN\n"
*/
	);

	(void)fprintf
	(
		stderr,
		"Daemon:   %5ld %5ld %5ld %5ld+%-5ld %5ld+%-5ld %3ld %4ld %3ld+%ld\n",
		dus.ru_utime.tv_sec + (dus.ru_utime.tv_usec >= 500000),
		dus.ru_stime.tv_sec + (dus.ru_stime.tv_usec >= 500000),
		((dus.ru_utime.tv_sec + dus.ru_stime.tv_sec) * 10 + 5 +
		  ((dus.ru_utime.tv_usec + dus.ru_stime.tv_usec) / 100000)) /10,
		dus.ru_inblock,
		dus.ru_oublock,
		dus.ru_minflt,
		dus.ru_majflt,
		dus.ru_nswap,
		dus.ru_nsignals,
		dus.ru_nivcsw,
		dus.ru_nvcsw
	);

	(void)fprintf
	(
		stderr,
		"Children: %5ld %5ld %5ld %5ld+%-5ld %5ld+%-5ld %3ld %4ld %3ld+%ld\n",
		cus.ru_utime.tv_sec + (cus.ru_utime.tv_usec >= 500000),
		cus.ru_stime.tv_sec + (cus.ru_stime.tv_usec >= 500000),
		((cus.ru_utime.tv_sec + cus.ru_stime.tv_sec) * 10 + 5 +
		  ((cus.ru_utime.tv_usec + cus.ru_stime.tv_usec) / 100000)) /10,
		cus.ru_inblock,
		cus.ru_oublock,
		cus.ru_minflt,
		cus.ru_majflt,
		cus.ru_nswap,
		cus.ru_nsignals,
		cus.ru_nivcsw,
		cus.ru_nvcsw
	);

	(void)fprintf
	(
		stderr,
		"Totals:   %5ld %5ld %5ld %5ld+%-5ld %5ld+%-5ld %3ld %4ld %3ld+%ld\n",
				/* rounding here is sloppy but close */
		((cus.ru_utime.tv_sec + dus.ru_utime.tv_sec) * 10 + 5 +
		  ((cus.ru_utime.tv_usec + dus.ru_utime.tv_usec) / 100000)) /10,
		((cus.ru_stime.tv_sec + dus.ru_stime.tv_sec) * 10 + 5 +
		  ((cus.ru_stime.tv_usec + dus.ru_stime.tv_usec) / 100000)) /10,
		((cus.ru_utime.tv_sec + cus.ru_stime.tv_sec +
		  dus.ru_utime.tv_sec + dus.ru_stime.tv_sec) * 10 + 5 +
		  ((cus.ru_utime.tv_usec + cus.ru_stime.tv_usec +
		    dus.ru_utime.tv_usec + dus.ru_stime.tv_usec) / 100000)) /10,
		cus.ru_inblock + dus.ru_inblock,
		cus.ru_oublock + dus.ru_oublock,
		cus.ru_minflt + dus.ru_minflt,
		cus.ru_majflt + dus.ru_majflt,
		cus.ru_nswap + dus.ru_nswap,
		cus.ru_nsignals + dus.ru_nsignals,
		cus.ru_nivcsw + dus.ru_nivcsw,
		cus.ru_nvcsw + dus.ru_nvcsw
	);
}

#else	BSD4 ...

void
CpuStats()
{
	Timesbuf	tbuf;

	(void)times(&tbuf);

	(void)fprintf
	(
		 stderr,
		"Cpu secs: sys %ld, user %ld, child sys %ld, child user %ld. Total: %ld secs\n",
		(tbuf.tms_stime + HZ-1)/HZ,
		(tbuf.tms_utime + HZ-1)/HZ,
		(tbuf.tms_cstime + HZ-1)/HZ,
		(tbuf.tms_cutime + HZ-1)/HZ,
		(tbuf.tms_stime + tbuf.tms_utime + tbuf.tms_cstime + tbuf.tms_cutime + HZ-1)/HZ
	);
}
#endif	BSD4 ...



#if	DEBUG >= 1
int
changetrace(sig)
	int	sig;
{
	(void)signal(sig, changetrace);

	switch ( sig )
	{
	case SIGTRCON:
		Traceflag++;
		Ptraceflag++;
		mesg("TRACEON");
#		if	PROTO_STATS
		Pprintstats(stderr);
		(void)fflush(stderr);
#		endif	PROTO_STATS
		break;

	case SIGTRCOFF:
		Traceflag = 0;
		Ptraceflag = 0;
		mesg("TRACEOFF");
#		if	PROTO_STATS
		Pprintstats(stderr);
		(void)fflush(stderr);
#		endif	PROTO_STATS
	}
}
#endif	DEBUG >= 1


#if	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )

#include <sgtty.h>

cleartty()
{
	register fd;

	(void)setpgrp(0, 0);

	if ( (fd = open("/dev/tty", 0)) < 0 )
		return;

	(void)ioctl(fd, TIOCNOTTY, (char *)0);
	(void)close(fd);
}
#endif	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
