/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)in.c	1.3 84/11/06
*/

/*
**	Functions to handle temporary files for incoming messages.
*/

#include	"global.h"
#include	"command.h"
#include	"debug.h"

#include	"daemon.h"
#include	"Stream.h"
#include	"driver.h"
#include	"AQ.h"


/*
**	Make a temporary file into which to receive message,
**	send an SOM_ACCEPT.
*/

void
MakeTemp(chan)
	AQarg		chan;
{
	register Str_p	strp = &inStreams[(int)chan];

	Trace3(1, "MakeTemp for channel %d state %d", (int)chan, strp->str_state);

	if ( strp->str_state != STR_START )
		return;

	if ( strp->str_fname != NULLSTR )
		free(strp->str_fname);

	strp->str_fname = UniqueName
			  (
				 concat(Workdir, Template, NULLSTR)
				,strp->str_size
				,LastTime
			  );

	/*
	**	Save last component of work file name for possible recovery
	*/

	(void)strcpy(strp->str_recv.rh_id, strrchr(strp->str_fname, '/')+1);

	while ( (strp->str_fd = creat(strp->str_fname, 0600)) == SYSERROR )
		Syserror("cannot create %s", strp->str_fname);

	strp->str_posn = 0;

	SndSOMA((int)chan);

	Update(up_force);
}



/*
**	Receive stream data from a channel.
**	Called from Precv().
*/

void
recvData(chan, data, size)
	int		chan;
	char *		data;
	int		size;
{
	register Str_p	strp = &inStreams[chan];
	register int	s;

	Trace5(2, "recvData for channel %d state %d size %d posn %ld", chan, strp->str_state, size, strp->str_posn);

	if ( strp->str_state == STR_ACTIVE && (s = size) > 0 )
	{
		for(;;)
		{
			register int	n;

			if ( (n = write(strp->str_fd, data, s)) == s )
				break;

			if ( n == SYSERROR )
				Syserror("stream %d", chan);
			else
			{
				data += n;
				s -= n;
			}
		}

		inByteCount += size;

		if ( (strp->str_posn += size) > strp->str_size )
			Fatal4("chan %d bad posn %ld, size %ld", chan, strp->str_posn, strp->str_size);
	}
}
