/*
**	patterns and functions to call munnari from basser
**
**	SCCSID @(#)munnari.c	1.10 84/11/07
*/

#include	"global.h"

#include	"caller.h"
#include	"passwd.q"

/*
**	The following PASSWD stuff is imported from "passwd.q"
*/

#ifndef	CSIRO_PASSWD
#define	CSIRO_PASSWD	""
#endif
#ifndef	MUNNARI_PASSWD
#define	MUNNARI_PASSWD	""
#endif
#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif



extern struct patlist	*current;

char
	*callargs= CALLARGS,		/* optional args for call */
	*daemon1 = NNDAEMON,		/* standard daemon */
	*daemon2 = NN2DAEMON,		/* alternate protocol */
	*host	 = "basser",		/* connecting from basser */
	*target  = "munnari",		/* connecting to munnari */
	*csirorq = CSIRO_PASSWD,
	*hostflg = "-BCF",		/* cooked protocol over csironet */
	*passwd  = MUNNARI_PASSWD,
	*device  = "/dev/net/csironet3",
	*speed   = "9600";

int
	tcount	 = 0,	/* count of timeouts */
	ccount	 = 0,	/* count of CSIRONET login attempts */
	lcount	 = 0;	/* count of Unix login attempts */

int
	atcsironet(),
	eof(),
	gotlogin(),
	gotpasswd(),
	netlogin(),
	noshellfail(),
	start2(),
	started(),
	timeout(),
	tocsironet(),
	tomunnari(),
	tounixnet();

struct patlist	csironet[] =
{
	{ "UNRECOGNISED FIRST RECORD", atcsironet },
	{ "TERMINAL IS UNASSIGNED", atcsironet },
	{ "INVALID LOGIN REQUEST", atcsironet },
	{ "DISCONNECT SEEN FROM", atcsironet },
	{ "UNIX SERVICE", tounixnet },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0}
};

struct patlist unixnet[] =
{
	{ "[Ll]ogin:", netlogin },
	{ "dmtmelb.*->", tomunnari },
	{ "UNRECOGNISED FIRST RECORD", tocsironet },
	{ "TERMINAL IS UNASSIGNED", tocsironet },
	{ "INVALID LOGIN REQUEST", tocsironet },
	{ "DISCONNECT SEEN FROM", tocsironet },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{0, 0}
};

struct patlist atmunnari[] =
{
	{ "[Ll]ogin:", gotlogin },
	{ "^[Pp]assword", gotpasswd },
	{ STARTMSG, started},
	{ START2MSG, start2},
	{ "no shell", noshellfail },
	{ "UNRECOGNISED FIRST RECORD", tocsironet },
	{ "TERMINAL IS UNASSIGNED", tocsironet },
	{ "INVALID LOGIN REQUEST", tocsironet },
	{ "DISCONNECT SEEN FROM", tocsironet },
	{ TIMEOUT, timeout },
	{ EOFSTR, eof },
	{ 0, 0 }
};



args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					out(callargs);
					exit(1);
				}
			}
break2:			;
		}
		else
		{
			out("fail unexpected argument ");
			out(*argv);
			out(" in ");
			out(callargs);
			exit(1);
		}
	}
}



init(argc, argv)
	int	argc;
	char *	argv[];
{
	callargs = concat(SPOOLDIR(/), target, "/", callargs, NULLSTR);
	(void)readargs(callargs, args);
	out("open "); outend(device);
	out("speed "); outend(speed);
	outend("read");
	tocsironet();
}



tocsironet()
{
	tcount = 0;
	ccount = 0;
	outend("write T\004");
	state(csironet);
	getinput();
}



atcsironet()
{
	if (++ccount >= 5)
	{
		outend("fail CSIRONET down");
		exit(1);
	}
	out("write "); out(csirorq); outend("\r");
	getinput();
}



tounixnet()
{
	tcount = 0;
	lcount = 0;
	outend("write EI\004");	/* Disable remote echo */
	state(unixnet);
	getinput();
}



gotlogin()
{
	if (++lcount >= 7)
		outend("fail too many login attempts at dmtmelb");
	out("write "); out(host); outend("\r");
	getinput();
}



netlogin()
{
	if (++lcount >= 7)
		outend("fail too many login attempts at munnari");
	out("write :"); out(target); outend("\r");
	getinput();
}



tomunnari()
{
	tcount = 0;
	lcount = 0;
	state(atmunnari);
	getinput();
}



gotpasswd()
{
	out("write "); out(passwd); outend("\r");
	getinput();
}



started()
{
	out("daemon "); outend(daemon1);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}



start2()
{
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}



timeout()
{
	if (++tcount >= 3)
	{
		outend("fail timeout");
		exit(1);
	}

	if (current == csironet)
		outend("write T\004");
	else
		outend("write @\r");

	reset();
}



eof()
{
	outend("fail unexpected eof");
	exit(1);
}


noshellfail()
{
	outend("fail no shell");
	exit(1);
}
