/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)RCwrite.c	1.1 84/06/12
*/

/*
**	Write remote line with "cooked" bytes.
*/

#include	"global.h"
#include	"debug.h"

#include	"Channel.h"


char	magic_chars[] = "@#$~";
char	rep_char = '`';


int
RCwrite(fd, m, n)
	int		fd;
	char *		m;
	int		n;
{
	register int	r;
	register char *	dp;
	register char *	cp;
	register int	llen;
	register int	c;
	char		cbuf[sizeof(Packet)*2 + (sizeof(Packet)*2)/60 + 2];

	Trace2(2, "RCwrite \"%s\"", ExpandString(m, n));

	for ( r = n, llen = 0, cp = cbuf, dp = m ; r-- > 0 ; )
	{
		if (llen >= 60)
		{
			*cp++ = '\r';
			llen = 0;
		}

		c = (*dp++) & 0xFF;

		if
		(
			r >= 3
			&&
			(dp[0] & 0xFF) == c
			&& 
			(dp[1] & 0xFF) == c
		)
		{
			register int	repcnt = 1;

			while ( (*dp & 0xFF) == c )
			{
				repcnt++;
				dp++;
				if ( --r <= 0 || repcnt == 077 )
					break;
			}

			if ( (repcnt & 0x30) != 0x30 )
				repcnt |= 0x40;

			*cp++ = rep_char;
			*cp++ = repcnt;
		}

		if
		(
			c >= ' '
			&&
			c <= '~'
			&&
			c != rep_char
			&&
			!strchr(magic_chars, c)
		)
		{
			*cp++ = c;
			llen++;
			continue;
		}

		*cp++ = magic_chars[(c>>6)&3];
		c &= 077;

		if ( (c & 0x30) != 0x30 )
			c |= 0x40;

		*cp++ = c;
		llen += 2;
		continue;
	}

	if ( llen > 0 )
		*cp++ = '\r';

	dp = cbuf;
	c = cp - cbuf;

	Trace2(3, "RCwrote \"%s\"", ExpandString(dp, c));

	while ( (r = write(fd, dp, c)) != c )
	{
		if ( r <= 0 )
			return r;
		
		dp += r;
		c -= r;
	}

	return n;
}
