/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Locking.c	1.5 84/10/02
*/

/*
**	Locking primitives for Unices without them.
*/

#define	STAT_CALL

#include	"global.h"

#if	AUTO_LOCKING == 0 && FLOCK == 0 && UNISOFT_LOCKS == 0

#include	"debug.h"

#include	<errno.h>


static char *	LockName;

/*
**	If a lock file is older than LOCK_TIMEOUT it is probably bogus.
*/
#define	LOCK_TIMEOUT	(10*60)
#define	LOCK_SLEEP	(2*60)

/*
**	Absolute locking: 1 access/time.
*/

int
_Lock(file, fd, type)
	char *		file;
	register int	fd;
	Lock_t		type;
{
	register int	fib_1;
	register int	fib_2;
	register int	total;
	register int	f;
	struct stat	statb;

	if ( LockName != NULLSTR )
	{
		Fatal3("attempt to lock \"%s\" while \"%s\" exists", file, LockName);
		return SYSERROR;
	}

	LockName = concat(file, ".l", NULLSTR);

	if ( link(file, LockName) != SYSERROR )
		return 0;

	if ( errno == EACCES )
	{
		free(LockName);
		LockName = NULLSTR;

		if ( type == for_reading )
			return 0;
		else
			return SYSERROR;
	}

	if ( stat(LockName, &statb) != SYSERROR )
	{
		long		cur_time;

		(void)time(&cur_time);

		if ( cur_time - statb.st_mtime > LOCK_TIMEOUT )
		{
			Warn("timeout on lockfile %s", LockName);

			if ( unlink(LockName) == SYSERROR )
				SysWarn("could not unlink lockfile %s", LockName);
		}
	}

	fib_1 = 1;
	fib_2 = 1;
	total = 0;

	do
	{
		if ( link(file, LockName) != SYSERROR )
			return 0;

		if ( errno == EACCES )
		{
			free(LockName);
			LockName = NULLSTR;

			if ( type == for_reading )
				return 0;
			else
				return SYSERROR;
		}

		if ( errno != EEXIST )
		{
			free(LockName);
			LockName = NULLSTR;

			return SYSERROR;
		}

		(void)sleep(fib_1);

		total += fib_1;
		f = fib_1;
		fib_1 = fib_2;
		fib_2 += f;
	}
	while (total < LOCK_SLEEP);

	return SYSERROR;
}



void
_UnLock()
{
	if ( LockName != NULLSTR )
	{
		(void)unlink(LockName);
		free(LockName);
		LockName = NULLSTR;
	}
}

#else	AUTO_LOCKING == 0 && FLOCK == 0 && UNISOFT_LOCKS == 0

int
_lock()
{
}

#endif	AUTO_LOCKING == 0 && FLOCK == 0 && UNISOFT_LOCKS == 0
