/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ExpandArgs.c	1.1 84/06/12
*/

/*
**	Expand arguments containing any '&' sequences.
*/

#include	"global.h"

/*
**	External identifiers that ought to be set up.
*/

extern char *	DataName;
extern char *	HomeNode;
extern char *	LinkNode;
extern char *	SenderName;
extern char *	SourceNode;
extern char *	UserName;

static char *	select();



/*VARARGS2*/
void
ExpandArgs(to, arg)
	VarArgs	*	to;
	char *		arg;
{
	register char *	ap;
	register char *	dp;
	register char *	sp;
	register char *	cp;
	char **		app;
	register int	size;
	char *		string;

	for ( app = &arg ; (ap = ARGS_OFF_STACK(app)) != NULLSTR ; )
	{
		dp = ap;
		size = 0;

		while ( (dp = strchr(dp, '&')) != NULLSTR )
			if ( (sp = select(*++dp)) != NULLSTR )
			{
				size += strlen(sp);
				dp++;
			}

		if ( size == 0 )
		{
			NEXTARG(to) = newstr(ap);
			continue;
		}

		size += strlen(ap);

		string = sp = Malloc(size);

		while ( (dp = strchr(ap, '&')) != NULLSTR )
		{
			if ( size = dp-ap )
				sp = strncpy(sp, ap, size) + size;

			if ( (cp = select(*++dp)) != NULLSTR )
			{
				sp = strcpyend(sp, cp);
				dp++;
			}
			else
			{
				*sp++ = '&';
				*sp++ = *dp;
			}

			ap = dp;
		}

		(void)strcpy(sp, ap);

		NEXTARG(to) = string;
	}
}



static char *
select(c)
	char	c;
{
	switch ( c )
	{
	case 'D':	return DataName;
	case 'F':	return SenderName;
	case 'H':	return HomeNode;
	case 'L':	return LinkNode;
	case 'O':	return SourceNode;
	case 'U':	return UserName;
	case '&':	return "&";
	}

	return NULLSTR;
}
