/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Execute.c	1.6 84/10/30
*/

/*
**	Start a program with arguments off stack,
**	redirect all its output,
**	and wait for it to finish.
**
**	'Execute' returns a string containing the redirected output
**	if the program invoked returns any error status, otherwise NULLSTR.
*/

#define	FILE_CONTROL
#define	RECOVER

#include	"global.h"

#include	"debug.h"

extern Time_t	Time;



char *
Execute(args)
	register VarArgs *args;
{
	register int	i;
	register int	res;
	int		fd;
	int		status;
	char *		errfile;

	DODEBUG(if(NARGS(args)>MAXVARARGS)Fatal("MAXVARARGS"));

	ARG(args, NARGS(args)) = NULLSTR;

	if ( !ErrorTty(&fd) )
	{
		errfile = UniqueName(newstr(TMPDIR(error.file....)), (long)0, Time);

#		if	defined(O_CREAT)
		while ( (fd = open(errfile, O_RDWR|O_CREAT, 0600)) == SYSERROR )
#		else	defined(O_CREAT)
		while
		(
			(fd = creat(errfile, 0600)) == SYSERROR
			||
			close(fd) == SYSERROR
			||
			(fd = open(errfile, O_RDWR)) == SYSERROR
		)
#		endif	defined(O_CREAT)
			Syserror("Can't creat \"%s\"", errfile);

		(void)unlink(errfile);
		free(errfile);
	}

	for ( ;; )
	{
		switch ( i = fork() )
		{
		case SYSERROR:
			Syserror("Can't fork");
			continue;

		case 0:
			Recover(ert_finish);

			DODEBUG(EchoArgs(NARGS(args), &ARG(args, 0)));

			if ( fd == 0 )
				fd = dup(fd);	/* Make sure fd != 0 */

			for ( i = 0 ; i <= 2 ; i++ )
				if ( i != fd )
				{
					(void)close(i);

					if ( i == 0 )
						res = open("/dev/null", O_READ);
					else
						res = dup(fd);

					if ( res != i )
						exit(100+i);
				}

			for ( i = 3 ; close(i) != SYSERROR ; i++ );

			for ( ;; )
			{
				(void)execve(ARG(args, 0), &ARG(args, 0), (char **)0);
				Syserror("Cannot execve \"%s\"", ARG(args, 0));
			}
		}

		while ( (res = wait(&status)) != i )
			if ( res == SYSERROR )
			{
				Syserror("Lost child");
				return NULLSTR;
			}

		if ( ErrorTty((int *)0) )
			return NULLSTR;

		if ( status )
			return GetErrFile(args, status, fd);

#		if	DEBUG >= 1
		if
		(
			Traceflag > 0
			&&
			(errfile = GetErrFile(args, 0, fd)) != NULLSTR
		)
		{
			Trace(1, errfile);
			free(errfile);
		}
		else
#		endif	DEBUG >= 1

		(void)close(fd);

		return NULLSTR;
	}
}
